/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.lambda;

import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.svm.core.bootstrap.BootstrapMethodConfiguration;
import jdk.graal.compiler.core.common.BootstrapMethodIntrospection;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.IntrinsicContext;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class LambdaSubstrateGraphBuilderPhase
extends GraphBuilderPhase {
    public LambdaSubstrateGraphBuilderPhase(GraphBuilderConfiguration config) {
        super(config);
    }

    protected GraphBuilderPhase.Instance createInstance(CoreProviders providers, GraphBuilderConfiguration instanceGBConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
        return new LambdaSubstrateGraphBuilderInstance(providers, instanceGBConfig, optimisticOpts, initialIntrinsicContext);
    }

    public static class LambdaSubstrateGraphBuilderInstance
    extends GraphBuilderPhase.Instance {
        LambdaSubstrateGraphBuilderInstance(CoreProviders theProviders, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
            super(theProviders, graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
        }

        protected BytecodeParser createBytecodeParser(StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
            return new LambdaSubstrateBytecodeParser(this, graph, parent, method, entryBCI, intrinsicContext);
        }
    }

    public static class LambdaSubstrateBytecodeParser
    extends BytecodeParser {
        protected LambdaSubstrateBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext);
        }

        protected void genLoadConstant(int cpi, int opcode) {
            Object con = this.lookupConstant(cpi, opcode, false);
            BootstrapMethodIntrospection bootstrap = GraalServices.lookupBootstrapMethodIntrospection((ConstantPool)this.constantPool, (int)cpi, (int)-1);
            if (con == null && bootstrap != null && BootstrapMethodConfiguration.singleton().isCondyTrusted(OriginalMethodProvider.getJavaMethod((ResolvedJavaMethod)bootstrap.getMethod()))) {
                con = this.lookupConstant(cpi, opcode, true);
            }
            this.genLoadConstantHelper(con, opcode);
        }
    }
}

