/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jni;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.nodes.CEntryPointEnterNode;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIFieldId;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.EntryPointCallStubMethod;
import com.oracle.svm.hosted.jni.JNIGraphKit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.java.FrameStateBuilder;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.RawLoadNode;
import jdk.graal.compiler.nodes.extended.RawStoreNode;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.word.LocationIdentity;

public class JNIFieldAccessorMethod
extends EntryPointCallStubMethod {
    protected final JavaKind fieldKind;
    protected final boolean isSetter;
    protected final boolean isStatic;

    protected JNIFieldAccessorMethod(JavaKind fieldKind, boolean isSetter, boolean isStatic, ResolvedJavaType declaringClass, ConstantPool constantPool, MetaAccessProvider metaAccess) {
        super(JNIFieldAccessorMethod.createName(fieldKind, isSetter, isStatic), declaringClass, (Signature)JNIFieldAccessorMethod.createSignature(fieldKind, isSetter, metaAccess), constantPool);
        if (!EnumSet.of(JavaKind.Object, new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long, JavaKind.Float, JavaKind.Double}).contains(fieldKind)) {
            throw VMError.shouldNotReachHereUnexpectedInput(fieldKind);
        }
        this.fieldKind = fieldKind;
        this.isSetter = isSetter;
        this.isStatic = isStatic;
    }

    private static String createName(JavaKind fieldKind, boolean isSetter, boolean isStatic) {
        StringBuilder sb = new StringBuilder(32);
        if (isSetter) {
            sb.append("Set");
        } else {
            sb.append("Get");
        }
        if (isStatic) {
            sb.append("Static");
        }
        sb.append(fieldKind.name());
        sb.append("Field");
        return sb.toString();
    }

    private static ResolvedSignature<ResolvedJavaType> createSignature(JavaKind fieldKind, boolean isSetter, MetaAccessProvider metaAccess) {
        Class<JNIObjectHandle> valueClass = fieldKind.toJavaClass();
        if (fieldKind.isObject()) {
            valueClass = JNIObjectHandle.class;
        }
        ResolvedJavaType objectHandle = metaAccess.lookupJavaType(JNIObjectHandle.class);
        ArrayList<ResolvedJavaType> args = new ArrayList<ResolvedJavaType>();
        args.add(metaAccess.lookupJavaType(JNIEnvironment.class));
        args.add(objectHandle);
        args.add(metaAccess.lookupJavaType(JNIFieldId.class));
        if (isSetter) {
            args.add(metaAccess.lookupJavaType(valueClass));
        }
        ResolvedJavaType returnType = isSetter ? metaAccess.lookupJavaType(Void.TYPE) : metaAccess.lookupJavaType(valueClass);
        return ResolvedSignature.fromList(args, (ResolvedJavaType)returnType);
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        JNIGraphKit kit = new JNIGraphKit(debug, providers, (ResolvedJavaMethod)method);
        ValueNode vmThread = kit.loadLocal(0, this.getSignature().getParameterKind(0));
        kit.append((Node)CEntryPointEnterNode.enter(vmThread));
        ValueNode returnValue = this.buildGraphBody(kit, kit.getInitialArguments(), kit.getFrameState(), (MetaAccessProvider)kit.getMetaAccess());
        kit.appendStateSplitProxy();
        CEntryPointLeaveNode leave = new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.Leave);
        kit.append((Node)leave);
        JavaKind returnKind = this.isSetter ? JavaKind.Void : this.fieldKind;
        kit.createReturn(returnValue, returnKind);
        return kit.finalizeGraph();
    }

    protected ValueNode buildGraphBody(JNIGraphKit kit, List<ValueNode> arguments, FrameStateBuilder state, MetaAccessProvider metaAccess) {
        ValueNode returnValue;
        InvokeWithExceptionNode object;
        if (this.isStatic) {
            object = this.fieldKind.isPrimitive() ? kit.getStaticPrimitiveFieldsArray() : kit.getStaticObjectFieldsArray();
        } else {
            ValueNode handle = arguments.get(1);
            object = kit.unboxHandle(handle);
        }
        ValueNode fieldId = arguments.get(2);
        InvokeWithExceptionNode offset = kit.getFieldOffsetFromId(fieldId);
        if (this.isSetter) {
            returnValue = null;
            ValueNode newValue = arguments.get(3);
            if (this.fieldKind.isObject()) {
                newValue = kit.unboxHandle(newValue);
            }
            kit.append((Node)new RawStoreNode((ValueNode)object, (ValueNode)offset, newValue, this.fieldKind, LocationIdentity.ANY_LOCATION));
        } else {
            returnValue = (ValueNode)kit.append((Node)new RawLoadNode((ValueNode)object, (ValueNode)offset, this.fieldKind, LocationIdentity.ANY_LOCATION));
            if (this.fieldKind.isObject()) {
                returnValue = kit.boxObjectInLocalHandle(returnValue);
            }
        }
        return returnValue;
    }

    public CEntryPointData createEntryPointData() {
        return CEntryPointData.create(this, "", CEntryPointData.DEFAULT_NAME_TRANSFORMATION, "", CEntryPointOptions.NoPrologue.class, CEntryPointOptions.AutomaticPrologueBailout.class, CEntryPointOptions.NoEpilogue.class, CEntryPoint.FatalExceptionHandler.class, CEntryPoint.Publish.NotPublished);
    }

    public static class Factory {
        public JNIFieldAccessorMethod create(JavaKind kind, boolean isSetter, boolean isStatic, ResolvedJavaType generatedMethodClass, ConstantPool constantPool, MetaAccessProvider wrappedMetaAccess) {
            return new JNIFieldAccessorMethod(kind, isSetter, isStatic, generatedMethodClass, constantPool, wrappedMetaAccess);
        }
    }
}

