/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstratePlatformConfigurationProvider;
import com.oracle.svm.core.graal.code.SubstrateRegisterConfigFactory;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.graal.meta.SubstrateStampProvider;
import com.oracle.svm.core.graal.word.SubstrateWordTypes;
import com.oracle.svm.hosted.HostedConfiguration;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.function.Function;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.spi.ConstantFieldProvider;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.nodes.spi.LoopsDataProvider;
import jdk.graal.compiler.nodes.spi.LoweringProvider;
import jdk.graal.compiler.nodes.spi.PlatformConfigurationProvider;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.nodes.spi.StampProvider;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.printer.GraalDebugHandlersFactory;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class SharedRuntimeConfigurationBuilder {
    protected final OptionValues options;
    protected final SVMHost hostVM;
    protected final UniverseMetaAccess metaAccess;
    protected final Function<Providers, SubstrateBackend> backendProvider;
    protected final ClassInitializationSupport classInitializationSupport;
    protected final LoopsDataProvider originalLoopsDataProvider;
    protected final SubstratePlatformConfigurationProvider platformConfig;
    protected final SnippetReflectionProvider snippetReflection;

    public SharedRuntimeConfigurationBuilder(OptionValues options, SVMHost hostVM, UniverseMetaAccess metaAccess, Function<Providers, SubstrateBackend> backendProvider, ClassInitializationSupport classInitializationSupport, LoopsDataProvider originalLoopsDataProvider, SubstratePlatformConfigurationProvider platformConfig, SnippetReflectionProvider snippetReflection) {
        this.options = options;
        this.hostVM = hostVM;
        this.metaAccess = metaAccess;
        this.backendProvider = backendProvider;
        this.classInitializationSupport = classInitializationSupport;
        this.originalLoopsDataProvider = originalLoopsDataProvider;
        this.platformConfig = platformConfig;
        this.snippetReflection = snippetReflection;
    }

    public final RuntimeConfiguration build() {
        EnumMap<SubstrateRegisterConfig.ConfigKind, RegisterConfig> registerConfigs = new EnumMap<SubstrateRegisterConfig.ConfigKind, RegisterConfig>(SubstrateRegisterConfig.ConfigKind.class);
        ConstantReflectionProvider constantReflection = this.createConstantReflectionProvider();
        ConstantFieldProvider constantFieldProvider = this.createConstantFieldProvider();
        for (SubstrateRegisterConfig.ConfigKind config : SubstrateRegisterConfig.ConfigKind.values()) {
            registerConfigs.put(config, ((SubstrateRegisterConfigFactory)ImageSingletons.lookup(SubstrateRegisterConfigFactory.class)).newRegisterFactory(config, (MetaAccessProvider)this.metaAccess, ConfigurationValues.getTarget(), SubstrateOptions.PreserveFramePointer.getValue()));
        }
        SubstrateWordTypes wordTypes = new SubstrateWordTypes((MetaAccessProvider)this.metaAccess, FrameAccess.getWordKind());
        ForeignCallsProvider foreignCalls = this.createForeignCallsProvider((RegisterConfig)registerConfigs.get((Object)SubstrateRegisterConfig.ConfigKind.NORMAL));
        MetaAccessExtensionProvider metaAccessExtensionProvider = HostedConfiguration.instance().createCompilationMetaAccessExtensionProvider((MetaAccessProvider)this.metaAccess);
        StampProvider stampProvider = this.createStampProvider();
        LoweringProvider lowerer = this.createLoweringProvider(foreignCalls, metaAccessExtensionProvider);
        LoopsDataProvider loopsDataProvider = this.originalLoopsDataProvider;
        Providers p = this.createProviders(null, constantReflection, constantFieldProvider, foreignCalls, lowerer, null, stampProvider, this.snippetReflection, this.platformConfig, metaAccessExtensionProvider, wordTypes, loopsDataProvider);
        Replacements replacements = this.createReplacements(p, this.snippetReflection);
        p = (Providers)replacements.getProviders();
        EnumMap<SubstrateRegisterConfig.ConfigKind, SubstrateBackend> backends = new EnumMap<SubstrateRegisterConfig.ConfigKind, SubstrateBackend>(SubstrateRegisterConfig.ConfigKind.class);
        for (SubstrateRegisterConfig.ConfigKind config : SubstrateRegisterConfig.ConfigKind.values()) {
            CodeCacheProvider codeCacheProvider = this.createCodeCacheProvider((RegisterConfig)registerConfigs.get((Object)config));
            Providers newProviders = this.createProviders(codeCacheProvider, constantReflection, constantFieldProvider, foreignCalls, lowerer, replacements, stampProvider, this.snippetReflection, this.platformConfig, metaAccessExtensionProvider, wordTypes, loopsDataProvider);
            backends.put(config, GraalConfiguration.runtimeInstance().createBackend(newProviders));
        }
        ArrayList<DebugHandlersFactory> handlers = new ArrayList<DebugHandlersFactory>();
        for (DebugHandlersFactory factory : GraalServices.load(DebugHandlersFactory.class)) {
            if (factory instanceof GraalDebugHandlersFactory) {
                handlers.add((DebugHandlersFactory)new GraalDebugHandlersFactory(this.snippetReflection));
                continue;
            }
            handlers.add(factory);
        }
        return new RuntimeConfiguration(p, this.snippetReflection, backends, handlers);
    }

    protected abstract Providers createProviders(CodeCacheProvider var1, ConstantReflectionProvider var2, ConstantFieldProvider var3, ForeignCallsProvider var4, LoweringProvider var5, Replacements var6, StampProvider var7, SnippetReflectionProvider var8, PlatformConfigurationProvider var9, MetaAccessExtensionProvider var10, WordTypes var11, LoopsDataProvider var12);

    protected abstract ConstantReflectionProvider createConstantReflectionProvider();

    protected abstract ConstantFieldProvider createConstantFieldProvider();

    private ForeignCallsProvider createForeignCallsProvider(RegisterConfig registerConfig) {
        return new SubstrateForeignCallsProvider((MetaAccessProvider)this.metaAccess, registerConfig);
    }

    private StampProvider createStampProvider() {
        return new SubstrateStampProvider((MetaAccessProvider)this.metaAccess);
    }

    protected abstract LoweringProvider createLoweringProvider(ForeignCallsProvider var1, MetaAccessExtensionProvider var2);

    protected abstract Replacements createReplacements(Providers var1, SnippetReflectionProvider var2);

    protected abstract CodeCacheProvider createCodeCacheProvider(RegisterConfig var1);
}

