/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.libc;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.c.libc.HostedLibCBase;
import java.util.ServiceLoader;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class HostedLibCFeature
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return HostedLibCBase.isPlatformEquivalent(Platform.LINUX.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        String targetLibC = SubstrateOptions.UseLibC.getValue();
        ServiceLoader<HostedLibCBase> loader = ServiceLoader.load(HostedLibCBase.class);
        for (HostedLibCBase libc : loader) {
            if (!libc.getName().equals(targetLibC)) continue;
            libc.checkIfLibCSupported();
            ImageSingletons.add(LibCBase.class, (Object)libc);
            return;
        }
        throw UserError.abort("Unknown libc %s selected. Please use one of the available libc implementations.", targetLibC);
    }
}

