/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.substitutions;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalCompilerSupport;
import com.oracle.svm.graal.hosted.GraalCompilerFeature;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;

@TargetClass(value=LIRInstructionClass.class, onlyWith={GraalCompilerFeature.IsEnabled.class})
final class Target_jdk_graal_compiler_lir_LIRInstructionClass {
    Target_jdk_graal_compiler_lir_LIRInstructionClass() {
    }

    @Substitute
    @SuppressFBWarnings(value={"GC_UNRELATED_TYPES"}, justification="Class is DynamicHub")
    public static LIRInstructionClass<?> get(Class<? extends LIRInstruction> clazz) {
        LIRInstructionClass instructionClass = (LIRInstructionClass)GraalCompilerSupport.get().instructionClasses.get(clazz);
        if (instructionClass == null) {
            throw VMError.shouldNotReachHere(String.format("Unknown instruction class: %s%n", clazz.getName()));
        }
        return instructionClass;
    }
}

