/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.monitor.MonitorInflationCause;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_java_lang_VirtualThread;
import com.oracle.svm.core.thread.Target_sun_nio_ch_Interruptible;

final class VirtualThreadHelper {
    static void blockedOn(Target_sun_nio_ch_Interruptible b) {
        Target_java_lang_VirtualThread self = VirtualThreadHelper.asVTarget(Thread.currentThread());
        Object token = VirtualThreadHelper.acquireInterruptLockMaybeSwitch(self);
        try {
            self.nioBlocker = b;
        }
        finally {
            VirtualThreadHelper.releaseInterruptLockMaybeSwitchBack(self, token);
        }
    }

    static Object acquireInterruptLockMaybeSwitch(Target_java_lang_VirtualThread self) {
        Target_java_lang_VirtualThread token = null;
        if (SubstrateUtil.cast(self, Object.class) == Thread.currentThread()) {
            Thread carrier = self.carrierThread;
            JavaThreads.setCurrentThread(carrier, carrier);
            token = self;
        }
        Object lock = VirtualThreadHelper.asTarget((Object)self).interruptLock;
        MonitorSupport.singleton().monitorEnter(lock, MonitorInflationCause.VM_INTERNAL);
        return token;
    }

    static void releaseInterruptLockMaybeSwitchBack(Target_java_lang_VirtualThread self, Object token) {
        Object lock = VirtualThreadHelper.asTarget((Object)self).interruptLock;
        MonitorSupport.singleton().monitorExit(lock, MonitorInflationCause.VM_INTERNAL);
        if (token != null) {
            assert (token == self);
            Thread carrier = VirtualThreadHelper.asVTarget((Object)token).carrierThread;
            assert (Thread.currentThread() == carrier);
            JavaThreads.setCurrentThread(carrier, VirtualThreadHelper.asThread(token));
        }
    }

    static Target_java_lang_VirtualThread asVTarget(Object obj) {
        return (Target_java_lang_VirtualThread)obj;
    }

    static Target_java_lang_Thread asTarget(Object obj) {
        return (Target_java_lang_Thread)obj;
    }

    static Thread asThread(Object obj) {
        return (Thread)obj;
    }

    private VirtualThreadHelper() {
    }
}

