/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.sampler.SamplerBuffer;
import com.oracle.svm.core.sampler.SamplerBufferAccess;
import com.oracle.svm.core.sampler.SamplerSampleWriter;
import com.oracle.svm.core.sampler.SamplerStackTraceSerializer;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class SamplerBuffersAccess {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private SamplerBuffersAccess() {
    }

    @Uninterruptible(reason="Prevent JFR recording.")
    public static void processActiveBuffers() {
        assert (VMOperation.isInProgressAtSafepoint());
        IsolateThread thread = VMThreads.firstThread();
        while (thread.isNonNull()) {
            SamplerBuffer buffer = JfrThreadLocal.getSamplerBuffer(thread);
            if (buffer.isNonNull()) {
                SamplerBuffersAccess.serializeStackTraces(buffer);
                assert (JfrThreadLocal.getSamplerBuffer(thread) == buffer);
            }
            thread = VMThreads.nextThread(thread);
        }
    }

    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    public static void processFullBuffers(boolean useSafepointChecks) {
        SamplerBuffer buffer;
        while (!(buffer = SubstrateJVM.getSamplerBufferPool().popFullBuffer()).isNull()) {
            SamplerBuffersAccess.serializeStackTraces(buffer);
            SubstrateJVM.getSamplerBufferPool().releaseBuffer(buffer);
            if (!useSafepointChecks) continue;
            SamplerBuffersAccess.safepointCheck();
        }
        SubstrateJVM.getSamplerBufferPool().adjustBufferCount();
    }

    @Uninterruptible(reason="The callee explicitly does a safepoint check.", calleeMustBe=false)
    private static void safepointCheck() {
        SamplerBuffersAccess.safepointCheck0();
    }

    private static void safepointCheck0() {
    }

    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    private static void serializeStackTraces(SamplerBuffer rawStackTraceBuffer) {
        assert (rawStackTraceBuffer.isNonNull());
        Pointer end = rawStackTraceBuffer.getPos();
        Pointer current = SamplerBufferAccess.getDataStart(rawStackTraceBuffer);
        while (current.belowThan((UnsignedWord)end)) {
            Pointer entryStart = current;
            assert (entryStart.unsignedRemainder(8).equal(0));
            int sampleHash = current.readInt(0);
            boolean isTruncated = (current = current.add(4)).readInt(0) == 1;
            current = current.add(4);
            int sampleSize = current.readInt(0);
            current = current.add(4);
            current = current.add(4);
            long sampleTick = current.readLong(0);
            current = current.add(8);
            long threadId = current.readLong(0);
            current = current.add(8);
            long threadState = current.readLong(0);
            current = current.add(8);
            assert (current.subtract((UnsignedWord)entryStart).equal(SamplerSampleWriter.getHeaderSize()));
            current = SamplerBuffersAccess.serializeStackTrace(current, end, sampleSize, sampleHash, isTruncated, sampleTick, threadId, threadState);
        }
        SamplerBufferAccess.reinitialize(rawStackTraceBuffer);
    }

    @Uninterruptible(reason="Wraps the call to the possibly interruptible serializer.", calleeMustBe=false)
    private static Pointer serializeStackTrace(Pointer rawStackTrace, Pointer bufferEnd, int sampleSize, int sampleHash, boolean isTruncated, long sampleTick, long threadId, long threadState) {
        return SamplerStackTraceSerializer.singleton().serializeStackTrace(rawStackTrace, bufferEnd, sampleSize, sampleHash, isTruncated, sampleTick, threadId, threadState);
    }
}

