/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.monitor;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.WeakIdentityHashMap;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubCompanion;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.events.JavaMonitorInflateEvent;
import com.oracle.svm.core.monitor.JavaMonitor;
import com.oracle.svm.core.monitor.JavaMonitorQueuedSynchronizer;
import com.oracle.svm.core.monitor.MonitorInflationCause;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.monitor.Target_jdk_internal_misc_Blocker;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.util.VMError;
import java.io.FileDescriptor;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.word.BarrieredAccess;
import jdk.internal.misc.Unsafe;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class MultiThreadedMonitorSupport
extends MonitorSupport {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final Map<Class<?>, Boolean> FORCE_MONITOR_SLOT_TYPES;
    private final Map<Object, JavaMonitor> additionalMonitors = new WeakIdentityHashMap<Object, JavaMonitor>();
    private final ReentrantLock additionalMonitorsLock = new ReentrantLock();
    protected static final String NO_LONGER_UNINTERRUPTIBLE = "The monitor snippet slow path is uninterruptible to avoid stack overflow errors being thrown. Now the yellow zone is enabled and we are no longer uninterruptible, and allocation is allowed again too";

    @Override
    public int getParkedThreadStatus(Thread thread, boolean timed) {
        Object blocker = LockSupport.getBlocker(thread);
        if (blocker instanceof JavaMonitorQueuedSynchronizer.JavaMonitorConditionObject) {
            return timed ? 417 : 401;
        }
        if (blocker instanceof JavaMonitor) {
            return 1025;
        }
        return timed ? 673 : 657;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="Avoid stack overflow error before yellow zone has been activated", calleeMustBe=false)
    private static void slowPathMonitorEnter(Object obj) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        VMOperationControl.guaranteeOkayToBlock("No Java synchronization must be performed within a VMOperation: if the object is already locked, the VM is deadlocked");
        try {
            MultiThreadedMonitorSupport.singleton().monitorEnter(obj, MonitorInflationCause.MONITOR_ENTER);
        }
        catch (OutOfMemoryError ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere("Unexpected exception in MonitorSupport.monitorEnter", ex);
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @Override
    @RestrictHeapAccess(reason="The monitor snippet slow path is uninterruptible to avoid stack overflow errors being thrown. Now the yellow zone is enabled and we are no longer uninterruptible, and allocation is allowed again too", access=RestrictHeapAccess.Access.UNRESTRICTED)
    public void monitorEnter(Object obj, MonitorInflationCause cause) {
        JavaMonitor monitor;
        int monitorOffset = MultiThreadedMonitorSupport.getMonitorOffset(obj);
        if (monitorOffset != 0) {
            long current = JavaMonitor.getCurrentThreadIdentity();
            monitor = (JavaMonitor)BarrieredAccess.readObject((Object)obj, (int)monitorOffset);
            if (monitor == null) {
                long startTicks = JfrTicks.elapsedTicks();
                JavaMonitor newMonitor = this.newMonitorLock();
                newMonitor.setState(current);
                monitor = (JavaMonitor)UNSAFE.compareAndExchangeReference(obj, monitorOffset, null, newMonitor);
                if (monitor == null) {
                    JavaMonitorInflateEvent.emit(obj, startTicks, MonitorInflationCause.MONITOR_ENTER);
                    newMonitor.latestJfrTid = current;
                    return;
                }
            }
        } else {
            monitor = this.getOrCreateMonitor(obj, cause);
        }
        monitor.monitorEnter(obj);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="Avoid stack overflow error before yellow zone has been activated", calleeMustBe=false)
    private static void slowPathMonitorExit(Object obj) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            MultiThreadedMonitorSupport.singleton().monitorExit(obj, MonitorInflationCause.VM_INTERNAL);
        }
        catch (OutOfMemoryError ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere("Unexpected exception in MonitorSupport.monitorExit", ex);
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @Override
    @RestrictHeapAccess(reason="The monitor snippet slow path is uninterruptible to avoid stack overflow errors being thrown. Now the yellow zone is enabled and we are no longer uninterruptible, and allocation is allowed again too", access=RestrictHeapAccess.Access.UNRESTRICTED)
    public void monitorExit(Object obj, MonitorInflationCause cause) {
        int monitorOffset = MultiThreadedMonitorSupport.getMonitorOffset(obj);
        JavaMonitor monitor = monitorOffset != 0 ? (JavaMonitor)BarrieredAccess.readObject((Object)obj, (int)monitorOffset) : this.getOrCreateMonitor(obj, cause);
        monitor.monitorExit();
    }

    @Override
    public Object prepareRelockObject(Object obj) {
        return this.getOrCreateMonitor(obj, MonitorInflationCause.VM_INTERNAL);
    }

    @Override
    @Uninterruptible(reason="called during deoptimization")
    public void doRelockObject(Object obj, Object lockData) {
        JavaMonitor lock = (JavaMonitor)lockData;
        lock.relockObject();
    }

    @Override
    public boolean isLockedByCurrentThread(Object obj) {
        JavaMonitor lockObject = this.getMonitor(obj);
        return lockObject != null && lockObject.isHeldByCurrentThread();
    }

    @Override
    public boolean isLockedByAnyThread(Object obj) {
        JavaMonitor lockObject = this.getMonitor(obj);
        return lockObject != null && lockObject.isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"WA_AWAIT_NOT_IN_LOOP"}, justification="This method is a wait implementation.")
    protected void doWait(Object obj, long timeoutMillis) throws InterruptedException {
        long compensation = -1L;
        boolean pinned = JavaThreads.isCurrentThreadVirtualAndPinned();
        if (pinned) {
            compensation = Target_jdk_internal_misc_Blocker.begin();
        }
        try {
            JavaMonitor lock = this.ensureLocked(obj, MonitorInflationCause.WAIT);
            JavaMonitorQueuedSynchronizer.JavaMonitorConditionObject condition = lock.getOrCreateCondition(true);
            if (timeoutMillis == 0L) {
                condition.await(obj);
            } else {
                condition.await(obj, timeoutMillis, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            if (pinned) {
                Target_jdk_internal_misc_Blocker.end(compensation);
            }
        }
    }

    @Override
    public void notify(Object obj, boolean notifyAll) {
        JavaMonitor lock = this.ensureLocked(obj, MonitorInflationCause.NOTIFY);
        JavaMonitorQueuedSynchronizer.JavaMonitorConditionObject condition = lock.getOrCreateCondition(false);
        if (condition != null) {
            if (notifyAll) {
                condition.signalAll();
            } else {
                condition.signal();
            }
        }
    }

    protected JavaMonitor ensureLocked(Object obj, MonitorInflationCause cause) {
        JavaMonitor lockObject = this.getOrCreateMonitor(obj, cause);
        if (!lockObject.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Receiver is not locked by the current thread.");
        }
        return lockObject;
    }

    protected static int getMonitorOffset(Object obj) {
        return DynamicHub.fromClass(obj.getClass()).getMonitorOffset();
    }

    protected static Object replaceObject(Object unreplacedObject) {
        if (unreplacedObject instanceof DynamicHub) {
            return ((DynamicHub)unreplacedObject).getCompanion();
        }
        return unreplacedObject;
    }

    protected final JavaMonitor getMonitor(Object obj) {
        return this.getOrCreateMonitor(obj, false, null);
    }

    protected final JavaMonitor getOrCreateMonitor(Object obj, MonitorInflationCause cause) {
        return this.getOrCreateMonitor(obj, true, cause);
    }

    private JavaMonitor getOrCreateMonitor(Object obj, boolean createIfNotExisting, MonitorInflationCause cause) {
        int monitorOffset = MultiThreadedMonitorSupport.getMonitorOffset(obj);
        if (monitorOffset != 0) {
            return this.getOrCreateMonitorFromObject(obj, createIfNotExisting, monitorOffset, cause);
        }
        return this.getOrCreateMonitorSlow(obj, createIfNotExisting, cause);
    }

    private JavaMonitor getOrCreateMonitorSlow(Object unreplacedObject, boolean createIfNotExisting, MonitorInflationCause cause) {
        int monitorOffset;
        Object replacedObject = MultiThreadedMonitorSupport.replaceObject(unreplacedObject);
        if (replacedObject != unreplacedObject && (monitorOffset = MultiThreadedMonitorSupport.getMonitorOffset(replacedObject)) != 0) {
            return this.getOrCreateMonitorFromObject(replacedObject, createIfNotExisting, monitorOffset, cause);
        }
        return this.getOrCreateMonitorFromMap(replacedObject, createIfNotExisting, cause);
    }

    protected JavaMonitor getOrCreateMonitorFromObject(Object obj, boolean createIfNotExisting, int monitorOffset, MonitorInflationCause cause) {
        JavaMonitor existingMonitor = (JavaMonitor)BarrieredAccess.readObject((Object)obj, (int)monitorOffset);
        if (existingMonitor != null || !createIfNotExisting) {
            return existingMonitor;
        }
        long startTicks = JfrTicks.elapsedTicks();
        JavaMonitor newMonitor = this.newMonitorLock();
        if (UNSAFE.compareAndSetObject(obj, monitorOffset, null, newMonitor)) {
            JavaMonitorInflateEvent.emit(obj, startTicks, cause);
            return newMonitor;
        }
        return (JavaMonitor)BarrieredAccess.readObject((Object)obj, (int)monitorOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaMonitor getOrCreateMonitorFromMap(Object obj, boolean createIfNotExisting, MonitorInflationCause cause) {
        VMError.guarantee(!this.additionalMonitorsLock.isHeldByCurrentThread(), "Recursive manipulation of the additionalMonitors map can lead to table corruptions and double insertion of a monitor for the same object");
        this.additionalMonitorsLock.lock();
        try {
            JavaMonitor existingMonitor = this.additionalMonitors.get(obj);
            if (existingMonitor != null || !createIfNotExisting) {
                JavaMonitor javaMonitor = existingMonitor;
                return javaMonitor;
            }
            long startTicks = JfrTicks.elapsedTicks();
            JavaMonitor newMonitor = this.newMonitorLock();
            JavaMonitor previousEntry = this.additionalMonitors.put(obj, newMonitor);
            VMError.guarantee(previousEntry == null, "Replaced monitor in secondary storage map");
            JavaMonitorInflateEvent.emit(obj, startTicks, cause);
            JavaMonitor javaMonitor = newMonitor;
            return javaMonitor;
        }
        finally {
            this.additionalMonitorsLock.unlock();
        }
    }

    protected JavaMonitor newMonitorLock() {
        return new JavaMonitor();
    }

    static {
        try {
            HashMap monitorTypes = new HashMap();
            monitorTypes.put(ReferenceQueue.class, false);
            monitorTypes.put(FileDescriptor.class, false);
            monitorTypes.put(Object.class, false);
            monitorTypes.put(Class.forName("com.oracle.svm.core.jdk.SplittableRandomAccessors"), false);
            monitorTypes.put(Class.forName("jdk.internal.ref.PhantomCleanable"), false);
            monitorTypes.put(DynamicHubCompanion.class, false);
            monitorTypes.put(Thread.class, true);
            FORCE_MONITOR_SLOT_TYPES = Collections.unmodifiableMap(monitorTypes);
        }
        catch (ClassNotFoundException e) {
            throw VMError.shouldNotReachHere("Error building the list of types that always need a monitor slot.", e);
        }
    }
}

