/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.thread;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.graal.nodes.FloatingWordCastNode;
import com.oracle.svm.core.graal.thread.VMThreadLocalAccess;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public class AddressOfVMThreadLocalNode
extends FloatingNode
implements VMThreadLocalAccess,
Lowerable {
    public static final NodeClass<AddressOfVMThreadLocalNode> TYPE = NodeClass.create(AddressOfVMThreadLocalNode.class);
    protected final VMThreadLocalInfo threadLocalInfo;
    @Node.Input
    protected ValueNode holder;

    public AddressOfVMThreadLocalNode(VMThreadLocalInfo threadLocalInfo, ValueNode holder) {
        super(TYPE, FrameAccess.getWordStamp());
        this.threadLocalInfo = threadLocalInfo;
        this.holder = holder;
    }

    public void lower(LoweringTool tool) {
        assert (this.threadLocalInfo.offset >= 0);
        ValueNode base = this.holder;
        if (base.getStackKind() == JavaKind.Object) {
            base = (ValueNode)this.graph().unique((Node)new FloatingWordCastNode(FrameAccess.getWordStamp(), base));
        }
        assert (base.getStackKind() == FrameAccess.getWordKind());
        ConstantNode offset = ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)this.threadLocalInfo.offset, (StructuredGraph)this.graph());
        ValueNode address = (ValueNode)this.graph().unique((Node)new AddNode(base, (ValueNode)offset));
        this.replaceAtUsagesAndDelete((Node)address);
    }
}

