/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.replacements;

import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.meta.SubstrateLoweringProvider;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.nodes.CFunctionCaptureNode;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.java.FrameStateBuilder;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.IndirectCallTargetNode;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.extended.FixedValueAnchorNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.StateSplitProxyNode;
import jdk.graal.compiler.nodes.extended.UnboxNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.GraphKit;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public class SubstrateGraphKit
extends GraphKit {
    private final FrameStateBuilder frameState;
    private int nextBCI;
    private final List<ValueNode> arguments;

    public SubstrateGraphKit(DebugContext debug, ResolvedJavaMethod stubMethod, Providers providers, GraphBuilderConfiguration.Plugins graphBuilderPlugins, CompilationIdentifier compilationId, boolean recordInlinedMethods) {
        super(debug, stubMethod, providers, graphBuilderPlugins, compilationId, null, true, recordInlinedMethods);
        assert (this.getWordTypes() != null) : "Support for Word types is mandatory";
        this.frameState = new FrameStateBuilder((GraphBuilderTool)this, stubMethod, this.graph);
        this.frameState.disableKindVerification();
        this.frameState.disableStateVerification();
        ArrayList collectedArguments = new ArrayList();
        this.frameState.initializeForMethodStart(null, true, graphBuilderPlugins, collectedArguments);
        this.arguments = Collections.unmodifiableList(collectedArguments);
        this.graph.start().setStateAfter(this.frameState.create(this.bci(), (StateSplit)this.graph.start()));
    }

    public SubstrateGraphKit(DebugContext debug, ResolvedJavaMethod stubMethod, Providers providers, GraphBuilderConfiguration.Plugins graphBuilderPlugins, CompilationIdentifier compilationId) {
        this(debug, stubMethod, providers, graphBuilderPlugins, compilationId, false);
    }

    public MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, StampPair returnStamp, int bci) {
        return new SubstrateMethodCallTargetNode(invokeKind, targetMethod, args, returnStamp);
    }

    public SubstrateLoweringProvider getLoweringProvider() {
        return (SubstrateLoweringProvider)this.getLowerer();
    }

    public FrameStateBuilder getFrameState() {
        return this.frameState;
    }

    public ValueNode loadLocal(int index, JavaKind slotKind) {
        return this.frameState.loadLocal(index, slotKind);
    }

    public void storeLocal(int index, JavaKind slotKind, ValueNode value) {
        this.frameState.storeLocal(index, slotKind, value);
    }

    public List<ValueNode> getInitialArguments() {
        return this.arguments;
    }

    public LoadFieldNode createLoadField(ValueNode object, ResolvedJavaField field) {
        return (LoadFieldNode)this.append((Node)LoadFieldNode.create(null, (ValueNode)object, (ResolvedJavaField)field));
    }

    public ValueNode createLoadIndexed(ValueNode array, int index, JavaKind kind, GuardingNode boundsCheck) {
        return this.createLoadIndexed(array, (ValueNode)ConstantNode.forInt((int)index, (StructuredGraph)this.getGraph()), kind, boundsCheck);
    }

    public ValueNode createLoadIndexed(ValueNode array, ValueNode index, JavaKind kind, GuardingNode boundsCheck) {
        ValueNode loadIndexed = LoadIndexedNode.create(null, (ValueNode)array, (ValueNode)index, (GuardingNode)boundsCheck, (JavaKind)kind, (MetaAccessProvider)this.getMetaAccess(), (ConstantReflectionProvider)this.getConstantReflection());
        if (loadIndexed instanceof FixedNode) {
            return (ValueNode)this.append((Node)((FixedNode)loadIndexed));
        }
        return this.unique((FloatingNode)loadIndexed);
    }

    public ValueNode createStoreIndexed(ValueNode array, int index, JavaKind kind, ValueNode value) {
        return (ValueNode)this.append((Node)new StoreIndexedNode(array, (ValueNode)ConstantNode.forInt((int)index, (StructuredGraph)this.getGraph()), null, null, kind, value));
    }

    public ValueNode createUnboxing(ValueNode boxed, JavaKind targetKind) {
        return (ValueNode)this.append((Node)new UnboxNode(boxed, targetKind, this.getMetaAccess()));
    }

    public ValueNode createInvokeWithExceptionAndUnwind(Class<?> declaringClass, String name, CallTargetNode.InvokeKind invokeKind, ValueNode ... args) {
        return this.createInvokeWithExceptionAndUnwind(this.findMethod(declaringClass, name, invokeKind == CallTargetNode.InvokeKind.Static), invokeKind, this.frameState, this.bci(), args);
    }

    public InvokeWithExceptionNode createJavaCallWithException(CallTargetNode.InvokeKind kind, ResolvedJavaMethod targetMethod, ValueNode ... arguments) {
        return this.startInvokeWithException(targetMethod, kind, this.frameState, this.bci(), arguments);
    }

    public InvokeWithExceptionNode createJavaCallWithExceptionAndUnwind(CallTargetNode.InvokeKind kind, ResolvedJavaMethod targetMethod, ValueNode ... arguments) {
        return this.createInvokeWithExceptionAndUnwind(targetMethod, kind, this.frameState, this.bci(), arguments);
    }

    public ConstantNode createConstant(Constant value, JavaKind kind) {
        return ConstantNode.forConstant((Stamp)StampFactory.forKind((JavaKind)kind), (Constant)value, (MetaAccessProvider)this.getMetaAccess(), (StructuredGraph)this.getGraph());
    }

    public ValueNode createCFunctionCall(ValueNode targetAddress, List<ValueNode> arguments, Signature signature, int newThreadStatus, boolean emitDeoptTarget) {
        return this.createCFunctionCallWithCapture(targetAddress, arguments, signature, newThreadStatus, emitDeoptTarget, SubstrateCallingConventionKind.Native.toType(true), null, null, null);
    }

    public ValueNode createCFunctionCallWithCapture(ValueNode targetAddress, List<ValueNode> arguments, Signature signature, int newThreadStatus, boolean emitDeoptTarget, CallingConvention.Type convention, ForeignCallDescriptor captureFunction, ValueNode statesToCapture, ValueNode captureBuffer) {
        boolean emitTransition;
        assert (captureFunction == null && statesToCapture == null && captureBuffer == null || captureFunction != null && statesToCapture != null && captureBuffer != null);
        ValueNode fixedStatesToCapture = statesToCapture;
        if (fixedStatesToCapture != null) {
            fixedStatesToCapture = (ValueNode)this.append((Node)new FixedValueAnchorNode(fixedStatesToCapture));
        }
        if (emitTransition = VMThreads.StatusSupport.isValidStatus(newThreadStatus)) {
            this.append((Node)new CFunctionPrologueNode(newThreadStatus));
        }
        JavaKind javaReturnKind = signature.getReturnKind();
        JavaKind cReturnKind = javaReturnKind.getStackKind();
        JavaType returnType = signature.getReturnType(null);
        Stamp returnStamp = this.returnStamp(returnType, cReturnKind);
        InvokeNode invoke = this.createIndirectCall(targetAddress, arguments, signature.toParameterTypes(null), returnStamp, cReturnKind, convention);
        if (fixedStatesToCapture != null) {
            this.append((Node)new CFunctionCaptureNode(captureFunction, fixedStatesToCapture, captureBuffer));
        }
        assert (!emitDeoptTarget || !emitTransition) : "cannot have transition for deoptimization targets";
        if (emitTransition) {
            CFunctionEpilogueNode epilogue = new CFunctionEpilogueNode(newThreadStatus);
            this.append((Node)epilogue);
            epilogue.setStateAfter(invoke.stateAfter().duplicateWithVirtualState());
        } else if (emitDeoptTarget) {
            int bci = invoke.stateAfter().bci;
            this.appendWithUnwind(DeoptEntryNode.create(invoke.bci()), bci);
        }
        InvokeNode result = invoke;
        if (javaReturnKind != cReturnKind) {
            assert (javaReturnKind.getByteCount() < cReturnKind.getByteCount());
            result = (ValueNode)this.append((Node)new NarrowNode((ValueNode)result, javaReturnKind.getByteCount() << 3));
        }
        return this.getLoweringProvider().implicitLoadConvertWithBooleanCoercionIfNecessary(this.getGraph(), this.asKind(returnType), (ValueNode)result);
    }

    public InvokeNode createIndirectCall(ValueNode targetAddress, List<ValueNode> arguments, Signature signature, SubstrateCallingConventionKind callKind) {
        assert (arguments.size() == signature.getParameterCount(false));
        assert (callKind != SubstrateCallingConventionKind.Native) : "return kind and stamp would be incorrect";
        JavaKind returnKind = signature.getReturnKind().getStackKind();
        Stamp returnStamp = this.returnStamp(signature.getReturnType(null), returnKind);
        return this.createIndirectCall(targetAddress, arguments, signature.toParameterTypes(null), returnStamp, returnKind, callKind);
    }

    private InvokeNode createIndirectCall(ValueNode targetAddress, List<ValueNode> arguments, JavaType[] parameterTypes, Stamp returnStamp, JavaKind returnKind, SubstrateCallingConventionKind callKind) {
        return this.createIndirectCall(targetAddress, arguments, parameterTypes, returnStamp, returnKind, callKind.toType(true));
    }

    private InvokeNode createIndirectCall(ValueNode targetAddress, List<ValueNode> arguments, JavaType[] parameterTypes, Stamp returnStamp, JavaKind returnKind, CallingConvention.Type convention) {
        this.frameState.clearStack();
        int bci = this.bci();
        CallTargetNode callTarget = (CallTargetNode)this.getGraph().add((Node)new IndirectCallTargetNode(targetAddress, arguments.toArray(new ValueNode[arguments.size()]), StampPair.createSingle((Stamp)returnStamp), parameterTypes, null, convention, CallTargetNode.InvokeKind.Static));
        InvokeNode invoke = (InvokeNode)this.append((Node)new InvokeNode(callTarget, bci));
        this.frameState.pushReturn(returnKind, (ValueNode)invoke);
        FrameState stateAfter = this.frameState.create(bci, (StateSplit)invoke);
        invoke.setStateAfter(stateAfter);
        return invoke;
    }

    private Stamp returnStamp(JavaType returnType, JavaKind returnKind) {
        if (returnKind == JavaKind.Object && returnType instanceof ResolvedJavaType) {
            return StampFactory.object((TypeReference)TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)((ResolvedJavaType)returnType)));
        }
        return this.getLoweringProvider().loadStamp(StampFactory.forKind((JavaKind)returnKind), returnKind);
    }

    public ConstantNode createLong(long value) {
        return ConstantNode.forLong((long)value, (StructuredGraph)this.getGraph());
    }

    public ConstantNode createInt(int value) {
        return ConstantNode.forInt((int)value, (StructuredGraph)this.getGraph());
    }

    public ConstantNode createObject(Object value) {
        SnippetReflectionProvider snippetReflection = this.getProviders().getSnippetReflection();
        return ConstantNode.forConstant((JavaConstant)snippetReflection.forObject(value), (MetaAccessProvider)this.getMetaAccess(), (StructuredGraph)this.graph);
    }

    public ValueNode createBoxing(ValueNode value, JavaKind kind, ResolvedJavaType targetType) {
        return (ValueNode)this.append((Node)BoxNode.create((ValueNode)value, (ResolvedJavaType)targetType, (JavaKind)kind));
    }

    public ValueNode createReturn(ValueNode retValue, JavaKind returnKind) {
        if (returnKind == JavaKind.Void) {
            return (ValueNode)this.append((Node)new ReturnNode(null));
        }
        return (ValueNode)this.append((Node)new ReturnNode(retValue));
    }

    public PiNode createPiNode(ValueNode value, Stamp stamp) {
        return (PiNode)this.append((Node)new PiNode(value, stamp, (ValueNode)AbstractBeginNode.prevBegin((FixedNode)this.lastFixedNode)));
    }

    public int bci() {
        return this.nextBCI++;
    }

    public StructuredGraph finalizeGraph() {
        if (this.lastFixedNode != null) {
            throw VMError.shouldNotReachHere("Manually constructed graph does not terminate control flow properly. lastFixedNode: " + String.valueOf(this.lastFixedNode));
        }
        this.mergeUnwinds();
        assert (this.graph.verify());
        assert (this.getWordTypes().ensureGraphContainsNoWordTypeReferences(this.graph));
        return this.graph;
    }

    private void mergeUnwinds() {
        ArrayList<UnwindNode> unwinds = new ArrayList<UnwindNode>();
        for (Node node : this.getGraph().getNodes()) {
            if (!(node instanceof UnwindNode)) continue;
            unwinds.add((UnwindNode)node);
        }
        if (unwinds.size() > 1) {
            MergeNode unwindMergeNode = (MergeNode)this.add((ValueNode)new MergeNode());
            ValueNode exceptionValue = InliningUtil.mergeUnwindExceptions((AbstractMergeNode)unwindMergeNode, unwinds);
            UnwindNode unwindReplacement = (UnwindNode)this.add((ValueNode)new UnwindNode(exceptionValue));
            unwindMergeNode.setNext((FixedNode)unwindReplacement);
            FrameStateBuilder exceptionState = this.getFrameState().copy();
            exceptionState.clearStack();
            exceptionState.push(JavaKind.Object, exceptionValue);
            exceptionState.setRethrowException(true);
            unwindMergeNode.setStateAfter(exceptionState.create(-4, (StateSplit)unwindMergeNode));
        }
    }

    protected <T extends WithExceptionNode> T appendWithUnwind(T withExceptionNode, int bci) {
        WithExceptionNode appended = (WithExceptionNode)this.append((Node)withExceptionNode);
        assert (appended == withExceptionNode);
        if (withExceptionNode instanceof StateSplit) {
            StateSplit stateSplit = (StateSplit)withExceptionNode;
            stateSplit.setStateAfter(this.frameState.create(bci, stateSplit));
        }
        AbstractBeginNode noExceptionEdge = (AbstractBeginNode)this.add((ValueNode)new BeginNode());
        withExceptionNode.setNext(noExceptionEdge);
        ExceptionObjectNode exceptionEdge = this.createExceptionObjectNode(this.frameState, bci);
        withExceptionNode.setExceptionEdge((AbstractBeginNode)exceptionEdge);
        assert (this.lastFixedNode == null);
        this.lastFixedNode = exceptionEdge;
        this.append((Node)new UnwindNode((ValueNode)exceptionEdge));
        assert (this.lastFixedNode == null);
        this.lastFixedNode = noExceptionEdge;
        return withExceptionNode;
    }

    public void appendStateSplitProxy() {
        StateSplitProxyNode proxy = new StateSplitProxyNode();
        this.append((Node)proxy);
        proxy.setStateAfter(this.frameState.create(this.bci(), (StateSplit)proxy));
    }
}

