/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.jdk.localization.LocalizationSupport;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import jdk.graal.compiler.util.json.JSONParserException;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public class ResourceConfigurationParser
extends ConfigurationParser {
    private final ResourcesRegistry registry;

    public ResourceConfigurationParser(ResourcesRegistry registry, boolean strictConfiguration) {
        super(strictConfiguration);
        this.registry = registry;
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        this.parseTopLevelObject(ResourceConfigurationParser.asMap(json, "first level of document must be an object"));
    }

    private void parseTopLevelObject(EconomicMap<String, Object> obj) {
        Object resourcesObject = null;
        Object bundlesObject = null;
        MapCursor cursor = obj.getEntries();
        while (cursor.advance()) {
            if ("resources".equals(cursor.getKey())) {
                resourcesObject = cursor.getValue();
                continue;
            }
            if (!"bundles".equals(cursor.getKey())) continue;
            bundlesObject = cursor.getValue();
        }
        if (resourcesObject != null) {
            if (resourcesObject instanceof EconomicMap) {
                EconomicMap resourcesObjectMap = (EconomicMap)resourcesObject;
                this.checkAttributes((EconomicMap<String, Object>)resourcesObjectMap, "resource descriptor object", Collections.singleton("includes"), Collections.singleton("excludes"));
                Object includesObject = resourcesObjectMap.get((Object)"includes");
                Object excludesObject = resourcesObjectMap.get((Object)"excludes");
                List<Object> includes = ResourceConfigurationParser.asList(includesObject, "Attribute 'includes' must be a list of resources");
                for (Object object : includes) {
                    this.parseStringEntry(object, "pattern", this.registry::addResources, "resource descriptor object", "'includes' list");
                }
                if (excludesObject != null) {
                    List<Object> excludes = ResourceConfigurationParser.asList(excludesObject, "Attribute 'excludes' must be a list of resources");
                    for (Object object : excludes) {
                        this.parseStringEntry(object, "pattern", this.registry::ignoreResources, "resource descriptor object", "'excludes' list");
                    }
                }
            } else {
                List<Object> resources = ResourceConfigurationParser.asList(resourcesObject, "Attribute 'resources' must be a list of resources");
                for (Object object : resources) {
                    this.parseStringEntry(object, "pattern", this.registry::addResources, "resource descriptor object", "'resources' list");
                }
            }
        }
        if (bundlesObject != null) {
            List<Object> bundles = ResourceConfigurationParser.asList(bundlesObject, "Attribute 'bundles' must be a list of bundles");
            for (Object bundle : bundles) {
                this.parseBundle(bundle);
            }
        }
    }

    private void parseBundle(Object bundle) {
        Object classNames;
        List<Locale> asList;
        EconomicMap<String, Object> resource = ResourceConfigurationParser.asMap(bundle, "Elements of 'bundles' list must be a bundle descriptor object");
        this.checkAttributes(resource, "bundle descriptor object", Collections.singletonList("name"), Arrays.asList("locales", "classNames", "condition"));
        String basename = ResourceConfigurationParser.asString(resource.get((Object)"name"));
        ConfigurationCondition condition = this.parseCondition(resource);
        Object locales = resource.get((Object)"locales");
        if (locales != null && !(asList = ResourceConfigurationParser.asList(locales, "Attribute 'locales' must be a list of locales").stream().map(ResourceConfigurationParser::parseLocale).collect(Collectors.toList())).isEmpty()) {
            this.registry.addResourceBundles(condition, basename, asList);
        }
        if ((classNames = resource.get((Object)"classNames")) != null) {
            List<Object> asList2 = ResourceConfigurationParser.asList(classNames, "Attribute 'classNames' must be a list of classes");
            for (Object o : asList2) {
                String className = ResourceConfigurationParser.asString(o);
                this.registry.addClassBasedResourceBundle(condition, basename, className);
            }
        }
        if (locales == null && classNames == null) {
            this.registry.addResourceBundles(condition, basename);
        }
    }

    private static Locale parseLocale(Object input) {
        String localeTag = ResourceConfigurationParser.asString(input);
        Locale locale = LocalizationSupport.parseLocaleFromTag(localeTag);
        if (locale == null) {
            throw new JSONParserException(localeTag + " is not a valid locale tag");
        }
        return locale;
    }

    private void parseStringEntry(Object data, String valueKey, BiConsumer<ConfigurationCondition, String> resourceRegistry, String expectedType, String parentType) {
        EconomicMap<String, Object> resource = ResourceConfigurationParser.asMap(data, "Elements of " + parentType + " must be a " + expectedType);
        this.checkAttributes(resource, "resource and resource bundle descriptor object", Collections.singletonList(valueKey), Collections.singletonList("condition"));
        ConfigurationCondition condition = this.parseCondition(resource);
        Object valueObject = resource.get((Object)valueKey);
        String value = ResourceConfigurationParser.asString(valueObject, valueKey);
        resourceRegistry.accept(condition, value);
    }
}

