/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import java.lang.reflect.Type;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;

@AutomaticallyRegisteredFeature
final class StaticFieldsFeature
implements InternalFeature {
    StaticFieldsFeature() {
    }

    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), StaticFieldsSupport.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "getStaticObjectFields", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused) {
                b.addPush(JavaKind.Object, (ValueNode)new StaticFieldsSupport.StaticFieldBaseNode(false));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "getStaticPrimitiveFields", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused) {
                b.addPush(JavaKind.Object, (ValueNode)new StaticFieldsSupport.StaticFieldBaseNode(true));
                return true;
            }
        });
    }
}

