/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.util;

import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.util.CPUType;
import com.oracle.svm.util.StringUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.riscv64.RISCV64;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class CPUTypeRISCV64
extends Enum<CPUTypeRISCV64>
implements CPUType {
    public static final /* enum */ CPUTypeRISCV64 RV64IMAFDC = new CPUTypeRISCV64("rv64imafdc", RISCV64.CPUFeature.I, RISCV64.CPUFeature.M, RISCV64.CPUFeature.A, RISCV64.CPUFeature.F, RISCV64.CPUFeature.D);
    public static final /* enum */ CPUTypeRISCV64 RV64GC = new CPUTypeRISCV64("rv64gc", RV64IMAFDC, new RISCV64.CPUFeature[0]);
    public static final /* enum */ CPUTypeRISCV64 RV64IMAFDCV = new CPUTypeRISCV64("rv64imafdcv", RV64IMAFDC, RISCV64.CPUFeature.V);
    public static final /* enum */ CPUTypeRISCV64 RV64GCV = new CPUTypeRISCV64("rv64gcv", RV64IMAFDCV, new RISCV64.CPUFeature[0]);
    public static final /* enum */ CPUTypeRISCV64 COMPATIBILITY = new CPUTypeRISCV64("compatibility", RV64GC, new RISCV64.CPUFeature[0]);
    public static final /* enum */ CPUTypeRISCV64 NATIVE = new CPUTypeRISCV64("native", CPUTypeRISCV64.getNativeOrEmpty());
    private final String name;
    private final CPUTypeRISCV64 parent;
    private final EnumSet<RISCV64.CPUFeature> specificFeatures;
    private static final /* synthetic */ CPUTypeRISCV64[] $VALUES;

    public static CPUTypeRISCV64[] values() {
        return (CPUTypeRISCV64[])$VALUES.clone();
    }

    public static CPUTypeRISCV64 valueOf(String name) {
        return Enum.valueOf(CPUTypeRISCV64.class, name);
    }

    private static RISCV64.CPUFeature[] getNativeOrEmpty() {
        RISCV64.CPUFeature[] empty = new RISCV64.CPUFeature[]{};
        Architecture architecture = GraalAccess.getOriginalTarget().arch;
        if (architecture instanceof RISCV64) {
            RISCV64 arch = (RISCV64)architecture;
            return arch.getFeatures().toArray(empty);
        }
        return empty;
    }

    private CPUTypeRISCV64(String cpuTypeName, RISCV64.CPUFeature ... features) {
        this(cpuTypeName, (CPUTypeRISCV64)null, features);
    }

    private CPUTypeRISCV64(String cpuTypeName, CPUTypeRISCV64 cpuTypeParentOrNull, RISCV64.CPUFeature ... features) {
        this.name = cpuTypeName;
        this.parent = cpuTypeParentOrNull;
        EnumSet<RISCV64.CPUFeature> enumSet = this.specificFeatures = features.length > 0 ? EnumSet.copyOf(List.of(features)) : EnumSet.noneOf(RISCV64.CPUFeature.class);
        assert (this.parent == null || this.parent.getFeatures().stream().noneMatch(f -> this.specificFeatures.contains(f))) : "duplicate features detected but not allowed";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CPUTypeRISCV64 getParent() {
        return this.parent;
    }

    @Override
    public String getSpecificFeaturesString() {
        return this.specificFeatures.stream().map(f -> f.name()).collect(Collectors.joining(" + "));
    }

    public EnumSet<RISCV64.CPUFeature> getFeatures() {
        if (this.parent == null) {
            return this.specificFeatures;
        }
        return EnumSet.copyOf(Stream.concat(this.parent.getFeatures().stream(), this.specificFeatures.stream()).toList());
    }

    public static String getDefaultName() {
        return RV64GC.getName();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static EnumSet<RISCV64.CPUFeature> getSelectedFeatures() {
        String value = NativeImageOptions.MicroArchitecture.getValue();
        if (value == null) {
            value = CPUTypeRISCV64.getDefaultName();
        }
        return CPUTypeRISCV64.getCPUFeaturesForArch(value);
    }

    public static EnumSet<RISCV64.CPUFeature> getCPUFeaturesForArch(String marchValue) {
        CPUTypeRISCV64 value = CPUTypeRISCV64.typeOf(marchValue);
        if (value == null) {
            throw UserError.abort("Unsupported architecture '%s'. Please adjust '%s'. On RISCV64, only %s are available.", marchValue, SubstrateOptionsParser.commandArgument(NativeImageOptions.MicroArchitecture, marchValue), StringUtil.joinSingleQuoted((Object[])CPUTypeRISCV64.values()));
        }
        return value.getFeatures();
    }

    public static boolean nativeSupportsMoreFeaturesThanSelected() {
        EnumSet<RISCV64.CPUFeature> selectedFeatures;
        EnumSet<RISCV64.CPUFeature> nativeFeatures = NATIVE.getFeatures();
        return nativeFeatures.containsAll(selectedFeatures = CPUTypeRISCV64.getSelectedFeatures()) && nativeFeatures.size() > selectedFeatures.size();
    }

    private static CPUTypeRISCV64 typeOf(String marchValue) {
        for (CPUTypeRISCV64 value : CPUTypeRISCV64.values()) {
            if (!value.name.equals(marchValue)) continue;
            return value;
        }
        return null;
    }

    private static /* synthetic */ CPUTypeRISCV64[] $values() {
        return new CPUTypeRISCV64[]{RV64IMAFDC, RV64GC, RV64IMAFDCV, RV64GCV, COMPATIBILITY, NATIVE};
    }

    static {
        $VALUES = CPUTypeRISCV64.$values();
    }
}

