/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.svm.core.SubstrateUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import jdk.vm.ci.meta.JavaKind;

final class SignatureKey {
    final boolean isStatic;
    final Class<?>[] argTypes;
    final JavaKind returnKind;
    final boolean callerSensitiveAdapter;

    SignatureKey(Executable member, boolean callerSensitiveAdapter) {
        this.isStatic = member instanceof Constructor || Modifier.isStatic(member.getModifiers());
        Class<?>[] types = member.getParameterTypes();
        if (callerSensitiveAdapter) {
            assert (types[types.length - 1] == Class.class);
            types = Arrays.copyOf(types, types.length - 1);
        }
        this.argTypes = types;
        this.returnKind = member instanceof Method ? JavaKind.fromJavaClass(((Method)member).getReturnType()) : JavaKind.Object;
        this.callerSensitiveAdapter = callerSensitiveAdapter;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != SignatureKey.class) {
            return false;
        }
        SignatureKey other = (SignatureKey)obj;
        return this.isStatic == other.isStatic && Arrays.equals(this.argTypes, other.argTypes) && Objects.equals(this.returnKind, other.returnKind) && this.callerSensitiveAdapter == other.callerSensitiveAdapter;
    }

    public int hashCode() {
        return Objects.hash(this.isStatic, Arrays.hashCode(this.argTypes), this.returnKind, this.callerSensitiveAdapter);
    }

    public String toString() {
        StringBuilder fullName = new StringBuilder();
        fullName.append(this.isStatic);
        fullName.append("(");
        for (Class<?> c : this.argTypes) {
            fullName.append(c.getName()).append(",");
        }
        fullName.append(')');
        fullName.append(this.returnKind);
        if (this.callerSensitiveAdapter) {
            fullName.append(" CallerSensitiveAdapter");
        }
        return fullName.toString();
    }

    String uniqueShortName() {
        return SubstrateUtil.digest(this.toString());
    }
}

