/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.constraints.TypeInstantiationException;
import com.oracle.graal.pointsto.constraints.UnresolvedElementException;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.infrastructure.AnalysisConstantPool;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.bootstrap.BootstrapMethodConfiguration;
import com.oracle.svm.core.bootstrap.BootstrapMethodInfo;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.graal.nodes.DeoptEntryBeginNode;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.graal.nodes.DeoptEntrySupport;
import com.oracle.svm.core.graal.nodes.DeoptProxyAnchorNode;
import com.oracle.svm.core.graal.nodes.LazyConstantNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.DirectSubstrateObjectConstant;
import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ExceptionSynthesizer;
import com.oracle.svm.hosted.LinkAtBuildTimeSupport;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.code.FactoryMethodSupport;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.nodes.DeoptProxyNode;
import com.oracle.svm.hosted.phases.DeoptimizationTargetBciBlockMapping;
import com.oracle.svm.hosted.snippets.SubstrateGraphBuilderPlugins;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.bytecode.Bytecode;
import jdk.graal.compiler.bytecode.BytecodeStream;
import jdk.graal.compiler.core.common.BootstrapMethodIntrospection;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.java.BciBlockMapping;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.java.FrameStateBuilder;
import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FieldLocationIdentity;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnreachableBeginNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.UnboxNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.IntrinsicContext;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.java.UnsafeCompareAndSwapNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.word.LocationIdentity;

public abstract class SharedGraphBuilderPhase
extends GraphBuilderPhase.Instance {
    public SharedGraphBuilderPhase(CoreProviders providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
        super(providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
    }

    protected void run(StructuredGraph graph) {
        super.run(graph);
        assert (this.providers.getWordTypes() == null || this.providers.getWordTypes().ensureGraphContainsNoWordTypeReferences(graph));
    }

    public static abstract class SharedBytecodeParser
    extends BytecodeParser {
        private int currentDeoptIndex;
        private final boolean explicitExceptionEdges;
        private final boolean linkAtBuildTime;
        protected final BootstrapMethodHandler bootstrapMethodHandler;

        protected SharedBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext, boolean explicitExceptionEdges) {
            this(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext, explicitExceptionEdges, LinkAtBuildTimeSupport.singleton().linkAtBuildTime(method.getDeclaringClass()));
        }

        protected SharedBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext, boolean explicitExceptionEdges, boolean linkAtBuildTime) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext);
            this.explicitExceptionEdges = explicitExceptionEdges;
            this.linkAtBuildTime = linkAtBuildTime;
            this.bootstrapMethodHandler = new BootstrapMethodHandler();
        }

        protected BciBlockMapping generateBlockMap() {
            if (SharedBytecodeParser.isDeoptimizationEnabled() && this.isMethodDeoptTarget()) {
                return DeoptimizationTargetBciBlockMapping.create(this.stream, this.code, this.options, this.graph.getDebug(), false);
            }
            return BciBlockMapping.create((BytecodeStream)this.stream, (Bytecode)this.code, (OptionValues)this.options, (DebugContext)this.graph.getDebug(), (boolean)this.asyncExceptionLiveness());
        }

        protected boolean shouldVerifyFrameStates() {
            return false;
        }

        protected void build(FixedWithNextNode startInstruction, FrameStateBuilder startFrameState) {
            if (!this.shouldVerifyFrameStates()) {
                startFrameState.disableStateVerification();
            }
            super.build(startInstruction, startFrameState);
            if (this.isMethodDeoptTarget()) {
                for (DeoptProxyNode deoptProxy : this.graph.getNodes(DeoptProxyNode.TYPE)) {
                    assert (deoptProxy.hasProxyPoint());
                }
            }
        }

        protected RuntimeException throwParserError(Throwable e) {
            if (e instanceof UserError.UserException) {
                throw (UserError.UserException)e;
            }
            if (e instanceof UnsupportedFeatureException) {
                throw (UnsupportedFeatureException)e;
            }
            throw super.throwParserError(e);
        }

        private boolean checkWordTypes() {
            return this.getWordTypes() != null;
        }

        public boolean canDeferPlugin(GeneratedInvocationPlugin plugin) {
            return plugin.getSource().equals(Fold.class) || plugin.getSource().equals(Node.NodeIntrinsic.class);
        }

        protected JavaMethod lookupMethodInPool(int cpi, int opcode) {
            JavaMethod result = super.lookupMethodInPool(cpi, opcode);
            if (result == null) {
                throw VMError.shouldNotReachHere("Discovered an unresolved callee while parsing " + String.valueOf(this.method.asStackTraceElement(this.bci())) + ".");
            }
            return result;
        }

        protected void genLoadConstant(int cpi, int opcode) {
            try {
                if (super.lookupConstant(cpi, opcode, false) == null) {
                    Object resolvedObject = this.bootstrapMethodHandler.loadConstantDynamic(cpi, opcode);
                    if (resolvedObject instanceof ValueNode) {
                        ValueNode valueNode = (ValueNode)resolvedObject;
                        JavaKind javaKind = valueNode.getStackKind();
                        assert (opcode == 20 == javaKind.needsTwoSlots());
                        this.frameState.push(javaKind, valueNode);
                    } else {
                        super.genLoadConstantHelper(resolvedObject, opcode);
                    }
                    return;
                }
                super.genLoadConstant(cpi, opcode);
            }
            catch (BootstrapMethodError | IllegalArgumentException | IncompatibleClassChangeError | NoClassDefFoundError ex) {
                this.bootstrapMethodHandler.handleBootstrapException(ex, "constant");
            }
        }

        protected Object loadReferenceTypeLock() {
            return null;
        }

        protected void maybeEagerlyResolve(int cpi, int bytecode) {
            block2: {
                try {
                    super.maybeEagerlyResolve(cpi, bytecode);
                }
                catch (UnresolvedElementException e) {
                    if (e.getCause() instanceof LambdaConversionException || e.getCause() instanceof LinkageError || e.getCause() instanceof IllegalAccessError) break block2;
                    throw e;
                }
            }
        }

        protected JavaType maybeEagerlyResolve(JavaType type, ResolvedJavaType accessingClass) {
            try {
                return super.maybeEagerlyResolve(type, accessingClass);
            }
            catch (LinkageError e) {
                return this.getMetaAccess().lookupJavaType(Object.class);
            }
        }

        protected void handleIllegalNewInstance(JavaType type) {
            if (this.linkAtBuildTime) {
                String message = "Cannot instantiate " + type.toJavaName() + ". " + LinkAtBuildTimeSupport.singleton().errorMessageFor(this.method.getDeclaringClass());
                throw new TypeInstantiationException(message);
            }
            ExceptionSynthesizer.throwException((GraphBuilderContext)this, InstantiationError.class, type.toJavaName());
        }

        protected void handleUnresolvedNewInstance(JavaType type) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedNewObjectArray(JavaType type) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedNewMultiArray(JavaType type) {
            this.handleUnresolvedType(type.getElementalType());
        }

        protected void handleUnresolvedInstanceOf(JavaType type, ValueNode object) {
            BeginNode nullObj = (BeginNode)this.graph.add((Node)new BeginNode());
            BeginNode nonNullObj = (BeginNode)this.graph.add((Node)new BeginNode());
            this.append((Node)new IfNode((LogicNode)this.graph.addOrUniqueWithInputs((Node)IsNullNode.create((ValueNode)object)), (AbstractBeginNode)nullObj, (AbstractBeginNode)nonNullObj, BranchProbabilityNode.NOT_FREQUENT_PROFILE));
            this.lastInstr = nonNullObj;
            this.handleUnresolvedType(type);
            this.lastInstr = nullObj;
            this.frameState.push(JavaKind.Int, (ValueNode)this.appendConstant((JavaConstant)JavaConstant.INT_0));
        }

        protected void handleUnresolvedCheckCast(JavaType type, ValueNode object) {
            BeginNode nullObj = (BeginNode)this.graph.add((Node)new BeginNode());
            BeginNode nonNullObj = (BeginNode)this.graph.add((Node)new BeginNode());
            this.append((Node)new IfNode((LogicNode)this.graph.addOrUniqueWithInputs((Node)IsNullNode.create((ValueNode)object)), (AbstractBeginNode)nullObj, (AbstractBeginNode)nonNullObj, BranchProbabilityNode.NOT_FREQUENT_PROFILE));
            this.lastInstr = nonNullObj;
            this.handleUnresolvedType(type);
            this.lastInstr = nullObj;
            this.frameState.push(JavaKind.Object, (ValueNode)this.appendConstant(JavaConstant.NULL_POINTER));
        }

        protected void handleUnresolvedLoadConstant(JavaType unresolvedType) {
            this.handleUnresolvedType(unresolvedType);
        }

        protected void handleUnresolvedExceptionType(JavaType type) {
            this.handleUnresolvedType(type);
        }

        protected void handleUnresolvedStoreField(JavaField field) {
            this.handleUnresolvedField(field);
        }

        protected void handleUnresolvedLoadField(JavaField field) {
            this.handleUnresolvedField(field);
        }

        protected void handleUnresolvedInvoke(JavaMethod javaMethod, CallTargetNode.InvokeKind invokeKind) {
            this.handleUnresolvedMethod(javaMethod);
        }

        public static <T extends Throwable> void replaceWithThrowingAtRuntime(SharedBytecodeParser b, T throwable) {
            Throwable cause = throwable.getCause();
            if (cause != null) {
                ValueNode[] valueNodeArray;
                AnalysisMetaAccess metaAccess = (AnalysisMetaAccess)b.getMetaAccess();
                Constructor errorCtor = ReflectionUtil.lookupConstructor((boolean)true, throwable.getClass(), (Class[])new Class[]{String.class, Throwable.class});
                boolean hasCause = errorCtor != null;
                Invoke causeCtorInvoke = null;
                if (!hasCause) {
                    errorCtor = ReflectionUtil.lookupConstructor(throwable.getClass(), (Class[])new Class[]{String.class});
                } else {
                    Constructor causeCtor = ReflectionUtil.lookupConstructor(cause.getClass(), (Class[])new Class[]{String.class});
                    AnalysisMethod causeCtorMethod = FactoryMethodSupport.singleton().lookup(metaAccess, metaAccess.lookupJavaMethod((Executable)causeCtor), false);
                    ConstantNode causeMessageNode = ConstantNode.forConstant((JavaConstant)b.getConstantReflection().forString(cause.getMessage()), (MetaAccessProvider)metaAccess, (StructuredGraph)b.getGraph());
                    causeCtorInvoke = (Invoke)b.appendInvoke(CallTargetNode.InvokeKind.Static, (ResolvedJavaMethod)causeCtorMethod, new ValueNode[]{causeMessageNode}, null);
                }
                AnalysisMethod throwingMethod = FactoryMethodSupport.singleton().lookup(metaAccess, metaAccess.lookupJavaMethod((Executable)errorCtor), true);
                ConstantNode messageNode = ConstantNode.forConstant((JavaConstant)b.getConstantReflection().forString(throwable.getMessage()), (MetaAccessProvider)metaAccess, (StructuredGraph)b.getGraph());
                boolean verifyStates = b.getFrameStateBuilder().disableStateVerification();
                if (hasCause) {
                    ValueNode[] valueNodeArray2 = new ValueNode[2];
                    valueNodeArray2[0] = messageNode;
                    valueNodeArray = valueNodeArray2;
                    valueNodeArray2[1] = causeCtorInvoke.asNode();
                } else {
                    ValueNode[] valueNodeArray3 = new ValueNode[1];
                    valueNodeArray = valueNodeArray3;
                    valueNodeArray3[0] = messageNode;
                }
                ValueNode[] args = valueNodeArray;
                b.appendInvoke(CallTargetNode.InvokeKind.Static, (ResolvedJavaMethod)throwingMethod, args, null);
                b.getFrameStateBuilder().setStateVerification(verifyStates);
                b.add((Node)new LoweredDeadEndNode());
            } else {
                SharedBytecodeParser.replaceWithThrowingAtRuntime(b, throwable.getClass(), throwable.getMessage());
            }
        }

        public static void replaceWithThrowingAtRuntime(SharedBytecodeParser b, Class<? extends Throwable> throwableClass, String throwableMessage) {
            Constructor errorCtor = ReflectionUtil.lookupConstructor(throwableClass, (Class[])new Class[]{String.class});
            AnalysisMetaAccess metaAccess = (AnalysisMetaAccess)b.getMetaAccess();
            AnalysisMethod throwingMethod = FactoryMethodSupport.singleton().lookup(metaAccess, metaAccess.lookupJavaMethod((Executable)errorCtor), true);
            ConstantNode messageNode = ConstantNode.forConstant((JavaConstant)b.getConstantReflection().forString(throwableMessage), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph());
            boolean verifyStates = b.getFrameStateBuilder().disableStateVerification();
            b.appendInvoke(CallTargetNode.InvokeKind.Static, (ResolvedJavaMethod)throwingMethod, new ValueNode[]{messageNode}, null);
            b.getFrameStateBuilder().setStateVerification(verifyStates);
            b.add((Node)new LoweredDeadEndNode());
        }

        protected void handleUnresolvedType(JavaType type) {
            if (this.linkAtBuildTime) {
                this.reportUnresolvedElement("type", type.toJavaName());
            } else {
                ExceptionSynthesizer.throwException((GraphBuilderContext)this, NoClassDefFoundError.class, type.toJavaName());
            }
        }

        private void handleUnresolvedField(JavaField field) {
            JavaType declaringClass = field.getDeclaringClass();
            if (!this.typeIsResolved(declaringClass)) {
                this.handleUnresolvedType(declaringClass);
            } else if (this.linkAtBuildTime) {
                this.reportUnresolvedElement("field", field.format("%H.%n"));
            } else {
                ExceptionSynthesizer.throwException((GraphBuilderContext)this, NoSuchFieldError.class, field.format("%H.%n"));
            }
        }

        private void handleUnresolvedMethod(JavaMethod javaMethod) {
            JavaType declaringClass = javaMethod.getDeclaringClass();
            if (!this.typeIsResolved(declaringClass)) {
                this.handleUnresolvedType(declaringClass);
            } else if (this.linkAtBuildTime) {
                this.reportUnresolvedElement("method", javaMethod.format("%H.%n(%P)"));
            } else {
                ExceptionSynthesizer.throwException((GraphBuilderContext)this, SharedBytecodeParser.findResolutionError((ResolvedJavaType)declaringClass, javaMethod), javaMethod.format("%H.%n(%P)"));
            }
        }

        private static Class<? extends IncompatibleClassChangeError> findResolutionError(ResolvedJavaType declaringType, JavaMethod searchMethod) {
            Class declaringClass;
            Object[] searchSignature = SharedBytecodeParser.signatureToClasses(searchMethod);
            Class searchReturnType = null;
            if (searchMethod.getSignature().getReturnType(null) instanceof ResolvedJavaType) {
                searchReturnType = OriginalClassProvider.getJavaClass((JavaType)searchMethod.getSignature().getReturnType(null));
            }
            for (Class cur = declaringClass = OriginalClassProvider.getJavaClass((JavaType)declaringType); cur != null; cur = cur.getSuperclass()) {
                Executable[] methods = null;
                try {
                    methods = searchMethod.getName().equals("<init>") ? cur.getDeclaredConstructors() : cur.getDeclaredMethods();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (methods != null) {
                    for (Constructor<?> constructor : methods) {
                        if (!Arrays.equals(searchSignature, ((Executable)constructor).getParameterTypes()) || !(constructor instanceof Constructor) && (!searchMethod.getName().equals(((Executable)constructor).getName()) || searchReturnType != ((Method)((Object)constructor)).getReturnType())) continue;
                        if (Modifier.isAbstract(((Executable)constructor).getModifiers())) {
                            return AbstractMethodError.class;
                        }
                        return IllegalAccessError.class;
                    }
                }
                if (searchMethod.getName().equals("<init>")) break;
            }
            return NoSuchMethodError.class;
        }

        private static Class<?>[] signatureToClasses(JavaMethod method) {
            int paramCount = method.getSignature().getParameterCount(false);
            Class[] result = new Class[paramCount];
            for (int i = 0; i < paramCount; ++i) {
                JavaType parameterType = method.getSignature().getParameterType(i, null);
                if (!(parameterType instanceof ResolvedJavaType)) continue;
                result[i] = OriginalClassProvider.getJavaClass((JavaType)parameterType);
            }
            return result;
        }

        private void reportUnresolvedElement(String elementKind, String elementAsString) {
            this.reportUnresolvedElement(elementKind, elementAsString, null);
        }

        private void reportUnresolvedElement(String elementKind, String elementAsString, Throwable cause) {
            String message = "Discovered unresolved " + elementKind + " during parsing: " + elementAsString + ". " + LinkAtBuildTimeSupport.singleton().errorMessageFor(this.method.getDeclaringClass());
            throw new UnresolvedElementException(message, cause);
        }

        protected void emitCheckForInvokeSuperSpecial(ValueNode[] args) {
        }

        protected boolean canInlinePartialIntrinsicExit() {
            return false;
        }

        protected void genIf(ValueNode x, Condition cond, ValueNode y) {
            if (this.checkWordTypes() && (x.getStackKind() == JavaKind.Object && y.getStackKind() == this.getWordTypes().getWordKind() || x.getStackKind() == this.getWordTypes().getWordKind() && y.getStackKind() == JavaKind.Object)) {
                throw UserError.abort("Should not compare Word to Object in condition at %s in %s", this.method, this.method.asStackTraceElement(this.bci()));
            }
            super.genIf(x, cond, y);
        }

        public MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, StampPair returnStamp, JavaTypeProfile profile) {
            boolean isStatic = targetMethod.isStatic();
            if (!isStatic) {
                this.checkWordType(args[0], (JavaType)targetMethod.getDeclaringClass(), "call receiver");
            }
            for (int i = 0; i < targetMethod.getSignature().getParameterCount(false); ++i) {
                this.checkWordType(args[i + (isStatic ? 0 : 1)], targetMethod.getSignature().getParameterType(i, null), "call argument");
            }
            return new SubstrateMethodCallTargetNode(invokeKind, targetMethod, args, returnStamp);
        }

        public MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, Class<?> returnClass, JavaTypeProfile profile) {
            ResolvedJavaType returnType = this.getMetaAccess().lookupJavaType(returnClass);
            return this.createMethodCallTarget(invokeKind, targetMethod, args, (JavaType)returnType, profile);
        }

        protected void genReturn(ValueNode returnVal, JavaKind returnKind) {
            this.checkWordType(returnVal, this.method.getSignature().getReturnType(null), "return value");
            super.genReturn(returnVal, returnKind);
        }

        private void checkWordType(ValueNode value, JavaType expectedType, String reason) {
            if (expectedType.getJavaKind() == JavaKind.Object && this.checkWordTypes()) {
                boolean isWordValue;
                boolean isWordTypeExpected = this.getWordTypes().isWord(expectedType);
                boolean bl = isWordValue = value.getStackKind() == this.getWordTypes().getWordKind();
                if (isWordTypeExpected && !isWordValue) {
                    throw UserError.abort("Expected Word but got Object for %s in %s", reason, this.method.asStackTraceElement(this.bci()));
                }
                if (!isWordTypeExpected && isWordValue) {
                    throw UserError.abort("Expected Object but got Word for %s in %s. One possible cause for this error is when word values are passed into lambdas as parameters or from variables in an enclosing scope, which is not supported, but can be solved by instead using explicit classes (including anonymous classes).", reason, this.method.asStackTraceElement(this.bci()));
                }
            }
        }

        protected boolean needsExplicitNullCheckException(ValueNode object) {
            return this.needsExplicitException() && object.getStackKind() == JavaKind.Object;
        }

        protected boolean needsExplicitStoreCheckException(ValueNode array, ValueNode value) {
            return this.needsExplicitException() && value.getStackKind() == JavaKind.Object;
        }

        public boolean needsExplicitException() {
            return this.explicitExceptionEdges && !this.parsingIntrinsic();
        }

        protected boolean needsIncompatibleClassChangeErrorCheck() {
            return !this.parsingIntrinsic();
        }

        protected boolean needsExplicitIncompatibleClassChangeError() {
            return this.needsExplicitException();
        }

        public boolean isPluginEnabled(GraphBuilderPlugin plugin) {
            return true;
        }

        protected static boolean isDeoptimizationEnabled() {
            boolean result = DeoptimizationSupport.enabled();
            assert (!result || !SubstrateUtil.isBuildingLibgraal()) : "Deoptimization support should not be enabled while building libgraal";
            return result;
        }

        protected final boolean isMethodDeoptTarget() {
            return MultiMethod.isDeoptTarget((ResolvedJavaMethod)this.method);
        }

        protected boolean asyncExceptionLiveness() {
            if (this.method instanceof MultiMethod) {
                return ((MultiMethod)this.method).getMultiMethodKey() == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD;
            }
            return SharedBytecodeParser.isDeoptimizationEnabled();
        }

        protected void clearNonLiveLocalsAtTargetCreation(BciBlockMapping.BciBlock block, FrameStateBuilder state) {
            if (!SharedBytecodeParser.isDeoptimizationEnabled() || !(block instanceof BciBlockMapping.ExceptionDispatchBlock) || this.isMethodDeoptTarget()) {
                super.clearNonLiveLocalsAtTargetCreation(block, state);
            }
        }

        protected void clearNonLiveLocalsAtLoopExitCreation(BciBlockMapping.BciBlock block, FrameStateBuilder state) {
            if (!SharedBytecodeParser.isDeoptimizationEnabled() || this.isMethodDeoptTarget()) {
                super.clearNonLiveLocalsAtLoopExitCreation(block, state);
            }
        }

        protected void createExceptionDispatch(BciBlockMapping.ExceptionDispatchBlock block) {
            if (block instanceof DeoptimizationTargetBciBlockMapping.DeoptEntryInsertionPoint) {
                assert (block instanceof DeoptimizationTargetBciBlockMapping.DeoptExceptionDispatchBlock);
                this.insertDeoptNode((DeoptimizationTargetBciBlockMapping.DeoptEntryInsertionPoint)block);
                List successors = block.getSuccessors();
                assert (successors.size() <= 1);
                BciBlockMapping.ExceptionDispatchBlock successor = successors.isEmpty() ? this.blockMap.getUnwindBlock() : (BciBlockMapping.BciBlock)successors.get(0);
                this.appendGoto((BciBlockMapping.BciBlock)successor);
            } else {
                super.createExceptionDispatch(block);
            }
        }

        protected void iterateBytecodesForBlock(BciBlockMapping.BciBlock block) {
            if (block instanceof DeoptimizationTargetBciBlockMapping.DeoptEntryInsertionPoint) {
                assert (block instanceof DeoptimizationTargetBciBlockMapping.DeoptBciBlock);
                assert (block.getSuccessors().size() == 1 || block.getSuccessors().size() == 2);
                assert (block.getSuccessor(0).isInstructionBlock());
                this.stream.setBCI(block.getStartBci());
                this.insertDeoptNode((DeoptimizationTargetBciBlockMapping.DeoptEntryInsertionPoint)block);
                this.appendGoto(block.getSuccessor(0));
            } else {
                super.iterateBytecodesForBlock(block);
            }
        }

        private void insertDeoptNode(DeoptimizationTargetBciBlockMapping.DeoptEntryInsertionPoint deopt) {
            boolean proxifysInvoke;
            if (deopt instanceof DeoptimizationTargetBciBlockMapping.DeoptBciBlock) {
                assert (!this.frameState.rethrowException());
            } else {
                assert (deopt instanceof DeoptimizationTargetBciBlockMapping.DeoptExceptionDispatchBlock);
                assert (this.frameState.rethrowException());
            }
            int proxifiedInvokeBci = deopt.proxifiedInvokeBci();
            boolean isProxy = deopt.isProxy();
            DeoptEntrySupport deoptNode = isProxy ? (DeoptEntrySupport)this.graph.add((Node)new DeoptProxyAnchorNode(proxifiedInvokeBci)) : (DeoptEntrySupport)this.graph.add((Node)((proxifysInvoke = deopt.proxifysInvoke()) ? DeoptEntryNode.create(proxifiedInvokeBci) : DeoptEntryNode.create()));
            FrameState stateAfter = this.frameState.create(deopt.frameStateBci(), (StateSplit)deoptNode);
            deoptNode.setStateAfter(stateAfter);
            if (this.lastInstr != null) {
                this.lastInstr.setNext(deoptNode.asFixedNode());
            }
            if (isProxy) {
                this.lastInstr = (DeoptProxyAnchorNode)deoptNode;
            } else {
                DeoptEntryNode deoptEntryNode = (DeoptEntryNode)deoptNode;
                deoptEntryNode.setNext((AbstractBeginNode)this.graph.add((Node)new DeoptEntryBeginNode()));
                if (!deopt.isExceptionDispatch()) {
                    FrameStateBuilder originalFrameState = this.frameState.copy();
                    ExceptionObjectNode newExceptionObject = (ExceptionObjectNode)this.graph.add((Node)new ExceptionObjectNode(this.getMetaAccess()));
                    this.frameState.clearStack();
                    this.frameState.push(JavaKind.Object, (ValueNode)newExceptionObject);
                    this.frameState.setRethrowException(true);
                    int bci = ((DeoptimizationTargetBciBlockMapping.DeoptBciBlock)deopt).getStartBci();
                    newExceptionObject.setStateAfter(this.frameState.create(bci, (StateSplit)newExceptionObject));
                    deoptEntryNode.setExceptionEdge((AbstractBeginNode)newExceptionObject);
                    this.insertProxies((FixedNode)newExceptionObject, this.frameState);
                    newExceptionObject.setNext((FixedNode)this.handleException((ValueNode)newExceptionObject, bci, false));
                    this.frameState = originalFrameState;
                } else {
                    AbstractBeginNode newExceptionEdge = (AbstractBeginNode)this.graph.add((Node)new UnreachableBeginNode());
                    newExceptionEdge.setNext((FixedNode)this.graph.add((Node)new LoweredDeadEndNode()));
                    deoptEntryNode.setExceptionEdge(newExceptionEdge);
                }
                this.lastInstr = deoptEntryNode.next();
            }
            this.insertProxies(deoptNode.asFixedNode(), this.frameState);
        }

        private void insertProxies(FixedNode deoptTarget, FrameStateBuilder state) {
            state.insertProxies(value -> this.createProxyNode((ValueNode)value, deoptTarget));
            ++this.currentDeoptIndex;
        }

        private ValueNode createProxyNode(ValueNode value, FixedNode deoptTarget) {
            ValueNode v = DeoptProxyNode.create(value, (ValueNode)deoptTarget, this.currentDeoptIndex);
            if (v.graph() != null) {
                return v;
            }
            return (ValueNode)this.graph.addOrUniqueWithInputs((Node)v);
        }

        protected boolean forceLoopPhis() {
            return this.isMethodDeoptTarget() || super.forceLoopPhis();
        }

        public boolean allowDeoptInPlugins() {
            return super.allowDeoptInPlugins();
        }

        public class BootstrapMethodHandler {
            private Object loadConstantDynamic(int cpi, int opcode) {
                BootstrapMethodIntrospection bootstrap;
                try {
                    bootstrap = ((AnalysisConstantPool)SharedBytecodeParser.this.constantPool).lookupBootstrapMethodIntrospection(cpi, -1);
                }
                catch (Throwable ex) {
                    this.handleBootstrapException(ex, "constant");
                    return ex;
                }
                if (bootstrap != null && !BootstrapMethodConfiguration.singleton().isCondyAllowedAtBuildTime(OriginalMethodProvider.getJavaMethod((ResolvedJavaMethod)bootstrap.getMethod()))) {
                    int parameterLength = bootstrap.getMethod().getParameters().length;
                    List staticArguments = bootstrap.getStaticArguments();
                    boolean isVarargs = bootstrap.getMethod().isVarArgs();
                    JavaConstant type = ((ImageHeapInstance)bootstrap.getType()).getHostedObject();
                    DynamicHub typeClass = (DynamicHub)((DirectSubstrateObjectConstant)type).getObject();
                    boolean isPrimitive = typeClass.isPrimitive();
                    for (JavaConstant argument : staticArguments) {
                        ImageHeapInstance imageHeapInstance;
                        Object arg;
                        if (!(argument instanceof ImageHeapInstance) || !((arg = ((DirectSubstrateObjectConstant)(imageHeapInstance = (ImageHeapInstance)argument).getHostedObject()).getObject()) instanceof UnresolvedJavaType)) continue;
                        return arg;
                    }
                    if (this.isBootstrapInvocationInvalid(bootstrap, parameterLength, staticArguments, isVarargs, typeClass.getHostedJavaClass())) {
                        return SharedBytecodeParser.super.lookupConstant(cpi, opcode, true);
                    }
                    Object resolvedObject = this.resolveLinkedObject(SharedBytecodeParser.this.bci(), cpi, opcode, bootstrap, parameterLength, staticArguments, isVarargs, isPrimitive);
                    if (resolvedObject instanceof Throwable) {
                        return resolvedObject;
                    }
                    ValueNode resolvedObjectNode = (ValueNode)resolvedObject;
                    if (typeClass.isPrimitive()) {
                        JavaKind constantKind = SharedBytecodeParser.this.getMetaAccessExtensionProvider().getStorageKind((JavaType)SharedBytecodeParser.this.getMetaAccess().lookupJavaType(typeClass.getHostedJavaClass()));
                        resolvedObjectNode = (ValueNode)SharedBytecodeParser.this.append((Node)UnboxNode.create((MetaAccessProvider)SharedBytecodeParser.this.getMetaAccess(), (ConstantReflectionProvider)SharedBytecodeParser.this.getConstantReflection(), (ValueNode)resolvedObjectNode, (JavaKind)constantKind));
                    }
                    return resolvedObjectNode;
                }
                return SharedBytecodeParser.super.lookupConstant(cpi, opcode, true);
            }

            protected Object resolveLinkedObject(int bci, int cpi, int opcode, BootstrapMethodIntrospection bootstrap, int parameterLength, List<JavaConstant> staticArgumentsList, boolean isVarargs, boolean isPrimitiveConstant) {
                ValueNode bootstrapObjectNode;
                InvokeWithExceptionNode bootstrapObject;
                AnalysisConstantReflectionProvider analysisConstantReflection = (AnalysisConstantReflectionProvider)SharedBytecodeParser.this.getConstantReflection();
                ResolvedJavaMethod bootstrapMethod = bootstrap.getMethod();
                BootstrapMethodConfiguration.BootstrapMethodRecord bootstrapMethodRecord = new BootstrapMethodConfiguration.BootstrapMethodRecord(bci, cpi, (ResolvedJavaMethod)((AnalysisMethod)SharedBytecodeParser.this.method).getMultiMethod(MultiMethod.ORIGINAL_METHOD));
                BootstrapMethodInfo bootstrapMethodInfo = BootstrapMethodConfiguration.singleton().getBootstrapMethodInfoCache().computeIfAbsent(bootstrapMethodRecord, key -> new BootstrapMethodInfo());
                ConstantNode bootstrapMethodInfoNode = ConstantNode.forConstant((JavaConstant)analysisConstantReflection.forObject(bootstrapMethodInfo), (MetaAccessProvider)SharedBytecodeParser.this.getMetaAccess(), (StructuredGraph)SharedBytecodeParser.this.getGraph());
                Field bootstrapObjectField = ReflectionUtil.lookupField(BootstrapMethodInfo.class, (String)"object");
                AnalysisField bootstrapObjectResolvedField = (AnalysisField)SharedBytecodeParser.this.getMetaAccess().lookupJavaField(bootstrapObjectField);
                LoadFieldNode bootstrapObjectFieldNode = (LoadFieldNode)SharedBytecodeParser.this.append((Node)LoadFieldNode.create((Assumptions)SharedBytecodeParser.this.getAssumptions(), (ValueNode)bootstrapMethodInfoNode, (ResolvedJavaField)bootstrapObjectResolvedField, (MemoryOrderMode)MemoryOrderMode.ACQUIRE));
                ValueNode[] arguments = new ValueNode[parameterLength];
                if (isVarargs) {
                    JavaType varargClass = bootstrapMethod.getParameters()[parameterLength - 1].getType().getComponentType();
                    arguments[arguments.length - 1] = (ValueNode)SharedBytecodeParser.this.append((Node)new NewArrayNode((ResolvedJavaType)((AnalysisMetaAccess)SharedBytecodeParser.this.getMetaAccess()).getUniverse().lookup(varargClass), (ValueNode)ConstantNode.forInt((int)(staticArgumentsList.size() - arguments.length + 4), (StructuredGraph)SharedBytecodeParser.this.getGraph()), true));
                }
                for (int i = 0; i < staticArgumentsList.size(); ++i) {
                    ConstantNode currentNode;
                    JavaConstant constant = staticArgumentsList.get(i);
                    if (constant instanceof PrimitiveConstant) {
                        PrimitiveConstant primitiveConstant = (PrimitiveConstant)constant;
                        int argCpi = primitiveConstant.asInt();
                        Object argConstant = this.loadConstantDynamic(argCpi, opcode == 186 ? 18 : opcode);
                        if (argConstant instanceof ValueNode) {
                            ValueNode valueNode = (ValueNode)argConstant;
                            currentNode = valueNode;
                        } else {
                            if (argConstant instanceof Throwable || argConstant instanceof UnresolvedJavaType) {
                                return argConstant;
                            }
                            currentNode = ConstantNode.forConstant((JavaConstant)analysisConstantReflection.forObject(argConstant), (MetaAccessProvider)SharedBytecodeParser.this.getMetaAccess(), (StructuredGraph)SharedBytecodeParser.this.getGraph());
                        }
                    } else {
                        currentNode = isVarargs && i + 4 >= parameterLength ? ConstantNode.forConstant((JavaConstant)constant, (MetaAccessProvider)SharedBytecodeParser.this.getMetaAccess(), (StructuredGraph)SharedBytecodeParser.this.getGraph()) : this.createConstant(constant);
                    }
                    this.addArgument(isVarargs, arguments, i + 3, (ValueNode)currentNode);
                }
                LogicNode condition = (LogicNode)SharedBytecodeParser.this.graph.unique((Node)IsNullNode.create((ValueNode)bootstrapObjectFieldNode));
                EndNode falseEnd = (EndNode)SharedBytecodeParser.this.graph.add((Node)new EndNode());
                InvokeWithExceptionNode lookup = this.invokeMethodAndAdd(bci, MethodHandles.class, MethodHandles.Lookup.class, "lookup", CallTargetNode.InvokeKind.Static, ValueNode.EMPTY_ARRAY, new Class[0]);
                ValueNode lookupNode = SharedBytecodeParser.this.frameState.pop(JavaKind.Object);
                this.addArgument(isVarargs, arguments, 0, lookupNode);
                ConstantNode bootstrapName = ConstantNode.forConstant((JavaConstant)analysisConstantReflection.forString(bootstrap.getName()), (MetaAccessProvider)SharedBytecodeParser.this.getMetaAccess(), (StructuredGraph)SharedBytecodeParser.this.getGraph());
                this.addArgument(isVarargs, arguments, 1, (ValueNode)bootstrapName);
                this.addArgument(isVarargs, arguments, 2, (ValueNode)ConstantNode.forConstant((JavaConstant)bootstrap.getType(), (MetaAccessProvider)SharedBytecodeParser.this.getMetaAccess(), (StructuredGraph)SharedBytecodeParser.this.getGraph()));
                if (bootstrapMethod.isConstructor()) {
                    ValueNode[] oldArguments = arguments;
                    arguments = new ValueNode[arguments.length + 1];
                    arguments[0] = (ValueNode)SharedBytecodeParser.this.graph.add((Node)new NewInstanceNode(bootstrapMethod.getDeclaringClass(), true));
                    System.arraycopy(oldArguments, 0, arguments, 1, oldArguments.length);
                }
                Class returnClass = OriginalClassProvider.getJavaClass((JavaType)((ResolvedJavaType)bootstrapMethod.getSignature().getReturnType(null)));
                if (bootstrapMethod.isConstructor()) {
                    bootstrapObject = this.invokeMethodAndAddCustomExceptionHandler(bci, Void.TYPE, CallTargetNode.InvokeKind.Special, arguments, bootstrapMethod);
                    bootstrapObjectNode = arguments[0];
                } else {
                    bootstrapObject = this.invokeMethodAndAddCustomExceptionHandler(bci, returnClass, CallTargetNode.InvokeKind.Static, arguments, bootstrapMethod);
                    bootstrapObjectNode = SharedBytecodeParser.this.frameState.pop(bootstrapObject.getStackKind());
                }
                ValueNode finalBootstrapObjectNode = bootstrapObjectNode;
                FixedWithNextNode fixedFinalBootstrapObjectNode = null;
                if (isPrimitiveConstant) {
                    fixedFinalBootstrapObjectNode = (FixedWithNextNode)SharedBytecodeParser.this.graph.add((Node)BoxNode.create((ValueNode)bootstrapObjectNode, (ResolvedJavaType)SharedBytecodeParser.this.getMetaAccess().lookupJavaType(bootstrapObjectNode.getStackKind().toBoxedJavaClass()), (JavaKind)bootstrapObjectNode.getStackKind()));
                    finalBootstrapObjectNode = fixedFinalBootstrapObjectNode;
                }
                InvokeWithExceptionNode exceptionWrapperNode = this.wrapException(bci, (ValueNode)bootstrapObject.exceptionEdge());
                bootstrapObject.exceptionEdge().setNext((FixedNode)exceptionWrapperNode);
                MergeNode linkMerge = (MergeNode)SharedBytecodeParser.this.graph.add((Node)new MergeNode());
                linkMerge.setStateAfter(SharedBytecodeParser.this.createFrameState(SharedBytecodeParser.this.stream.nextBCI(), (StateSplit)linkMerge));
                EndNode n = (EndNode)SharedBytecodeParser.this.graph.add((Node)new EndNode());
                exceptionWrapperNode.setNext((FixedNode)n);
                linkMerge.addForwardEnd(n);
                EndNode noExceptionEnd = (EndNode)SharedBytecodeParser.this.graph.add((Node)new EndNode());
                finalBootstrapObjectNode = (ValueNode)SharedBytecodeParser.this.graph.unique((Node)new ValuePhiNode(StampFactory.object(), (AbstractMergeNode)linkMerge, new ValueNode[]{exceptionWrapperNode, finalBootstrapObjectNode}));
                ConstantNode nullConstant = ConstantNode.forConstant((JavaConstant)JavaConstant.NULL_POINTER, (MetaAccessProvider)SharedBytecodeParser.this.getMetaAccess(), (StructuredGraph)SharedBytecodeParser.this.getGraph());
                ValueNode offset = (ValueNode)SharedBytecodeParser.this.graph.addOrUniqueWithInputs((Node)LazyConstantNode.create(StampFactory.forKind((JavaKind)JavaKind.Long), new SubstrateGraphBuilderPlugins.FieldOffsetConstantProvider(bootstrapObjectField), (CoreProviders)SharedBytecodeParser.this));
                FieldLocationIdentity fieldLocationIdentity = new FieldLocationIdentity((ResolvedJavaField)bootstrapObjectResolvedField);
                FixedWithNextNode linkBootstrapObject = (FixedWithNextNode)SharedBytecodeParser.this.graph.add((Node)new UnsafeCompareAndSwapNode((ValueNode)bootstrapMethodInfoNode, offset, (ValueNode)nullConstant, finalBootstrapObjectNode, JavaKind.Object, (LocationIdentity)fieldLocationIdentity, MemoryOrderMode.RELEASE));
                ((StateSplit)linkBootstrapObject).setStateAfter(SharedBytecodeParser.this.createFrameState(SharedBytecodeParser.this.stream.nextBCI(), (StateSplit)linkBootstrapObject));
                NodeSourcePosition nodeSourcePosition = SharedBytecodeParser.this.getGraph().currentNodeSourcePosition();
                String reason = nodeSourcePosition == null ? "Unknown graph builder location." : nodeSourcePosition;
                bootstrapObjectResolvedField.registerAsAccessed((Object)reason);
                bootstrapObjectResolvedField.registerAsUnsafeAccessed((Object)reason);
                EndNode trueEnd = (EndNode)SharedBytecodeParser.this.graph.add((Node)new EndNode());
                if (bootstrapMethod.isConstructor()) {
                    lookup.setNext((FixedNode)bootstrapObjectNode);
                    ((FixedWithNextNode)bootstrapObjectNode).setNext((FixedNode)bootstrapObject);
                } else {
                    lookup.setNext((FixedNode)bootstrapObject);
                }
                if (isPrimitiveConstant) {
                    bootstrapObject.setNext((FixedNode)fixedFinalBootstrapObjectNode);
                    fixedFinalBootstrapObjectNode.setNext((FixedNode)noExceptionEnd);
                } else {
                    bootstrapObject.setNext((FixedNode)noExceptionEnd);
                }
                linkMerge.addForwardEnd(noExceptionEnd);
                linkMerge.setNext((FixedNode)linkBootstrapObject);
                linkBootstrapObject.setNext((FixedNode)trueEnd);
                SharedBytecodeParser.this.append((Node)new IfNode(condition, (FixedNode)lookup, (FixedNode)falseEnd, BranchProbabilityNode.NOT_FREQUENT_PROFILE));
                MergeNode mergeNode = (MergeNode)SharedBytecodeParser.this.append((Node)new MergeNode());
                mergeNode.setStateAfter(SharedBytecodeParser.this.createFrameState(SharedBytecodeParser.this.stream.nextBCI(), (StateSplit)mergeNode));
                mergeNode.addForwardEnd(trueEnd);
                mergeNode.addForwardEnd(falseEnd);
                LoadFieldNode result = (LoadFieldNode)SharedBytecodeParser.this.append((Node)LoadFieldNode.create((Assumptions)SharedBytecodeParser.this.getAssumptions(), (ValueNode)bootstrapMethodInfoNode, (ResolvedJavaField)bootstrapObjectResolvedField, (MemoryOrderMode)MemoryOrderMode.ACQUIRE));
                TypeReference exceptionWrapper = TypeReference.create((Assumptions)SharedBytecodeParser.this.getAssumptions(), (ResolvedJavaType)SharedBytecodeParser.this.getMetaAccess().lookupJavaType(BootstrapMethodInfo.ExceptionWrapper.class));
                LogicNode instanceOfException = (LogicNode)SharedBytecodeParser.this.graph.unique((Node)InstanceOfNode.create((TypeReference)exceptionWrapper, (ValueNode)result));
                EndNode checkExceptionTrueEnd = (EndNode)SharedBytecodeParser.this.graph.add((Node)new EndNode());
                EndNode checkExceptionFalseEnd = (EndNode)SharedBytecodeParser.this.graph.add((Node)new EndNode());
                Field exceptionWrapperField = ReflectionUtil.lookupField(BootstrapMethodInfo.ExceptionWrapper.class, (String)"throwable");
                ResolvedJavaField exceptionWrapperResolvedField = SharedBytecodeParser.this.getMetaAccess().lookupJavaField(exceptionWrapperField);
                LoadFieldNode throwable = (LoadFieldNode)SharedBytecodeParser.this.graph.add((Node)LoadFieldNode.create((Assumptions)SharedBytecodeParser.this.getAssumptions(), (ValueNode)result, (ResolvedJavaField)exceptionWrapperResolvedField));
                InvokeWithExceptionNode bootstrapMethodError = this.throwBootstrapMethodError(bci, (ValueNode)throwable);
                throwable.setNext((FixedNode)bootstrapMethodError);
                bootstrapMethodError.setNext((FixedNode)checkExceptionTrueEnd);
                SharedBytecodeParser.this.append((Node)new IfNode(instanceOfException, (FixedNode)throwable, (FixedNode)checkExceptionFalseEnd, BranchProbabilityNode.NOT_FREQUENT_PROFILE));
                MergeNode checkExceptionMergeNode = (MergeNode)SharedBytecodeParser.this.append((Node)new MergeNode());
                checkExceptionMergeNode.setStateAfter(SharedBytecodeParser.this.createFrameState(SharedBytecodeParser.this.stream.nextBCI(), (StateSplit)checkExceptionMergeNode));
                checkExceptionMergeNode.addForwardEnd(checkExceptionTrueEnd);
                checkExceptionMergeNode.addForwardEnd(checkExceptionFalseEnd);
                return result;
            }

            private void addArgument(boolean isVarargs, ValueNode[] arguments, int i, ValueNode currentNode) {
                if (isVarargs && i >= arguments.length - 1) {
                    StoreIndexedNode storeIndexedNode = (StoreIndexedNode)SharedBytecodeParser.this.append((Node)new StoreIndexedNode(arguments[arguments.length - 1], (ValueNode)ConstantNode.forInt((int)(i + 1 - arguments.length), (StructuredGraph)SharedBytecodeParser.this.getGraph()), null, null, JavaKind.Object, currentNode));
                    storeIndexedNode.setStateAfter(SharedBytecodeParser.this.createFrameState(SharedBytecodeParser.this.stream.nextBCI(), (StateSplit)storeIndexedNode));
                } else {
                    arguments[i] = currentNode;
                }
            }

            private InvokeWithExceptionNode wrapException(int bci, ValueNode exception) {
                Constructor exceptionWrapperCtor = ReflectionUtil.lookupConstructor(BootstrapMethodInfo.ExceptionWrapper.class, (Class[])new Class[]{Throwable.class});
                AnalysisMetaAccess metaAccess = (AnalysisMetaAccess)SharedBytecodeParser.this.getMetaAccess();
                AnalysisMethod exceptionWrapperMethod = FactoryMethodSupport.singleton().lookup(metaAccess, metaAccess.lookupJavaMethod((Executable)exceptionWrapperCtor), false);
                InvokeWithExceptionNode exceptionWrapper = this.invokeMethodAndAdd(bci, BootstrapMethodInfo.ExceptionWrapper.class, CallTargetNode.InvokeKind.Static, new ValueNode[]{exception}, (ResolvedJavaMethod)exceptionWrapperMethod);
                SharedBytecodeParser.this.frameState.pop(JavaKind.Object);
                return exceptionWrapper;
            }

            protected InvokeWithExceptionNode throwBootstrapMethodError(int bci, ValueNode exception) {
                Constructor errorCtor = ReflectionUtil.lookupConstructor(BootstrapMethodError.class, (Class[])new Class[]{Throwable.class});
                AnalysisMetaAccess metaAccess = (AnalysisMetaAccess)SharedBytecodeParser.this.getMetaAccess();
                AnalysisMethod bootstrapMethodErrorMethod = FactoryMethodSupport.singleton().lookup(metaAccess, metaAccess.lookupJavaMethod((Executable)errorCtor), true);
                return this.invokeMethodAndAdd(bci, Void.TYPE, CallTargetNode.InvokeKind.Static, new ValueNode[]{exception}, (ResolvedJavaMethod)bootstrapMethodErrorMethod);
            }

            private boolean isBootstrapInvocationInvalid(BootstrapMethodIntrospection bootstrap, int parameterLength, List<JavaConstant> staticArgumentsList, boolean isVarargs, Class<?> typeClass) {
                ResolvedJavaMethod method = bootstrap.getMethod();
                return isVarargs && parameterLength > 3 + staticArgumentsList.size() || !isVarargs && parameterLength != 3 + staticArgumentsList.size() || !OriginalClassProvider.getJavaClass((JavaType)((ResolvedJavaType)method.getSignature().getReturnType(null))).isAssignableFrom(typeClass) && !method.isConstructor() || !this.checkBootstrapParameters(method, bootstrap.getStaticArguments(), true);
            }

            protected boolean checkBootstrapParameters(ResolvedJavaMethod bootstrapMethod, List<JavaConstant> staticArguments, boolean condy) {
                int parametersLength = bootstrapMethod.getParameters().length;
                Class<?>[] parameters = SharedBytecodeParser.signatureToClasses((JavaMethod)bootstrapMethod);
                if (bootstrapMethod.isVarArgs()) {
                    parameters[parametersLength - 1] = parameters[parametersLength - 1].getComponentType();
                }
                if (!bootstrapMethod.isVarArgs() && 3 + staticArguments.size() != parameters.length) {
                    return false;
                }
                for (int i = 0; i < parametersLength; ++i) {
                    ImageHeapConstant imageHeapConstant;
                    Class parameterClass;
                    JavaConstant javaConstant;
                    if (!(i == 0 ? !(!condy ? parameters[i].isAssignableFrom(MethodHandles.Lookup.class) : parameters[i].equals(MethodHandles.Lookup.class)) : (i == 1 ? !parameters[i].isAssignableFrom(String.class) : (i == 2 ? !parameters[i].isAssignableFrom(condy ? Class.class : MethodType.class) : (!bootstrapMethod.isVarArgs() || staticArguments.size() != i - 3) && (javaConstant = staticArguments.get(i - 3)) instanceof ImageHeapConstant && !parameters[i].isAssignableFrom(parameterClass = OriginalClassProvider.getJavaClass((JavaType)(imageHeapConstant = (ImageHeapConstant)javaConstant).getType(SharedBytecodeParser.this.getMetaAccess()))) && !SubstrateUtil.toUnboxedClass(parameters[i]).isAssignableFrom(SubstrateUtil.toUnboxedClass(parameterClass)))))) continue;
                    return false;
                }
                return true;
            }

            protected void handleBootstrapException(Throwable ex, String elementKind) {
                if (SharedBytecodeParser.this.linkAtBuildTime) {
                    SharedBytecodeParser.this.reportUnresolvedElement(elementKind, SharedBytecodeParser.this.method.format("%H.%n(%P)"), ex);
                } else {
                    SharedBytecodeParser.replaceWithThrowingAtRuntime(SharedBytecodeParser.this, ex);
                }
            }

            protected ConstantNode createConstant(JavaConstant constant) {
                JavaConstant primitiveConstant = SharedBytecodeParser.this.getConstantReflection().unboxPrimitive(constant);
                return ConstantNode.forConstant((JavaConstant)(primitiveConstant == null ? constant : primitiveConstant), (MetaAccessProvider)SharedBytecodeParser.this.getMetaAccess(), (StructuredGraph)SharedBytecodeParser.this.getGraph());
            }

            protected Invoke invokeMethodAndAppend(int bci, Class<?> clazz, Class<?> returnClass, String name, CallTargetNode.InvokeKind invokeKind, ValueNode[] arguments, Class<?> ... classes) {
                ResolvedJavaMethod invokedMethod = this.lookupResolvedJavaMethod(clazz, name, classes);
                CallTargetNode callTarget = (CallTargetNode)SharedBytecodeParser.this.graph.add((Node)SharedBytecodeParser.this.createMethodCallTarget(invokeKind, invokedMethod, arguments, returnClass, null));
                return SharedBytecodeParser.this.createNonInlinedInvoke(BytecodeParser.ExceptionEdgeAction.INCLUDE_AND_HANDLE, bci, callTarget, callTarget.returnStamp().getTrustedStamp().getStackKind());
            }

            protected InvokeWithExceptionNode invokeMethodAndAdd(int bci, Class<?> clazz, Class<?> returnClass, String name, CallTargetNode.InvokeKind invokeKind, ValueNode[] arguments, Class<?> ... classes) {
                ResolvedJavaMethod invokedMethod = this.lookupResolvedJavaMethod(clazz, name, classes);
                return this.invokeMethodAndAdd(bci, returnClass, invokeKind, arguments, invokedMethod);
            }

            protected InvokeWithExceptionNode invokeMethodAndAdd(int bci, Class<?> returnClass, CallTargetNode.InvokeKind invokeKind, ValueNode[] arguments, ResolvedJavaMethod invokedMethod) {
                CallTargetNode callTarget = (CallTargetNode)SharedBytecodeParser.this.graph.add((Node)SharedBytecodeParser.this.createMethodCallTarget(invokeKind, invokedMethod, arguments, returnClass, null));
                InvokeWithExceptionNode invoke = (InvokeWithExceptionNode)SharedBytecodeParser.this.graph.add((Node)SharedBytecodeParser.this.createInvokeWithException(bci, callTarget, callTarget.returnStamp().getTrustedStamp().getStackKind(), BytecodeParser.ExceptionEdgeAction.INCLUDE_AND_HANDLE));
                invoke.setStateAfter(SharedBytecodeParser.this.createFrameState(SharedBytecodeParser.this.stream.nextBCI(), (StateSplit)invoke));
                return invoke;
            }

            protected InvokeWithExceptionNode invokeMethodAndAddCustomExceptionHandler(int bci, Class<?> returnClass, CallTargetNode.InvokeKind invokeKind, ValueNode[] arguments, ResolvedJavaMethod invokedMethod) {
                CallTargetNode callTarget = (CallTargetNode)SharedBytecodeParser.this.graph.add((Node)SharedBytecodeParser.this.createMethodCallTarget(invokeKind, invokedMethod, arguments, returnClass, null));
                ExceptionObjectNode exceptionObject = (ExceptionObjectNode)SharedBytecodeParser.this.graph.add((Node)new ExceptionObjectNode(SharedBytecodeParser.this.getMetaAccess()));
                FrameStateBuilder dispatchState = SharedBytecodeParser.this.frameState.copy();
                dispatchState.clearStack();
                dispatchState.pushReturn(JavaKind.Object, (ValueNode)exceptionObject);
                dispatchState.setRethrowException(true);
                exceptionObject.setStateAfter(dispatchState.create(SharedBytecodeParser.this.stream.nextBCI(), (StateSplit)exceptionObject));
                InvokeWithExceptionNode invoke = (InvokeWithExceptionNode)SharedBytecodeParser.this.graph.add((Node)new InvokeWithExceptionNode(callTarget, (AbstractBeginNode)exceptionObject, bci));
                SharedBytecodeParser.this.frameState.pushReturn(callTarget.returnStamp().getTrustedStamp().getStackKind(), (ValueNode)invoke);
                invoke.setStateAfter(SharedBytecodeParser.this.createFrameState(SharedBytecodeParser.this.stream.nextBCI(), (StateSplit)invoke));
                return invoke;
            }

            private ResolvedJavaMethod lookupResolvedJavaMethod(Class<?> clazz, String name, Class<?> ... classes) {
                try {
                    return SharedBytecodeParser.this.getMetaAccess().lookupJavaMethod((Executable)clazz.getDeclaredMethod(name, classes));
                }
                catch (NoSuchMethodException e) {
                    throw GraalError.shouldNotReachHere((String)("Could not find method in " + String.valueOf(clazz) + " named " + name));
                }
            }
        }
    }
}

