/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.infrastructure.WrappedConstantPool;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedPrimitiveType;
import com.oracle.svm.hosted.meta.HostedType;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public class HostedUniverse
implements Universe {
    protected final Inflation bb;
    protected final Map<AnalysisType, HostedType> types = new HashMap<AnalysisType, HostedType>();
    protected final Map<AnalysisField, HostedField> fields = new HashMap<AnalysisField, HostedField>();
    protected final Map<AnalysisMethod, HostedMethod> methods = new HashMap<AnalysisMethod, HostedMethod>();
    protected final Map<ResolvedSignature<AnalysisType>, ResolvedSignature<HostedType>> signatures = new HashMap<ResolvedSignature<AnalysisType>, ResolvedSignature<HostedType>>();
    protected final Map<ConstantPool, WrappedConstantPool> constantPools = new HashMap<ConstantPool, WrappedConstantPool>();
    protected EnumMap<JavaKind, HostedType> kindToType = new EnumMap(JavaKind.class);
    protected List<HostedType> orderedTypes;
    protected List<HostedField> orderedFields;
    protected List<HostedMethod> orderedMethods;
    public static final Comparator<HostedType> TYPE_COMPARATOR = new TypeComparator();
    public static final Comparator<HostedMethod> METHOD_COMPARATOR = new MethodComparator(TYPE_COMPARATOR);
    static final Comparator<HostedField> FIELD_COMPARATOR_RELAXED = Comparator.comparing(JavaField::getJavaKind).reversed();

    public HostedUniverse(Inflation bb) {
        this.bb = bb;
    }

    public HostedType getType(JavaKind kind) {
        assert (this.kindToType.containsKey(kind));
        return this.kindToType.get(kind);
    }

    public HostedInstanceClass getObjectClass() {
        HostedInstanceClass result = (HostedInstanceClass)this.kindToType.get(JavaKind.Object);
        assert (result != null);
        return result;
    }

    public boolean contains(JavaType type) {
        return this.types.containsKey(type);
    }

    public SVMHost hostVM() {
        return this.bb.getHostVM();
    }

    public SnippetReflectionProvider getSnippetReflection() {
        return this.bb.getSnippetReflectionProvider();
    }

    public HostedType lookup(JavaType type) {
        JavaType result = this.lookupAllowUnresolved(type);
        if (result == null) {
            return null;
        }
        if (result instanceof ResolvedJavaType) {
            return (HostedType)result;
        }
        throw new UnsupportedFeatureException("Unresolved type found. Probably there are some compilation or classpath problems. " + type.toJavaName(true));
    }

    public JavaType lookupAllowUnresolved(JavaType type) {
        if (!(type instanceof ResolvedJavaType)) {
            return type;
        }
        assert (this.types.containsKey(type)) : type;
        return this.optionalLookup(type);
    }

    public HostedType optionalLookup(JavaType type) {
        return this.types.get(type);
    }

    public HostedType[] optionalLookup(JavaType ... javaTypes) {
        HostedType[] result = new HostedType[javaTypes.length];
        for (int i = 0; i < javaTypes.length; ++i) {
            result[i] = this.optionalLookup(javaTypes[i]);
            if (result[i] != null) continue;
            return null;
        }
        return result;
    }

    public HostedField lookup(JavaField field) {
        JavaField result = this.lookupAllowUnresolved(field);
        if (result instanceof ResolvedJavaField) {
            return (HostedField)result;
        }
        throw new UnsupportedFeatureException("Unresolved field found. Probably there are some compilation or classpath problems. " + field.format("%H.%n"));
    }

    public JavaField lookupAllowUnresolved(JavaField field) {
        if (!(field instanceof ResolvedJavaField)) {
            return field;
        }
        assert (this.fields.containsKey(field)) : field;
        return this.optionalLookup(field);
    }

    public HostedField optionalLookup(JavaField field) {
        return this.fields.get(field);
    }

    private static void ensureOriginalMethod(JavaMethod method) {
        if (method instanceof MultiMethod) {
            MultiMethod.MultiMethodKey key = ((MultiMethod)method).getMultiMethodKey();
            VMError.guarantee(key == MultiMethod.ORIGINAL_METHOD, "looking up method with wrong id: %s", key);
        }
    }

    public HostedMethod lookup(JavaMethod method) {
        HostedUniverse.ensureOriginalMethod(method);
        JavaMethod result = this.lookupAllowUnresolved(method);
        if (result instanceof ResolvedJavaMethod) {
            return (HostedMethod)result;
        }
        throw new UnsupportedFeatureException("Unresolved method found: " + (method != null ? method.format("%H.%n(%p)") : "null") + ". Probably there are some compilation or classpath problems. ");
    }

    public JavaMethod lookupAllowUnresolved(JavaMethod method) {
        HostedUniverse.ensureOriginalMethod(method);
        if (!(method instanceof ResolvedJavaMethod)) {
            return method;
        }
        assert (this.methods.containsKey(method)) : method;
        return this.optionalLookup(method);
    }

    public HostedMethod optionalLookup(JavaMethod method) {
        HostedUniverse.ensureOriginalMethod(method);
        return this.methods.get(method);
    }

    public HostedMethod[] lookup(JavaMethod[] inputs) {
        HostedMethod[] result = new HostedMethod[inputs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.lookup(inputs[i]);
        }
        return result;
    }

    public ResolvedSignature<HostedType> lookup(Signature signature, ResolvedJavaType defaultAccessingClass) {
        assert (this.signatures.containsKey(signature)) : signature;
        return this.signatures.get(signature);
    }

    public WrappedConstantPool lookup(ConstantPool constantPool, ResolvedJavaType defaultAccessingClass) {
        assert (this.constantPools.containsKey(constantPool)) : constantPool;
        return this.constantPools.get(constantPool);
    }

    public JavaConstant lookup(JavaConstant c) {
        VMError.guarantee(c == null || c.isNull() || c.getJavaKind().isPrimitive() || c instanceof ImageHeapConstant);
        return c;
    }

    public Collection<HostedType> getTypes() {
        return this.orderedTypes;
    }

    public Collection<HostedField> getFields() {
        return this.orderedFields;
    }

    public Collection<HostedMethod> getMethods() {
        return this.orderedMethods;
    }

    public Inflation getBigBang() {
        return this.bb;
    }

    public ResolvedJavaMethod resolveSubstitution(ResolvedJavaMethod method) {
        return method;
    }

    public HostedType objectType() {
        return this.types.get(this.bb.getUniverse().objectType());
    }

    private static final class TypeComparator
    implements Comparator<HostedType> {
        private TypeComparator() {
        }

        private static Optional<HostedType[]> proxyType(HostedType type) {
            HostedType baseType = type.getBaseType();
            boolean isProxy = Proxy.isProxyClass(baseType.getJavaClass());
            assert (isProxy == baseType.toJavaName(false).startsWith("$Proxy"));
            if (isProxy) {
                return Optional.of(baseType.getInterfaces());
            }
            return Optional.empty();
        }

        @Override
        public int compare(HostedType o1, HostedType o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            Optional<HostedType[]> o1ProxyType = TypeComparator.proxyType(o1);
            Optional<HostedType[]> o2ProxyType = TypeComparator.proxyType(o2);
            if (o1ProxyType.isPresent() || o2ProxyType.isPresent()) {
                HostedType[] array2;
                HostedType[] array1 = o1ProxyType.orElseGet(() -> new HostedType[]{o1});
                int result = Arrays.compare(array1, array2 = o2ProxyType.orElseGet(() -> new HostedType[]{o2}), TYPE_COMPARATOR);
                if (result == 0) {
                    result = Boolean.compare(o1ProxyType.isPresent(), o2ProxyType.isPresent());
                }
                if (result == 0) {
                    assert (o1.isArray() || o2.isArray());
                    result = Integer.compare(o1.getArrayDimension(), o2.getArrayDimension());
                }
                VMError.guarantee(result != 0, "HostedType proxies not distinguishable: %s, %s", o1, o2);
                return result;
            }
            if (!o1.getClass().equals(o2.getClass())) {
                int result = Integer.compare(TypeComparator.ordinal(o1), TypeComparator.ordinal(o2));
                VMError.guarantee(result != 0, "HostedType objects not distinguishable by ordinal number: %s, %s", o1, o2);
                return result;
            }
            if (o1.isPrimitive() && o2.isPrimitive()) {
                assert (o1 instanceof HostedPrimitiveType && o2 instanceof HostedPrimitiveType);
                int result = o1.getJavaKind().compareTo((Enum)o2.getJavaKind());
                VMError.guarantee(result != 0, "HostedPrimitiveType objects not distinguishable by javaKind: %s, %s", o1, o2);
                return result;
            }
            if (o1.isArray() && o2.isArray()) {
                assert (o1 instanceof HostedArrayClass && o2 instanceof HostedArrayClass);
                int result = this.compare(o1.getComponentType(), o2.getComponentType());
                VMError.guarantee(result != 0, "HostedArrayClass objects not distinguishable by componentType: %s, %s", o1, o2);
                return result;
            }
            int result = o1.getName().compareTo(o2.getName());
            if (result != 0) {
                return result;
            }
            ClassLoader l1 = Optional.ofNullable(o1.getJavaClass()).map(Class::getClassLoader).orElse(null);
            ClassLoader l2 = Optional.ofNullable(o2.getJavaClass()).map(Class::getClassLoader).orElse(null);
            result = SubstrateUtil.classLoaderNameAndId(l1).compareTo(SubstrateUtil.classLoaderNameAndId(l2));
            VMError.guarantee(result != 0, "HostedType objects not distinguishable by name and classloader: %s, %s", o1, o2);
            return result;
        }

        private static int ordinal(HostedType type) {
            if (type.isInterface()) {
                return 4;
            }
            if (type.isArray()) {
                return 3;
            }
            if (type.isInstanceClass()) {
                return 2;
            }
            if (type.getJavaKind() != JavaKind.Object) {
                return 1;
            }
            throw VMError.shouldNotReachHereUnexpectedInput(type);
        }
    }

    private static final class MethodComparator
    implements Comparator<HostedMethod> {
        private final Comparator<HostedType> typeComparator;

        private MethodComparator(Comparator<HostedType> typeComparator) {
            this.typeComparator = typeComparator;
        }

        @Override
        public int compare(HostedMethod o1, HostedMethod o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            int result = Boolean.compare(o1.isDeoptTarget(), o2.isDeoptTarget());
            if (result != 0) {
                return result;
            }
            result = this.typeComparator.compare(o1.getDeclaringClass(), o2.getDeclaringClass());
            if (result != 0) {
                return result;
            }
            result = o1.getName().compareTo(o2.getName());
            if (result != 0) {
                return result;
            }
            ResolvedSignature<HostedType> signature1 = o1.getSignature();
            ResolvedSignature<HostedType> signature2 = o2.getSignature();
            int parameterCount1 = signature1.getParameterCount(false);
            result = Integer.compare(parameterCount1, signature2.getParameterCount(false));
            if (result != 0) {
                return result;
            }
            for (int i = 0; i < parameterCount1; ++i) {
                result = this.typeComparator.compare((HostedType)signature1.getParameterType(i), (HostedType)signature2.getParameterType(i));
                if (result == 0) continue;
                return result;
            }
            result = this.typeComparator.compare((HostedType)signature1.getReturnType(), (HostedType)signature2.getReturnType());
            if (result != 0) {
                return result;
            }
            throw VMError.shouldNotReachHere("HostedMethod objects not distinguishable: " + String.valueOf(o1) + ", " + String.valueOf(o2));
        }
    }
}

