/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.graal.meta.SubstrateSnippetReflectionProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.meta.RelocatableConstant;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.word.WordBase;

public class HostedSnippetReflectionProvider
extends SubstrateSnippetReflectionProvider {
    private ImageHeapScanner heapScanner;

    public HostedSnippetReflectionProvider(ImageHeapScanner heapScanner, WordTypes wordTypes) {
        super(wordTypes);
        this.heapScanner = heapScanner;
    }

    public void setHeapScanner(ImageHeapScanner heapScanner) {
        this.heapScanner = heapScanner;
    }

    @Override
    public JavaConstant forObject(Object object) {
        if (object instanceof RelocatedPointer) {
            RelocatedPointer pointer = (RelocatedPointer)object;
            return new RelocatableConstant(pointer);
        }
        if (object instanceof WordBase) {
            WordBase word = (WordBase)object;
            return JavaConstant.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)word.rawValue());
        }
        AnalysisConstantReflectionProvider.validateRawObjectConstant(object);
        return this.heapScanner.createImageHeapConstant(super.forObject(object), ObjectScanner.OtherReason.UNKNOWN);
    }

    @Override
    public JavaConstant forBoxed(JavaKind kind, Object value) {
        if (kind == JavaKind.Object) {
            return this.forObject(value);
        }
        return JavaConstant.forBoxedPrimitive((Object)value);
    }

    @Override
    public <T> T asObject(Class<T> type, JavaConstant c) {
        Object object;
        ImageHeapConstant imageHeapConstant;
        JavaConstant constant = c;
        if (constant instanceof RelocatableConstant) {
            RelocatableConstant relocatable = (RelocatableConstant)constant;
            return type.cast(relocatable.getPointer());
        }
        if (constant instanceof ImageHeapConstant && (constant = (imageHeapConstant = (ImageHeapConstant)constant).getHostedObject()) == null) {
            return null;
        }
        if (type == Class.class && constant instanceof SubstrateObjectConstant && (object = SubstrateObjectConstant.asObject((Constant)constant)) instanceof DynamicHub) {
            DynamicHub hub = (DynamicHub)object;
            return type.cast(hub.getHostedJavaClass());
        }
        return super.asObject(type, constant);
    }
}

