/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.vm.ci.code.site.Reference;

public final class RelocatableBuffer {
    private final ByteBuffer byteBuffer;
    private final SortedMap<Integer, Info> relocations;

    public RelocatableBuffer(long size, ByteOrder byteOrder) {
        int intSize = NumUtil.safeToInt((long)size);
        this.byteBuffer = ByteBuffer.wrap(new byte[intSize]).order(byteOrder);
        this.relocations = new TreeMap<Integer, Info>();
    }

    public void addRelocationWithoutAddend(int key, ObjectFile.RelocationKind relocationKind, Object targetObject) {
        this.relocations.put(key, new Info(relocationKind, 0L, targetObject));
    }

    public void addRelocationWithAddend(int key, ObjectFile.RelocationKind relocationKind, long addend, Object targetObject) {
        this.relocations.put(key, new Info(relocationKind, addend, targetObject));
    }

    public boolean hasRelocations() {
        return !this.relocations.isEmpty();
    }

    public Set<Map.Entry<Integer, Info>> getSortedRelocations() {
        return Collections.unmodifiableSet(this.relocations.entrySet());
    }

    public byte[] getBackingArray() {
        return this.byteBuffer.array();
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public static final class Info {
        private final ObjectFile.RelocationKind relocationKind;
        private final long addend;
        private final Object targetObject;

        Info(ObjectFile.RelocationKind kind, long addend, Object targetObject) {
            this.relocationKind = kind;
            this.addend = addend;
            this.targetObject = targetObject;
            assert (targetObject instanceof Reference || targetObject instanceof MethodPointer || targetObject instanceof SubstrateObjectConstant || targetObject instanceof ImageHeapConstant) : targetObject;
        }

        public int getRelocationSize() {
            return ObjectFile.RelocationKind.getRelocationSize((ObjectFile.RelocationKind)this.relocationKind);
        }

        public ObjectFile.RelocationKind getRelocationKind() {
            return this.relocationKind;
        }

        public long getAddend() {
            return this.addend;
        }

        public Object getTargetObject() {
            return this.targetObject;
        }

        public String toString() {
            return "RelocatableBuffer.Info(targetObject=" + String.valueOf(this.targetObject) + " relocationKind=" + String.valueOf(this.relocationKind) + " addend=" + this.addend + ")";
        }
    }
}

