/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.heap.ImageHeap;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.graal.pointsto.heap.value.ValueSupplier;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.VarHandleFeature;
import com.oracle.svm.core.meta.DirectSubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.ameta.FieldValueInterceptionSupport;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerSupport;
import com.oracle.svm.hosted.methodhandles.MethodHandleFeature;
import com.oracle.svm.hosted.reflect.ReflectionHostedSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.function.Consumer;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.type.TypedConstant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;

public class SVMImageHeapScanner
extends ImageHeapScanner {
    private final ImageClassLoader loader;
    private final Class<?> economicMapImpl;
    private final Field economicMapImplEntriesField;
    private final Field economicMapImplHashArrayField;
    private final Field economicMapImplTotalEntriesField;
    private final Field economicMapImplDeletedEntriesField;
    private final ReflectionHostedSupport reflectionSupport;
    private final Class<?> memberNameClass;
    private final MethodHandleFeature methodHandleSupport;
    private final Class<?> directMethodHandleClass;
    private final VarHandleFeature varHandleSupport;
    private final FieldValueInterceptionSupport fieldValueInterceptionSupport;

    public SVMImageHeapScanner(BigBang bb, ImageHeap imageHeap, ImageClassLoader loader, AnalysisMetaAccess metaAccess, SnippetReflectionProvider snippetReflection, ConstantReflectionProvider aConstantReflection, ObjectScanningObserver aScanningObserver) {
        super(bb, imageHeap, metaAccess, snippetReflection, aConstantReflection, aScanningObserver);
        this.loader = loader;
        this.economicMapImpl = this.getClass("org.graalvm.collections.EconomicMapImpl");
        this.economicMapImplEntriesField = ReflectionUtil.lookupField(this.economicMapImpl, (String)"entries");
        this.economicMapImplHashArrayField = ReflectionUtil.lookupField(this.economicMapImpl, (String)"hashArray");
        this.economicMapImplTotalEntriesField = ReflectionUtil.lookupField(this.economicMapImpl, (String)"totalEntries");
        this.economicMapImplDeletedEntriesField = ReflectionUtil.lookupField(this.economicMapImpl, (String)"deletedEntries");
        ImageSingletons.add(ImageHeapScanner.class, (Object)((Object)this));
        this.reflectionSupport = (ReflectionHostedSupport)ImageSingletons.lookup(ReflectionHostedSupport.class);
        this.memberNameClass = this.getClass("java.lang.invoke.MemberName");
        this.methodHandleSupport = (MethodHandleFeature)ImageSingletons.lookup(MethodHandleFeature.class);
        this.directMethodHandleClass = this.getClass("java.lang.invoke.DirectMethodHandle");
        this.varHandleSupport = (VarHandleFeature)ImageSingletons.lookup(VarHandleFeature.class);
        this.fieldValueInterceptionSupport = FieldValueInterceptionSupport.singleton();
    }

    public static ImageHeapScanner instance() {
        return (ImageHeapScanner)ImageSingletons.lookup(ImageHeapScanner.class);
    }

    protected Class<?> getClass(String className) {
        return this.loader.findClassOrFail(className);
    }

    protected ImageHeapConstant getOrCreateImageHeapConstant(JavaConstant javaConstant, ObjectScanner.ScanReason reason) {
        VMError.guarantee(javaConstant instanceof TypedConstant, "Not a substrate constant: %s", javaConstant);
        return super.getOrCreateImageHeapConstant(javaConstant, reason);
    }

    public boolean isValueAvailable(AnalysisField field) {
        return this.fieldValueInterceptionSupport.isValueAvailable(field);
    }

    public JavaConstant readStaticFieldValue(AnalysisField field) {
        AnalysisConstantReflectionProvider aConstantReflection = (AnalysisConstantReflectionProvider)this.constantReflection;
        JavaConstant constant = aConstantReflection.readValue((UniverseMetaAccess)this.metaAccess, field, null, true);
        if (constant instanceof DirectSubstrateObjectConstant) {
            VMError.guarantee(!SimulateClassInitializerSupport.singleton().isEnabled());
            return this.toImageHeapObject(constant, ObjectScanner.OtherReason.UNKNOWN);
        }
        return constant;
    }

    protected ValueSupplier<JavaConstant> readHostedFieldValue(AnalysisField field, JavaConstant receiver) {
        AnalysisConstantReflectionProvider aConstantReflection = (AnalysisConstantReflectionProvider)this.constantReflection;
        return aConstantReflection.readHostedFieldValue(field, receiver);
    }

    protected JavaConstant transformFieldValue(AnalysisField field, JavaConstant receiverConstant, JavaConstant originalValueConstant) {
        return ((AnalysisConstantReflectionProvider)this.constantReflection).interceptValue((UniverseMetaAccess)this.metaAccess, field, originalValueConstant);
    }

    protected void rescanEconomicMap(EconomicMap<?, ?> map) {
        super.rescanEconomicMap(map);
        if (map.getClass() == this.economicMapImpl) {
            this.rescanField(map, this.economicMapImplEntriesField);
            this.rescanField(map, this.economicMapImplHashArrayField);
            this.rescanField(map, this.economicMapImplTotalEntriesField);
            this.rescanField(map, this.economicMapImplDeletedEntriesField);
        }
    }

    protected void onObjectReachable(ImageHeapConstant imageHeapConstant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        super.onObjectReachable(imageHeapConstant, reason, onAnalysisModified);
        JavaConstant hostedObject = imageHeapConstant.getHostedObject();
        if (hostedObject != null) {
            Object object = this.snippetReflection.asObject(Object.class, hostedObject);
            if (object instanceof Field) {
                Field field = (Field)object;
                this.reflectionSupport.registerHeapReflectionField(field, reason);
            } else if (object instanceof Executable) {
                Executable executable = (Executable)object;
                this.reflectionSupport.registerHeapReflectionExecutable(executable, reason);
            } else if (object instanceof DynamicHub) {
                DynamicHub hub = (DynamicHub)object;
                this.reflectionSupport.registerHeapDynamicHub(hub, reason);
            } else if (object instanceof VarHandle) {
                VarHandle varHandle = (VarHandle)object;
                this.varHandleSupport.registerHeapVarHandle(varHandle);
            } else if (this.directMethodHandleClass.isInstance(object)) {
                this.varHandleSupport.registerHeapMethodHandle((MethodHandle)object);
            } else if (object instanceof MethodType) {
                MethodType methodType = (MethodType)object;
                this.methodHandleSupport.registerHeapMethodType(methodType);
            } else if (this.memberNameClass.isInstance(object)) {
                this.methodHandleSupport.registerHeapMemberName((Member)object);
            }
        }
    }
}

