/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import sun.reflect.annotation.ExceptionProxy;

public final class AnnotationExceptionProxyValue
extends AnnotationMemberValue {
    private final ExceptionProxy exceptionProxy;
    private JavaConstant objectConstant;

    AnnotationExceptionProxyValue(ExceptionProxy exceptionProxy) {
        this.exceptionProxy = exceptionProxy;
    }

    public JavaConstant getObjectConstant() {
        return Objects.requireNonNull(this.objectConstant);
    }

    @Override
    public char getTag() {
        return 'E';
    }

    @Override
    public Object get(Class<?> memberType) {
        return this.exceptionProxy;
    }

    @Override
    public List<Class<?>> getTypes() {
        return Collections.singletonList(this.exceptionProxy.getClass());
    }

    @Override
    public List<JavaConstant> getExceptionProxies(SnippetReflectionProvider snippetReflection) {
        if (this.objectConstant == null) {
            this.objectConstant = snippetReflection.forObject((Object)this.exceptionProxy);
        }
        return Collections.singletonList(this.objectConstant);
    }
}

