/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisField;
import com.oracle.svm.hosted.ameta.FieldValueInterceptionSupport;
import com.oracle.svm.hosted.analysis.FieldValueComputer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.WordBase;

public abstract class CustomTypeFieldHandler {
    protected final BigBang bb;
    private final AnalysisMetaAccess metaAccess;
    private final FieldValueInterceptionSupport fieldValueInterceptionSupport = FieldValueInterceptionSupport.singleton();
    private Set<AnalysisField> processedFields = ConcurrentHashMap.newKeySet();

    public CustomTypeFieldHandler(BigBang bb, AnalysisMetaAccess metaAccess) {
        this.bb = bb;
        this.metaAccess = metaAccess;
    }

    public void handleField(AnalysisField field) {
        if (!this.processedFields.add(field)) {
            return;
        }
        assert (field.isAccessed());
        if (this.fieldValueInterceptionSupport.hasFieldValueTransformer(field)) {
            if (field.getJavaKind().isObject() && !this.fieldValueInterceptionSupport.isValueAvailable(field)) {
                this.injectFieldTypes(field, field.getType());
            } else if (this.bb.trackPrimitiveValues() && field.getStorageKind().isPrimitive() && field instanceof PointsToAnalysisField) {
                PointsToAnalysisField ptaField = (PointsToAnalysisField)field;
                ptaField.saturatePrimitiveField();
            }
        } else {
            Object ptaField = this.fieldValueInterceptionSupport.lookupFieldValueInterceptor(field);
            if (ptaField instanceof FieldValueComputer) {
                FieldValueComputer fieldValueComputer = (FieldValueComputer)ptaField;
                if (field.getStorageKind().isObject()) {
                    field.setCanBeNull(fieldValueComputer.canBeNull());
                    this.injectFieldTypes(field, this.transformTypes(field, fieldValueComputer.types()));
                } else if (this.bb.trackPrimitiveValues() && field.getStorageKind().isPrimitive() && field instanceof PointsToAnalysisField) {
                    ptaField = (PointsToAnalysisField)field;
                    ptaField.saturatePrimitiveField();
                }
            }
        }
    }

    private void injectFieldTypes(AnalysisField field, List<AnalysisType> customTypes) {
        for (AnalysisType type : customTypes) {
            if (type.isPrimitive()) continue;
            type.registerAsAllocated((Object)"Is declared as the type of an unknown object field.");
        }
        this.injectFieldTypes(field, customTypes.toArray(new AnalysisType[0]));
    }

    protected abstract void injectFieldTypes(AnalysisField var1, AnalysisType ... var2);

    private List<AnalysisType> transformTypes(AnalysisField field, List<Class<?>> types) {
        ArrayList<AnalysisType> customTypes = new ArrayList<AnalysisType>();
        AnalysisType declaredType = field.getType();
        for (Class<?> customType : types) {
            AnalysisType aCustomType = this.metaAccess.lookupJavaType(customType);
            assert (!WordBase.class.isAssignableFrom(customType)) : "Custom type must not be a subtype of WordBase: field: " + String.valueOf(field) + " | declared type: " + String.valueOf(declaredType) + " | custom type: " + String.valueOf(customType);
            assert (declaredType.isAssignableFrom((ResolvedJavaType)aCustomType)) : "Custom type must be a subtype of the declared type: field: " + String.valueOf(field) + " | declared type: " + String.valueOf(declaredType) + " | custom type: " + String.valueOf(customType);
            assert (aCustomType.isPrimitive() || CustomTypeFieldHandler.isConcreteType(aCustomType)) : "Custom type cannot be abstract: field: " + String.valueOf(field) + " | custom type " + String.valueOf(aCustomType);
            customTypes.add(aCustomType);
        }
        return customTypes;
    }

    public static boolean isConcreteType(AnalysisType type) {
        return type.isArray() || type.isInstanceClass() && !type.isAbstract();
    }

    public void cleanupAfterAnalysis() {
        this.processedFields = null;
    }
}

