/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccessExtensionProvider;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.results.StrengthenGraphs;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.code.SubstrateMetaAccessExtensionProvider;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.monitor.MultiThreadedMonitorSupport;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.SubstrateStrengthenGraphs;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.analysis.flow.SVMMethodTypeFlowBuilder;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.config.HybridLayoutSupport;
import com.oracle.svm.hosted.image.LIRNativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageCodeCacheFactory;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.ObjectFileFactory;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionValues;
import jdk.internal.ValueBased;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;

public class HostedConfiguration {
    public static HostedConfiguration instance() {
        return (HostedConfiguration)ImageSingletons.lookup(HostedConfiguration.class);
    }

    public static void setInstanceIfEmpty(HostedConfiguration config) {
        if (!ImageSingletons.contains(HostedConfiguration.class)) {
            ImageSingletons.add(HostedConfiguration.class, (Object)config);
        }
    }

    public static void setDefaultIfEmpty() {
        HostedConfiguration.setInstanceIfEmpty(new HostedConfiguration());
        if (!ImageSingletons.contains(CompressEncoding.class)) {
            CompressEncoding compressEncoding = new CompressEncoding(SubstrateOptions.SpawnIsolates.getValue() != false ? 1L : 0L, 0);
            ImageSingletons.add(CompressEncoding.class, (Object)compressEncoding);
            ObjectLayout objectLayout = HostedConfiguration.createObjectLayout(ObjectLayout.IdentityHashMode.TYPE_SPECIFIC);
            ImageSingletons.add(ObjectLayout.class, (Object)objectLayout);
            ImageSingletons.add(HybridLayoutSupport.class, (Object)new HybridLayoutSupport());
        }
    }

    public static ObjectLayout createObjectLayout(ObjectLayout.IdentityHashMode identityHashMode) {
        return HostedConfiguration.createObjectLayout(JavaKind.Object, identityHashMode);
    }

    public static ObjectLayout createObjectLayout(JavaKind referenceKind, ObjectLayout.IdentityHashMode identityHashMode) {
        SubstrateTargetDescription target = ConfigurationValues.getTarget();
        int referenceSize = target.arch.getPlatformKind(referenceKind).getSizeInBytes();
        int intSize = target.arch.getPlatformKind(JavaKind.Int).getSizeInBytes();
        int objectAlignment = 8;
        int hubOffset = 0;
        int headerSize = hubOffset + referenceSize;
        int extraArrayHeaderSize = 0;
        int headerIdentityHashOffset = headerSize;
        if (identityHashMode == ObjectLayout.IdentityHashMode.OBJECT_HEADER) {
            headerSize += intSize;
        } else if (identityHashMode == ObjectLayout.IdentityHashMode.TYPE_SPECIFIC) {
            extraArrayHeaderSize = intSize;
        } else {
            assert (identityHashMode == ObjectLayout.IdentityHashMode.OPTIONAL);
            headerIdentityHashOffset = -1;
        }
        int firstFieldOffset = headerSize += SubstrateOptions.AdditionalHeaderBytes.getValue().intValue();
        int arrayLengthOffset = headerSize + extraArrayHeaderSize;
        int arrayBaseOffset = arrayLengthOffset + intSize;
        return new ObjectLayout(target, referenceSize, objectAlignment, hubOffset, firstFieldOffset, arrayLengthOffset, arrayBaseOffset, headerIdentityHashOffset, identityHashMode);
    }

    public SVMHost createHostVM(OptionValues options, ImageClassLoader loader, ClassInitializationSupport classInitializationSupport, AnnotationSubstitutionProcessor annotationSubstitutions) {
        return new SVMHost(options, loader, classInitializationSupport, annotationSubstitutions);
    }

    public CompileQueue createCompileQueue(DebugContext debug, FeatureHandler featureHandler, HostedUniverse hostedUniverse, RuntimeConfiguration runtimeConfiguration, boolean deoptimizeAll, SnippetReflectionProvider aSnippetReflection) {
        return new CompileQueue(debug, featureHandler, hostedUniverse, runtimeConfiguration, deoptimizeAll, aSnippetReflection);
    }

    public MethodTypeFlowBuilder createMethodTypeFlowBuilder(PointsToAnalysis bb, PointsToAnalysisMethod method, MethodFlowsGraph flowsGraph, MethodFlowsGraph.GraphKind graphKind) {
        return new SVMMethodTypeFlowBuilder(bb, method, flowsGraph, graphKind);
    }

    public void registerUsedElements(PointsToAnalysis bb, StructuredGraph graph) {
        SVMMethodTypeFlowBuilder.registerUsedElements(bb, graph);
    }

    public MetaAccessExtensionProvider createAnalysisMetaAccessExtensionProvider() {
        return new AnalysisMetaAccessExtensionProvider();
    }

    public MetaAccessExtensionProvider createCompilationMetaAccessExtensionProvider(MetaAccessProvider metaAccess) {
        return new SubstrateMetaAccessExtensionProvider();
    }

    public void findAllFieldsForLayout(HostedUniverse universe, HostedMetaAccess metaAccess, Map<AnalysisField, HostedField> universeFields, ArrayList<HostedField> rawFields, ArrayList<HostedField> allFields, HostedInstanceClass clazz) {
        for (ResolvedJavaField javaField : clazz.getWrapped().getInstanceFields(false)) {
            AnalysisField aField = (AnalysisField)javaField;
            HostedField hField = universe.lookup((JavaField)aField);
            if (!hField.getDeclaringClass().equals(clazz)) continue;
            if (HybridLayout.isHybridField(hField)) {
                allFields.add(hField);
                continue;
            }
            if (!hField.isAccessed()) continue;
            rawFields.add(hField);
            allFields.add(hField);
        }
    }

    public StrengthenGraphs createStrengthenGraphs(Inflation bb, HostedUniverse universe) {
        return new SubstrateStrengthenGraphs(bb, universe);
    }

    public void collectMonitorFieldInfo(BigBang bb, HostedUniverse hUniverse, Set<AnalysisType> immutableTypes) {
        for (AnalysisType type : HostedConfiguration.getForceMonitorSlotTypes(bb)) {
            assert (!immutableTypes.contains(type));
            HostedConfiguration.setMonitorField(hUniverse, type);
        }
        this.processedSynchronizedTypes(bb, hUniverse, immutableTypes);
    }

    private static Set<AnalysisType> getForceMonitorSlotTypes(BigBang bb) {
        HashSet<AnalysisType> forceMonitorTypes = new HashSet<AnalysisType>();
        for (Map.Entry<Class<?>, Boolean> entry : MultiThreadedMonitorSupport.FORCE_MONITOR_SLOT_TYPES.entrySet()) {
            Optional optionalType = bb.getMetaAccess().optionalLookupJavaType(entry.getKey());
            if (!optionalType.isPresent()) continue;
            AnalysisType aType = (AnalysisType)optionalType.get();
            forceMonitorTypes.add(aType);
            if (!entry.getValue().booleanValue()) continue;
            forceMonitorTypes.addAll(aType.getAllSubtypes());
        }
        return forceMonitorTypes;
    }

    protected void processedSynchronizedTypes(BigBang bb, HostedUniverse hUniverse, Set<AnalysisType> immutableTypes) {
        for (AnalysisType type : bb.getAllSynchronizedTypes()) {
            HostedConfiguration.maybeSetMonitorField(hUniverse, immutableTypes, type);
        }
    }

    protected static void maybeSetMonitorField(HostedUniverse hUniverse, Set<AnalysisType> immutableTypes, AnalysisType type) {
        if (!(type.isArray() || immutableTypes.contains(type) || type.isAnnotationPresent(ValueBased.class))) {
            HostedConfiguration.setMonitorField(hUniverse, type);
        }
    }

    private static void setMonitorField(HostedUniverse hUniverse, AnalysisType type) {
        HostedInstanceClass hostedInstanceClass = (HostedInstanceClass)hUniverse.lookup((JavaType)type);
        hostedInstanceClass.setNeedMonitorField();
    }

    public NativeImageCodeCacheFactory newCodeCacheFactory() {
        return new NativeImageCodeCacheFactory(this){

            @Override
            public NativeImageCodeCache newCodeCache(CompileQueue compileQueue, NativeImageHeap heap, Platform targetPlatform, Path tempDir) {
                return new LIRNativeImageCodeCache(compileQueue.getCompilationResults(), heap);
            }
        };
    }

    public ObjectFileFactory newObjectFileFactory() {
        return new ObjectFileFactory(this){

            @Override
            public ObjectFile newObjectFile(int pageSize, Path tempDir, BigBang bb) {
                return ObjectFile.getNativeObjectFile((int)pageSize);
            }
        };
    }
}

