/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.CPUFeatureAccessImpl;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import java.lang.reflect.AnnotatedElement;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import jdk.graal.compiler.debug.GraalError;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class CPUFeatureAccessFeatureBase {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected <T extends Enum<T>> void initializeCPUFeatureAccessData(Enum<T>[] allCPUFeatures, EnumSet<?> buildtimeCPUFeatures, Class<?> cpuFeatureStructClass, FeatureImpl.BeforeAnalysisAccessImpl access) {
        AnalysisMetaAccess metaAccess = access.getMetaAccess();
        NativeLibraries nativeLibraries = access.getNativeLibraries();
        AnalysisType invokeInterface = metaAccess.lookupJavaType(cpuFeatureStructClass);
        StructInfo cpuFeatureStructInfo = (StructInfo)nativeLibraries.findElementInfo((AnnotatedElement)invokeInterface);
        EconomicMap fieldToOffset = EconomicMap.create();
        for (ElementInfo entry : cpuFeatureStructInfo.getChildren()) {
            if (!(entry instanceof StructFieldInfo)) continue;
            StructFieldInfo field = (StructFieldInfo)entry;
            String fieldName = field.getName();
            int offset = field.getOffsetInfo().getProperty();
            int size = field.getSizeInfo().getProperty();
            GraalError.guarantee((size == 1 ? 1 : 0) != 0, (String)"Expected field %s to be byte sized, but was %s", (Object)field.getName(), (Object)size);
            GraalError.guarantee((boolean)fieldName.startsWith("f"), (String)"Unexpected field name in %s: %s", (Object)cpuFeatureStructClass.getName(), (Object)fieldName);
            fieldToOffset.put((Object)fieldName.substring(1), (Object)offset);
        }
        int structSize = (cpuFeatureStructInfo.getSizeInfo().getProperty() + 8 - 1) / 8 * 8;
        byte[] requiredFeaturesStruct = new byte[structSize];
        Arrays.fill(requiredFeaturesStruct, (byte)-1);
        ByteBuffer requiredFeaturesStructData = ByteBuffer.wrap(requiredFeaturesStruct);
        int[] cpuFeatureEnumToStructOffset = new int[allCPUFeatures.length];
        Arrays.fill(cpuFeatureEnumToStructOffset, -1);
        ArrayList<String> unknownFeatures = new ArrayList<String>();
        for (Enum<T> feature : allCPUFeatures) {
            int fieldOffset = (Integer)fieldToOffset.get((Object)feature.name(), (Object)-1);
            if (fieldOffset < 0) {
                unknownFeatures.add(feature.name());
                continue;
            }
            cpuFeatureEnumToStructOffset[feature.ordinal()] = fieldOffset;
            if (!buildtimeCPUFeatures.contains(feature)) continue;
            requiredFeaturesStructData.put(fieldOffset, (byte)-2);
        }
        if (!unknownFeatures.isEmpty()) {
            throw VMError.shouldNotReachHere("The image does not support the following JVMCI CPU features: " + String.valueOf(unknownFeatures));
        }
        String errorMessage = "The current machine does not support all of the following CPU features that are required by the image: " + buildtimeCPUFeatures.toString() + "." + System.lineSeparator() + "Please rebuild the executable with an appropriate setting of the -march option.\u0000";
        CPUFeatureAccessImpl cpuFeatureAccess = this.createCPUFeatureAccessSingleton(buildtimeCPUFeatures, cpuFeatureEnumToStructOffset, errorMessage.getBytes(StandardCharsets.UTF_8), requiredFeaturesStruct);
        ImageSingletons.add(CPUFeatureAccess.class, (Object)cpuFeatureAccess);
    }

    protected abstract CPUFeatureAccessImpl createCPUFeatureAccessSingleton(EnumSet<?> var1, int[] var2, byte[] var3, byte[] var4);
}

