/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.code.AbstractRuntimeCodeInstaller;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.DeoptimizationSourcePositionEncoder;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.code.InstalledCodeObserver;
import com.oracle.svm.core.code.InstalledCodeObserverSupport;
import com.oracle.svm.core.code.InstantReferenceAdjuster;
import com.oracle.svm.core.code.ReferenceAdjuster;
import com.oracle.svm.core.code.RuntimeCodeCache;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.graal.code.NativeImagePatcher;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateCompilationResult;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.heap.CodeReferenceMapEncoder;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.type.CompressibleConstant;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class RuntimeCodeInstaller
extends AbstractRuntimeCodeInstaller {
    protected final SharedRuntimeMethod method;
    private final int tier;
    private SubstrateCompilationResult compilation;
    private final DebugContext debug;
    private Pointer code;
    private int codeSize;
    private int dataOffset;
    private int dataSize;
    private int codeAndDataMemorySize;
    private InstalledCodeObserver[] codeObservers;
    protected byte[] compiledBytes;

    public static void install(SharedRuntimeMethod method, CompilationResult compilation, SubstrateInstalledCode installedCode) {
        new RuntimeCodeInstaller(method, compilation).doInstall(installedCode);
    }

    protected RuntimeCodeInstaller(SharedRuntimeMethod method, CompilationResult compilation) {
        this.method = method;
        this.compilation = (SubstrateCompilationResult)compilation;
        this.tier = compilation.getName().endsWith("#1") ? 1 : 2;
        this.debug = new DebugContext.Builder((OptionValues)RuntimeOptionValues.singleton()).build();
    }

    private void prepareCodeMemory() {
        try (Indent indent = this.debug.logAndIndent("create installed code of %s.%s", (Object)this.method.getDeclaringClass().getName(), (Object)this.method.getName());){
            SubstrateTargetDescription target = ConfigurationValues.getTarget();
            if (target.arch.getPlatformKind(JavaKind.Object).getSizeInBytes() != 8) {
                throw VMError.shouldNotReachHere("wrong object size");
            }
            this.codeSize = this.compilation.getTargetCodeSize();
            this.dataSize = this.compilation.getDataSection().getSectionSize();
            this.dataOffset = NumUtil.roundUp((int)this.codeSize, (int)this.compilation.getDataSection().getSectionAlignment());
            if (!RuntimeCodeCache.Options.WriteableCodeCache.getValue().booleanValue()) {
                this.dataOffset = UnsignedUtils.safeToInt(UnsignedUtils.roundUp(WordFactory.unsigned((int)this.dataOffset), CommittedMemoryProvider.get().getGranularity()));
            }
            this.codeAndDataMemorySize = UnsignedUtils.safeToInt(UnsignedUtils.roundUp(WordFactory.unsigned((int)(this.dataOffset + this.dataSize)), CommittedMemoryProvider.get().getGranularity()));
            this.code = this.allocateCodeMemory(this.codeAndDataMemorySize);
            this.compiledBytes = this.compilation.getTargetCode();
            if (RuntimeCodeCache.Options.WriteableCodeCache.getValue().booleanValue()) {
                UnsignedWord alignedAfterCodeOffset = UnsignedUtils.roundUp(WordFactory.unsigned((int)this.codeSize), CommittedMemoryProvider.get().getGranularity());
                assert (alignedAfterCodeOffset.belowOrEqual(this.codeAndDataMemorySize));
                this.makeCodeMemoryExecutableWritable(this.code, alignedAfterCodeOffset);
            }
            this.codeObservers = ((InstalledCodeObserverSupport)ImageSingletons.lookup(InstalledCodeObserverSupport.class)).createObservers(this.debug, this.method, this.compilation, this.code, this.codeSize);
        }
    }

    private void doInstall(SubstrateInstalledCode installedCode) {
        InstantReferenceAdjuster adjuster = new InstantReferenceAdjuster();
        CodeInfo codeInfo = RuntimeCodeInfoAccess.allocateMethodInfo();
        this.doPrepareInstall(adjuster, codeInfo);
        RuntimeCodeInstaller.doInstallPrepared(this.method, codeInfo, installedCode);
    }

    protected void doPrepareInstall(ReferenceAdjuster adjuster, CodeInfo codeInfo) {
        for (Infopoint infopoint : this.compilation.getInfopoints()) {
            VMError.guarantee(!(infopoint instanceof Call) || !((Call)infopoint).direct, "No direct calls permitted: patching of runtime-compiled code intentionally not supported");
        }
        this.prepareCodeMemory();
        ObjectConstantsHolder objectConstants = new ObjectConstantsHolder(this.compilation);
        HashMap<Integer, NativeImagePatcher> patches = new HashMap<Integer, NativeImagePatcher>();
        for (CompilationResult.CodeAnnotation codeAnnotation : this.compilation.getCodeAnnotations()) {
            if (!(codeAnnotation instanceof NativeImagePatcher)) continue;
            NativeImagePatcher priorValue = patches.put(codeAnnotation.getPosition(), (NativeImagePatcher)codeAnnotation);
            VMError.guarantee(priorValue == null, "Registering two patchers for same position.");
        }
        int numPatchesHandled = this.patchData(patches, objectConstants);
        VMError.guarantee(numPatchesHandled == patches.size(), "Not all patches applied.");
        for (int index = 0; index < this.codeSize; ++index) {
            this.code.writeByte(index, this.compiledBytes[index]);
        }
        if (!RuntimeCodeCache.Options.WriteableCodeCache.getValue().booleanValue()) {
            this.makeCodeMemoryExecutableReadOnly(this.code, WordFactory.unsigned((int)this.codeSize));
        }
        ByteBuffer dataBuffer = CTypeConversion.asByteBuffer((PointerBase)this.code.add(this.dataOffset), (int)this.compilation.getDataSection().getSectionSize());
        this.compilation.getDataSection().buildDataSection(dataBuffer, (position, constant) -> objectConstants.add(this.dataOffset + position, ConfigurationValues.getObjectLayout().getReferenceSize(), (SubstrateObjectConstant)constant));
        int entryPointOffset = 0;
        for (CompilationResult.CodeMark mark : this.compilation.getMarks()) {
            if (mark.id != SubstrateBackend.SubstrateMarkId.PROLOGUE_START) continue;
            assert (entryPointOffset == 0);
            entryPointOffset = mark.pcOffset;
        }
        NonmovableArray<InstalledCodeObserver.InstalledCodeObserverHandle> observerHandles = InstalledCodeObserverSupport.installObservers(this.codeObservers);
        RuntimeCodeInfoAccess.initialize(codeInfo, this.code, entryPointOffset, this.codeSize, this.dataOffset, this.dataSize, this.codeAndDataMemorySize, this.tier, observerHandles, false);
        CodeReferenceMapEncoder encoder = new CodeReferenceMapEncoder();
        encoder.add(objectConstants.referenceMap);
        RuntimeCodeInfoAccess.setCodeObjectConstantsInfo(codeInfo, encoder.encodeAll(), encoder.lookupEncoding(objectConstants.referenceMap));
        ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).addToReferenceMapSize(encoder.getEncodingSize());
        this.patchDirectObjectConstants(objectConstants, codeInfo, adjuster);
        this.createCodeChunkInfos(codeInfo, adjuster);
        this.compilation = null;
    }

    @Uninterruptible(reason="Must be atomic with regard to garbage collection.")
    private void patchDirectObjectConstants(ObjectConstantsHolder objectConstants, CodeInfo runtimeMethodInfo, ReferenceAdjuster adjuster) {
        for (int i = 0; i < objectConstants.count; ++i) {
            JavaConstant constant = objectConstants.constants[i];
            adjuster.setConstantTargetAt((PointerBase)this.code.add(objectConstants.offsets[i]), objectConstants.lengths[i], constant);
        }
        CodeInfoAccess.setState(runtimeMethodInfo, 1);
        if (!SubstrateUtil.HOSTED) {
            Heap.getHeap().getRuntimeCodeInfoGCSupport().registerCodeConstants(runtimeMethodInfo);
        }
    }

    private void createCodeChunkInfos(CodeInfo runtimeMethodInfo, ReferenceAdjuster adjuster) {
        CodeInfoEncoder codeInfoEncoder = new CodeInfoEncoder(new RuntimeFrameInfoCustomization(), new CodeInfoEncoder.Encoders());
        codeInfoEncoder.addMethod(this.method, this.compilation, 0, this.compilation.getTargetCodeSize());
        codeInfoEncoder.encodeAllAndInstall(runtimeMethodInfo, adjuster);
        assert (!adjuster.isFinished() || CodeInfoEncoder.verifyMethod(this.method, this.compilation, 0, this.compilation.getTargetCodeSize(), runtimeMethodInfo, FrameInfoDecoder.SubstrateConstantAccess));
        assert (!adjuster.isFinished() || codeInfoEncoder.verifyFrameInfo(runtimeMethodInfo));
        DeoptimizationSourcePositionEncoder sourcePositionEncoder = new DeoptimizationSourcePositionEncoder();
        sourcePositionEncoder.encodeAndInstall(this.compilation.getDeoptimizationSourcePositions(), runtimeMethodInfo, adjuster);
    }

    private int patchData(Map<Integer, NativeImagePatcher> patcher, ObjectConstantsHolder objectConstants) {
        int patchesHandled = 0;
        HashSet<Integer> patchedOffsets = new HashSet<Integer>();
        for (DataPatch dataPatch : this.compilation.getDataPatches()) {
            DataSectionReference ref;
            NativeImagePatcher patch = patcher.get(dataPatch.pcOffset);
            boolean noPriorMatch = patchedOffsets.add(dataPatch.pcOffset);
            VMError.guarantee(noPriorMatch, "Patching same offset twice.");
            ++patchesHandled;
            if (dataPatch.reference instanceof DataSectionReference) {
                ref = (DataSectionReference)dataPatch.reference;
                int pcDisplacement = this.dataOffset + ref.getOffset() - dataPatch.pcOffset;
                patch.patchCode(this.code.rawValue(), pcDisplacement, this.compiledBytes);
                continue;
            }
            if (dataPatch.reference instanceof ConstantReference) {
                ref = (ConstantReference)dataPatch.reference;
                SubstrateObjectConstant refConst = (SubstrateObjectConstant)ref.getConstant();
                objectConstants.add(patch.getOffset(), patch.getLength(), refConst);
                continue;
            }
            throw VMError.shouldNotReachHere("Unhandled data patch.");
        }
        return patchesHandled;
    }

    private static class ObjectConstantsHolder {
        final SubstrateReferenceMap referenceMap;
        final int[] offsets;
        final int[] lengths;
        final JavaConstant[] constants;
        int count;

        ObjectConstantsHolder(CompilationResult compilation) {
            int maxDataRefs = compilation.getDataSection().getSectionSize() / ConfigurationValues.getObjectLayout().getReferenceSize();
            int maxCodeRefs = compilation.getDataPatches().size();
            int maxTotalRefs = maxDataRefs + maxCodeRefs;
            this.offsets = new int[maxTotalRefs];
            this.lengths = new int[maxTotalRefs];
            this.constants = new JavaConstant[maxTotalRefs];
            this.referenceMap = new SubstrateReferenceMap();
        }

        void add(int offset, int length, JavaConstant constant) {
            assert (((CompressibleConstant)constant).isCompressed() == ReferenceAccess.singleton().haveCompressedReferences()) : "Object reference constants in code must be compressed";
            this.offsets[this.count] = offset;
            this.lengths[this.count] = length;
            this.constants[this.count] = constant;
            this.referenceMap.markReferenceAtOffset(offset, true);
            ++this.count;
        }
    }

    private static class RuntimeFrameInfoCustomization
    extends FrameInfoEncoder.SourceFieldsFromImage {
        private RuntimeFrameInfoCustomization() {
        }

        @Override
        protected boolean storeDeoptTargetMethod() {
            return true;
        }

        @Override
        protected boolean includeLocalValues(ResolvedJavaMethod method, Infopoint infopoint, boolean isDeoptEntry) {
            return true;
        }

        @Override
        protected boolean isDeoptEntry(ResolvedJavaMethod method, CompilationResult compilation, Infopoint infopoint) {
            return false;
        }
    }
}

