/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.AnnotateOriginal;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK21OrEarlier;
import com.oracle.svm.core.jdk.JDK22OrLater;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_ContinuationScope;
import com.oracle.svm.core.thread.Target_sun_nio_ch_Interruptible;
import com.oracle.svm.core.thread.VirtualThreadHelper;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

@TargetClass(className="java.lang.VirtualThread")
public final class Target_java_lang_VirtualThread {
    @Alias
    static int NEW;
    @Alias
    static int STARTED;
    @Alias
    @TargetElement(onlyWith={JDK21OrEarlier.class})
    static int RUNNABLE;
    @Alias
    static int RUNNING;
    @Alias
    static int PARKING;
    @Alias
    static int PARKED;
    @Alias
    static int PINNED;
    @Alias
    static int YIELDING;
    @TargetElement(onlyWith={JDK22OrLater.class})
    @Alias
    static int YIELDED;
    @Alias
    static int TERMINATED;
    @Alias
    static int SUSPENDED;
    @TargetElement(onlyWith={JDK22OrLater.class})
    @Alias
    static int TIMED_PARKING;
    @TargetElement(onlyWith={JDK22OrLater.class})
    @Alias
    static int TIMED_PARKED;
    @TargetElement(onlyWith={JDK22OrLater.class})
    @Alias
    static int TIMED_PINNED;
    @TargetElement(onlyWith={JDK22OrLater.class})
    @Alias
    static int UNPARKED;
    @Alias
    static Target_jdk_internal_vm_ContinuationScope VTHREAD_SCOPE;
    @Alias
    @InjectAccessors(value=DefaultSchedulerAccessor.class)
    public static ForkJoinPool DEFAULT_SCHEDULER;
    @Alias
    @InjectAccessors(value=UnparkerAccessor.class)
    private static ScheduledExecutorService UNPARKER;
    @Alias
    @InjectAccessors(value=SchedulerAccessor.class)
    public Executor scheduler;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=NondefaultSchedulerSupplier.class)
    private Executor nondefaultScheduler;
    @Alias
    volatile Thread carrierThread;
    @Alias
    volatile Target_sun_nio_ch_Interruptible nioBlocker;
    @Alias
    volatile boolean interrupted;

    @Alias
    private static native ForkJoinPool createDefaultScheduler();

    @Alias
    private static native ScheduledExecutorService createDelayedTaskScheduler();

    @Substitute
    private static void registerNatives() {
    }

    @Substitute
    private void notifyJvmtiStart() {
    }

    @Substitute
    private void notifyJvmtiEnd() {
    }

    @Substitute
    private void notifyJvmtiMount(boolean hide) {
    }

    @Substitute
    private void notifyJvmtiUnmount(boolean hide) {
    }

    @Substitute
    private void notifyJvmtiHideFrames(boolean hide) {
    }

    @Substitute
    @TargetElement(onlyWith={JDK22OrLater.class})
    private void notifyJvmtiDisableSuspend(boolean enter) {
    }

    @Alias
    public static native Target_jdk_internal_vm_ContinuationScope continuationScope();

    @Delete
    native StackTraceElement[] asyncGetStackTrace();

    @Alias
    native StackTraceElement[] tryGetStackTrace();

    @Substitute
    boolean getAndClearInterrupt() {
        assert (Thread.currentThread() == SubstrateUtil.cast(this, Object.class));
        boolean oldValue = this.interrupted;
        if (oldValue) {
            Object token = VirtualThreadHelper.acquireInterruptLockMaybeSwitch(this);
            try {
                this.interrupted = false;
                VirtualThreadHelper.asTarget(this.carrierThread).clearInterrupt();
            }
            finally {
                VirtualThreadHelper.releaseInterruptLockMaybeSwitchBack(this, token);
            }
        }
        return oldValue;
    }

    @Alias
    private native void setCarrierThread(Target_java_lang_Thread var1);

    @Substitute
    void mount() {
        Target_java_lang_Thread carrier = VirtualThreadHelper.asTarget(Target_java_lang_Thread.currentCarrierThread());
        this.setCarrierThread(carrier);
        if (this.interrupted) {
            carrier.setInterrupt();
        } else if (carrier.isInterrupted()) {
            Object token = VirtualThreadHelper.acquireInterruptLockMaybeSwitch(this);
            try {
                if (!this.interrupted) {
                    carrier.clearInterrupt();
                }
            }
            finally {
                VirtualThreadHelper.releaseInterruptLockMaybeSwitchBack(this, token);
            }
        }
        carrier.setCurrentThread(VirtualThreadHelper.asThread(this));
        if (HasJfrSupport.get()) {
            SubstrateJVM.getThreadRepo().registerThread(VirtualThreadHelper.asThread(this));
        }
    }

    @Substitute
    void unmount() {
        Target_java_lang_Thread carrier = VirtualThreadHelper.asTarget(this.carrierThread);
        carrier.setCurrentThread(VirtualThreadHelper.asThread(carrier));
        Object token = VirtualThreadHelper.acquireInterruptLockMaybeSwitch(this);
        try {
            this.setCarrierThread(null);
        }
        finally {
            VirtualThreadHelper.releaseInterruptLockMaybeSwitchBack(this, token);
        }
        carrier.clearInterrupt();
    }

    @Alias
    native int state();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    Thread.State threadState() {
        int state = this.state() & ~SUSPENDED;
        if (state == NEW) {
            return Thread.State.NEW;
        }
        if (state == STARTED) {
            if (VirtualThreadHelper.asTarget(this).threadContainer() == null) {
                return Thread.State.NEW;
            }
            return Thread.State.RUNNABLE;
        }
        if (JavaVersionUtil.JAVA_SPEC < 22 && state == RUNNABLE) {
            return Thread.State.RUNNABLE;
        }
        if (JavaVersionUtil.JAVA_SPEC >= 22 && (state == UNPARKED || state == YIELDED)) {
            return Thread.State.RUNNABLE;
        }
        if (state == RUNNING) {
            Object token = VirtualThreadHelper.acquireInterruptLockMaybeSwitch(this);
            try {
                Thread carrier = this.carrierThread;
                if (carrier != null) {
                    Thread.State state2 = VirtualThreadHelper.asTarget(carrier).threadState();
                    return state2;
                }
            }
            finally {
                VirtualThreadHelper.releaseInterruptLockMaybeSwitchBack(this, token);
            }
            return Thread.State.RUNNABLE;
        }
        if (state == PARKING || state == YIELDING) {
            return Thread.State.RUNNABLE;
        }
        if (state == PARKED || state == PINNED) {
            int parkedThreadStatus = MonitorSupport.singleton().getParkedThreadStatus(VirtualThreadHelper.asThread(this), false);
            switch (parkedThreadStatus) {
                case 1025: {
                    return Thread.State.BLOCKED;
                }
                case 401: 
                case 657: {
                    return Thread.State.WAITING;
                }
            }
            throw VMError.shouldNotReachHereUnexpectedInput(parkedThreadStatus);
        }
        if (state == TERMINATED) {
            return Thread.State.TERMINATED;
        }
        if (JavaVersionUtil.JAVA_SPEC >= 22) {
            if (state == TIMED_PARKING) {
                return Thread.State.RUNNABLE;
            }
            if (state == TIMED_PARKED || state == TIMED_PINNED) {
                return Thread.State.TIMED_WAITING;
            }
        }
        throw new InternalError();
    }

    @AnnotateOriginal
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    native boolean isTerminated();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    public String toString() {
        StringBuilder sb = new StringBuilder("VirtualThread[#");
        sb.append(VirtualThreadHelper.asTarget(this).threadId());
        String name = VirtualThreadHelper.asThread(this).getName();
        if (!name.isEmpty()) {
            sb.append(",");
            sb.append(name);
        }
        sb.append("]/");
        Thread carrier = this.carrierThread;
        if (carrier != null) {
            Object token = VirtualThreadHelper.acquireInterruptLockMaybeSwitch(this);
            try {
                carrier = this.carrierThread;
                if (carrier != null) {
                    String stateAsString = VirtualThreadHelper.asTarget(carrier).threadState().toString();
                    sb.append(stateAsString.toLowerCase(Locale.ROOT));
                    sb.append('@');
                    sb.append(carrier.getName());
                }
            }
            finally {
                VirtualThreadHelper.releaseInterruptLockMaybeSwitchBack(this, token);
            }
        }
        if (carrier == null) {
            String stateAsString = this.threadState().toString();
            sb.append(stateAsString.toLowerCase(Locale.ROOT));
        }
        return sb.toString();
    }

    @Alias
    native void interrupt();

    @Alias
    native void unpark();

    private static final class NondefaultSchedulerSupplier
    implements FieldValueTransformer {
        private NondefaultSchedulerSupplier() {
        }

        public Object transform(Object receiver, Object originalValue) {
            Class vthreadClass = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.VirtualThread");
            Object defaultScheduler = ReflectionUtil.readStaticField((Class)vthreadClass, (String)"DEFAULT_SCHEDULER");
            return originalValue == defaultScheduler ? null : originalValue;
        }
    }

    private static final class SchedulerAccessor {
        private SchedulerAccessor() {
        }

        static Executor get(Target_java_lang_VirtualThread self) {
            Executor scheduler = self.nondefaultScheduler;
            if (scheduler == null) {
                scheduler = DefaultSchedulerAccessor.get();
            }
            return scheduler;
        }

        static void set(Target_java_lang_VirtualThread self, Executor executor) {
            assert (self.nondefaultScheduler == null);
            if (executor != DefaultSchedulerAccessor.get()) {
                self.nondefaultScheduler = executor;
            }
        }
    }

    private static final class UnparkerAccessor {
        private static volatile ScheduledExecutorService delayedTaskScheduler;

        private UnparkerAccessor() {
        }

        public static ScheduledExecutorService get() {
            ScheduledExecutorService result = delayedTaskScheduler;
            if (result == null) {
                result = UnparkerAccessor.initializeDelayedTaskScheduler();
            }
            return result;
        }

        private static synchronized ScheduledExecutorService initializeDelayedTaskScheduler() {
            ScheduledExecutorService result = delayedTaskScheduler;
            if (result == null) {
                delayedTaskScheduler = result = Target_java_lang_VirtualThread.createDelayedTaskScheduler();
            }
            return result;
        }
    }

    private static final class DefaultSchedulerAccessor {
        private static volatile ForkJoinPool defaultScheduler;

        private DefaultSchedulerAccessor() {
        }

        public static ForkJoinPool get() {
            ForkJoinPool result = defaultScheduler;
            if (result == null) {
                result = DefaultSchedulerAccessor.initializeDefaultScheduler();
            }
            return result;
        }

        private static synchronized ForkJoinPool initializeDefaultScheduler() {
            ForkJoinPool result = defaultScheduler;
            if (result == null) {
                defaultScheduler = result = Target_java_lang_VirtualThread.createDefaultScheduler();
            }
            return result;
        }
    }
}

