/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.pthread;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMLockSupport;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.locks.VMSemaphore;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.PosixVMSemaphoreSupport;
import com.oracle.svm.core.posix.pthread.PthreadVMCondition;
import com.oracle.svm.core.posix.pthread.PthreadVMMutex;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.VMThreads;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;

public final class PthreadVMLockSupport
extends VMLockSupport {
    @UnknownObjectField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    PthreadVMMutex[] mutexes;
    @UnknownObjectField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    PthreadVMCondition[] conditions;

    @Fold
    public static PthreadVMLockSupport singleton() {
        return (PthreadVMLockSupport)ImageSingletons.lookup(VMLockSupport.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void checkResult(int result, String functionName) {
        if (result != 0) {
            PthreadVMLockSupport.fatalError(result, functionName);
        }
    }

    @Uninterruptible(reason="Error handling is interruptible.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in fatal error handling.")
    private static void fatalError(int result, String functionName) {
        VMThreads.SafepointBehavior.preventSafepoints();
        StackOverflowCheck.singleton().disableStackOverflowChecksForFatalError();
        Log.log().string(functionName).string(" returned ").signed(result).newline();
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public VMMutex[] getMutexes() {
        return this.mutexes;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public VMCondition[] getConditions() {
        return this.conditions;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public VMSemaphore[] getSemaphores() {
        return PosixVMSemaphoreSupport.singleton().getSemaphores();
    }
}

