/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.VMError;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={PhysicalMemory.PhysicalMemorySupport.class})
class LinuxPhysicalMemorySupportImpl
implements PhysicalMemory.PhysicalMemorySupport {
    LinuxPhysicalMemorySupportImpl() {
    }

    @Override
    public UnsignedWord size() {
        long numberOfPhysicalMemoryPages = Unistd.sysconf(Unistd._SC_PHYS_PAGES());
        long sizeOfAPhysicalMemoryPage = Unistd.sysconf(Unistd._SC_PAGESIZE());
        if (numberOfPhysicalMemoryPages == -1L || sizeOfAPhysicalMemoryPage == -1L) {
            throw VMError.shouldNotReachHere("Physical memory size (number of pages or page size) not available");
        }
        return WordFactory.unsigned((long)numberOfPhysicalMemoryPages).multiply(WordFactory.unsigned((long)sizeOfAPhysicalMemoryPage));
    }
}

