/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.option.OptionOrigin;
import java.util.Map;
import java.util.Set;

public class OptionClassFilter {
    private final Set<OptionOrigin> reasonCommandLine = Set.of(OptionOrigin.commandLineAPIOptionOriginSingleton, OptionOrigin.commandLineNonAPIOptionOriginSingleton);
    private final Map<String, Set<OptionOrigin>> requireCompletePackageOrClass;
    private final Set<Module> requireCompleteModules;
    private boolean requireCompleteAll;

    public OptionClassFilter(Map<String, Set<OptionOrigin>> requireCompletePackageOrClass, Set<Module> requireCompleteModules, boolean requireCompleteAll) {
        this.requireCompletePackageOrClass = requireCompletePackageOrClass;
        this.requireCompleteModules = requireCompleteModules;
        this.requireCompleteAll = requireCompleteAll;
    }

    public Object isIncluded(Class<?> clazz) {
        Module module = clazz.getModule();
        return this.isIncluded(module.isNamed() ? module.getName() : null, clazz.getPackageName(), clazz.getName());
    }

    public Object isIncluded(String moduleName, String packageName, String className) {
        String module;
        if (this.requireCompleteAll) {
            return this.reasonCommandLine;
        }
        if (moduleName != null && (module = this.isModuleIncluded(moduleName)) != null) {
            return module;
        }
        Set<OptionOrigin> origins = this.isPackageOrClassIncluded(className);
        if (origins != null) {
            return origins;
        }
        return this.isPackageOrClassIncluded(packageName);
    }

    public Set<OptionOrigin> isPackageOrClassIncluded(String packageName) {
        if (this.requireCompleteAll) {
            return this.reasonCommandLine;
        }
        return this.requireCompletePackageOrClass.get(packageName);
    }

    public String isModuleIncluded(String moduleName) {
        for (Module module : this.requireCompleteModules) {
            if (!module.getName().equals(moduleName)) continue;
            return module.toString();
        }
        return null;
    }

    public void addPackageOrClass(String packageOrClass, Set<OptionOrigin> reason) {
        this.requireCompletePackageOrClass.put(packageOrClass, reason);
    }
}

