/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrBufferType;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrRepository;
import com.oracle.svm.core.jfr.JfrType;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.traceid.JfrTraceIdEpoch;
import com.oracle.svm.core.jfr.utils.JfrVisited;
import com.oracle.svm.core.jfr.utils.JfrVisitedTable;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.thread.JavaLangThreadGroupSubstitutions;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.WordFactory;

public final class JfrThreadRepository
implements JfrRepository {
    public static final int VIRTUAL_THREAD_GROUP_ID = 1;
    private final VMMutex mutex = new VMMutex("jfrThreadRepository");
    private final JfrThreadEpochData epochData0 = new JfrThreadEpochData();
    private final JfrThreadEpochData epochData1 = new JfrThreadEpochData();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    JfrThreadRepository() {
    }

    public void teardown() {
        this.epochData0.teardown();
        this.epochData1.teardown();
    }

    @Uninterruptible(reason="Required to get epoch data.")
    public void clearPreviousEpoch() {
        assert (VMOperation.isInProgressAtSafepoint() && SubstrateJVM.getChunkWriter().isLockedByCurrentThread());
        this.getEpochData(true).clear(false);
    }

    @Uninterruptible(reason="Prevent any JFR events from triggering.")
    public void registerRunningThreads() {
        assert (VMOperation.isInProgressAtSafepoint());
        assert (SubstrateJVM.get().isRecording());
        IsolateThread isolateThread = VMThreads.firstThread();
        while (isolateThread.isNonNull()) {
            Thread thread = PlatformThreads.fromVMThread(isolateThread);
            if (thread != null) {
                this.registerThread(thread);
                Thread vthread = PlatformThreads.getMountedVirtualThread(thread);
                if (vthread != null) {
                    this.registerThread(vthread);
                }
            }
            isolateThread = VMThreads.nextThread(isolateThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public void registerThread(Thread thread) {
        if (!SubstrateJVM.get().isRecording()) {
            return;
        }
        long threadId = JavaThreads.getThreadId(thread);
        JfrVisited visitedThread = (JfrVisited)StackValue.get(JfrVisited.class);
        visitedThread.setId(threadId);
        visitedThread.setHash(UninterruptibleUtils.Long.hashCode(threadId));
        this.mutex.lockNoTransition();
        try {
            JfrThreadEpochData epochData = this.getEpochData(false);
            if (!epochData.threadTable.putIfAbsent(visitedThread)) {
                return;
            }
            if (epochData.threadBuffer.isNull()) {
                epochData.threadBuffer = JfrBufferAccess.allocate(JfrBufferType.C_HEAP);
            }
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initialize(data, epochData.threadBuffer);
            boolean isVirtual = JavaThreads.isVirtual(thread);
            long osThreadId = isVirtual ? 0L : threadId;
            long threadGroupId = this.registerThreadGroup(thread, isVirtual);
            JfrNativeEventWriter.putLong(data, threadId);
            JfrNativeEventWriter.putString(data, thread.getName());
            JfrNativeEventWriter.putLong(data, osThreadId);
            JfrNativeEventWriter.putString(data, thread.getName());
            JfrNativeEventWriter.putLong(data, threadId);
            JfrNativeEventWriter.putLong(data, threadGroupId);
            JfrNativeEventWriter.putBoolean(data, isVirtual);
            if (!JfrNativeEventWriter.commit(data)) {
                return;
            }
            ++epochData.unflushedThreadCount;
            epochData.threadBuffer = data.getJfrBuffer();
        }
        finally {
            this.mutex.unlock();
        }
    }

    @Uninterruptible(reason="Epoch must not change while in this method.")
    private long registerThreadGroup(Thread thread, boolean isVirtual) {
        if (isVirtual) {
            return 1L;
        }
        ThreadGroup group = JavaThreads.getRawThreadGroup(thread);
        return this.registerThreadGroup0(group);
    }

    @Uninterruptible(reason="Epoch must not change while in this method.")
    private long registerThreadGroup0(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            return 0L;
        }
        long threadGroupId = JavaLangThreadGroupSubstitutions.getThreadGroupId(threadGroup);
        JfrVisited jfrVisited = (JfrVisited)StackValue.get(JfrVisited.class);
        jfrVisited.setId(threadGroupId);
        jfrVisited.setHash(UninterruptibleUtils.Long.hashCode(threadGroupId));
        JfrThreadEpochData epochData = this.getEpochData(false);
        if (!epochData.threadGroupTable.putIfAbsent(jfrVisited)) {
            return threadGroupId;
        }
        if (epochData.threadGroupBuffer.isNull()) {
            epochData.threadGroupBuffer = JfrBufferAccess.allocate(JfrBufferType.C_HEAP);
        }
        ThreadGroup parentThreadGroup = JavaLangThreadGroupSubstitutions.getParentThreadGroupUnsafe(threadGroup);
        long parentThreadGroupId = this.registerThreadGroup0(parentThreadGroup);
        JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
        JfrNativeEventWriterDataAccess.initialize(data, epochData.threadGroupBuffer);
        JfrNativeEventWriter.putLong(data, threadGroupId);
        JfrNativeEventWriter.putLong(data, parentThreadGroupId);
        JfrNativeEventWriter.putString(data, threadGroup.getName());
        if (!JfrNativeEventWriter.commit(data)) {
            return threadGroupId;
        }
        ++epochData.unflushedThreadGroupCount;
        epochData.threadGroupBuffer = data.getJfrBuffer();
        return threadGroupId;
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public boolean hasUnflushedData() {
        this.mutex.lockNoTransition();
        try {
            JfrThreadEpochData epochData = this.getEpochData(false);
            boolean bl = epochData.unflushedThreadCount > 0 || epochData.unflushedThreadGroupCount > 0;
            return bl;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public int write(JfrChunkWriter writer, boolean flushpoint) {
        this.mutex.lockNoTransition();
        try {
            JfrThreadEpochData epochData = this.getEpochData(!flushpoint);
            int count = JfrThreadRepository.writeThreads(writer, epochData);
            epochData.clear(flushpoint);
            int n = count += JfrThreadRepository.writeThreadGroups(writer, epochData);
            return n;
        }
        finally {
            this.mutex.unlock();
        }
    }

    @Uninterruptible(reason="May write current epoch data.")
    private static int writeThreads(JfrChunkWriter writer, JfrThreadEpochData epochData) {
        int threadCount = epochData.unflushedThreadCount;
        if (threadCount == 0) {
            return 0;
        }
        writer.writeCompressedLong(JfrType.Thread.getId());
        writer.writeCompressedInt(epochData.unflushedThreadCount);
        writer.write(epochData.threadBuffer);
        JfrBufferAccess.reinitialize(epochData.threadBuffer);
        epochData.unflushedThreadCount = 0;
        return 1;
    }

    @Uninterruptible(reason="May write current epoch data.")
    private static int writeThreadGroups(JfrChunkWriter writer, JfrThreadEpochData epochData) {
        int threadGroupCount = epochData.unflushedThreadGroupCount;
        if (threadGroupCount == 0) {
            return 0;
        }
        writer.writeCompressedLong(JfrType.ThreadGroup.getId());
        writer.writeCompressedInt(threadGroupCount);
        writer.write(epochData.threadGroupBuffer);
        JfrBufferAccess.reinitialize(epochData.threadGroupBuffer);
        epochData.unflushedThreadGroupCount = 0;
        return 1;
    }

    @Uninterruptible(reason="Prevent epoch change.", callerMustBe=true)
    private JfrThreadEpochData getEpochData(boolean previousEpoch) {
        boolean epoch = previousEpoch ? JfrTraceIdEpoch.getInstance().previousEpoch() : JfrTraceIdEpoch.getInstance().currentEpoch();
        return epoch ? this.epochData0 : this.epochData1;
    }

    private static class JfrThreadEpochData {
        private final JfrVisitedTable threadTable = new JfrVisitedTable();
        private final JfrVisitedTable threadGroupTable = new JfrVisitedTable();
        private int unflushedThreadCount = 0;
        private int unflushedThreadGroupCount = 0;
        private JfrBuffer threadBuffer;
        private JfrBuffer threadGroupBuffer;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        JfrThreadEpochData() {
        }

        @Uninterruptible(reason="May write current epoch data.")
        void clear(boolean flushpoint) {
            if (!flushpoint) {
                this.threadTable.clear();
                this.threadGroupTable.clear();
            }
            this.unflushedThreadCount = 0;
            this.unflushedThreadGroupCount = 0;
            JfrBufferAccess.reinitialize(this.threadBuffer);
            JfrBufferAccess.reinitialize(this.threadGroupBuffer);
        }

        void teardown() {
            this.threadTable.teardown();
            this.threadGroupTable.teardown();
            this.unflushedThreadCount = 0;
            this.unflushedThreadGroupCount = 0;
            JfrBufferAccess.free(this.threadBuffer);
            this.threadBuffer = (JfrBuffer)WordFactory.nullPointer();
            JfrBufferAccess.free(this.threadGroupBuffer);
            this.threadGroupBuffer = (JfrBuffer)WordFactory.nullPointer();
        }
    }
}

