/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.SimpleCodeInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackFrameVisitor;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.thread.ContinuationInternals;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.Target_java_lang_VirtualThread;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_Continuation;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_ContinuationScope;
import com.oracle.svm.core.util.VMError;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@TargetClass(value=StackWalker.class)
@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
final class Target_java_lang_StackWalker {
    @Alias
    Target_jdk_internal_vm_Continuation continuation;
    @Alias
    Target_jdk_internal_vm_ContinuationScope contScope;
    @Alias
    Set<StackWalker.Option> options;
    @Alias
    boolean retainClassRef;

    Target_java_lang_StackWalker() {
    }

    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    private void forEach(final Consumer<? super StackWalker.StackFrame> action) {
        final boolean showHiddenFrames = this.options.contains((Object)StackWalker.Option.SHOW_HIDDEN_FRAMES);
        final boolean showReflectFrames = this.options.contains((Object)StackWalker.Option.SHOW_REFLECT_FRAMES);
        JavaStackWalker.walkCurrentThread(KnownIntrinsics.readCallerStackPointer(), new JavaStackFrameVisitor(this){
            final /* synthetic */ Target_java_lang_StackWalker this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean visitFrame(FrameInfoQueryResult frameInfo) {
                if (StackTraceUtils.shouldShowFrame(frameInfo, showHiddenFrames, showReflectFrames, showHiddenFrames)) {
                    action.accept(this.this$0.new StackFrameImpl(frameInfo));
                }
                return true;
            }
        });
    }

    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    private Class<?> getCallerClass() {
        if (!this.retainClassRef) {
            throw new UnsupportedOperationException("This stack walker does not have RETAIN_CLASS_REFERENCE access");
        }
        Class<?> result = StackTraceUtils.getCallerClass(KnownIntrinsics.readCallerStackPointer(), false);
        if (result == null) {
            throw new IllegalCallerException("No calling frame");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    private <T> T walk(Function<? super Stream<StackWalker.StackFrame>, ? extends T> function) {
        AbstractStackFrameSpliterator spliterator;
        JavaStackWalk walk = UnsafeStackValue.get(JavaStackWalk.class);
        if (ContinuationSupport.isSupported() && this.continuation != null) {
            spliterator = new ContinuationSpliterator(this, walk, this.contScope, this.continuation);
        } else {
            Pointer sp = KnownIntrinsics.readCallerStackPointer();
            if (ContinuationSupport.isSupported() && (this.contScope != null || JavaThreads.isCurrentThreadVirtual())) {
                Target_jdk_internal_vm_ContinuationScope scope = this.contScope != null ? this.contScope : Target_java_lang_VirtualThread.continuationScope();
                Target_jdk_internal_vm_Continuation top = Target_jdk_internal_vm_Continuation.getCurrentContinuation(scope);
                if (top != null) {
                    JavaStackWalker.initWalk(walk, sp, ContinuationInternals.getBaseSP(top));
                } else {
                    JavaStackWalker.initWalk(walk, sp);
                }
            } else {
                JavaStackWalker.initWalk(walk, sp);
            }
            spliterator = new StackFrameSpliterator(this, walk, Thread.currentThread());
        }
        try {
            T t = function.apply(StreamSupport.stream(spliterator, false));
            return t;
        }
        finally {
            spliterator.invalidate();
        }
    }

    final class ContinuationSpliterator
    extends AbstractStackFrameSpliterator {
        private final Target_jdk_internal_vm_ContinuationScope contScope;
        private JavaStackWalk walk;
        private Target_jdk_internal_vm_Continuation continuation;
        private StoredContinuation stored;
        private UnsignedWord spOffset;
        private UnsignedWord endSpOffset;

        ContinuationSpliterator(Target_java_lang_StackWalker this$0, JavaStackWalk walk, Target_jdk_internal_vm_ContinuationScope contScope, Target_jdk_internal_vm_Continuation continuation) {
            walk.setPossiblyStaleIP((CodePointer)WordFactory.nullPointer());
            this.walk = walk;
            this.contScope = contScope;
            this.continuation = continuation;
        }

        @Uninterruptible(reason="Prevent GC while in this method.")
        private boolean initWalk() {
            assert (this.stored == null);
            if (this.continuation == null || ContinuationInternals.getStoredContinuation(this.continuation) == null) {
                this.walk.setPossiblyStaleIP((CodePointer)WordFactory.nullPointer());
                return false;
            }
            if (!StoredContinuationAccess.initWalk(ContinuationInternals.getStoredContinuation(this.continuation), this.walk)) {
                return false;
            }
            this.stored = ContinuationInternals.getStoredContinuation(this.continuation);
            this.walk.setStartSP((Pointer)WordFactory.nullPointer());
            return true;
        }

        @Override
        protected boolean haveMoreFrames() {
            return this.continuation != null;
        }

        @Override
        protected void advancePhysically() {
            assert (this.continuation != null);
            assert (this.curDeoptimizedFrame == null);
            this.curRegularFrame = null;
            while (this.contScope != null && this.continuation.getScope() != this.contScope) {
                assert (this.stored == null);
                this.continuation = this.continuation.getParent();
                if (this.continuation != null) continue;
                return;
            }
            if (!this.advancePhysically0()) {
                this.continuation = null;
                return;
            }
            if (this.stored == null) {
                this.continuation = this.continuation.getParent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Uninterruptible(reason="Prevent GC while in this method.")
        private boolean advancePhysically0() {
            if (this.walk.getPossiblyStaleIP().isNonNull()) {
                Pointer framesStart = StoredContinuationAccess.getFramesStart(this.stored);
                this.walk.setSP((Pointer)framesStart.add(this.spOffset));
                this.walk.setEndSP((Pointer)framesStart.add(this.endSpOffset));
            } else if (!this.initWalk()) {
                return false;
            }
            VMError.guarantee(Deoptimizer.checkDeoptimized(this.walk.getSP()) == null);
            CodePointer ip = this.walk.getPossiblyStaleIP();
            UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo(ip);
            Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
            SimpleCodeInfoQueryResult queryResult = UnsafeStackValue.get(SimpleCodeInfoQueryResult.class);
            try {
                CodeInfo info = CodeInfoAccess.convert(untetheredInfo, tether);
                VMError.guarantee(this.walk.getIPCodeInfo().equal((ComparableWord)CodeInfoTable.getImageCodeInfo()));
                CodeInfoAccess.lookupCodeInfo(info, CodeInfoAccess.relativeIP(info, ip), queryResult);
                JavaStackWalker.continueWalk(this.walk, queryResult, null);
                if (this.walk.getSP().belowThan((UnsignedWord)this.walk.getEndSP())) {
                    Pointer framesStart = StoredContinuationAccess.getFramesStart(this.stored);
                    this.spOffset = this.walk.getSP().subtract((UnsignedWord)framesStart);
                    this.endSpOffset = this.walk.getEndSP().subtract((UnsignedWord)framesStart);
                } else {
                    this.walk.setPossiblyStaleIP((CodePointer)WordFactory.nullPointer());
                    this.spOffset = (UnsignedWord)WordFactory.zero();
                    this.endSpOffset = (UnsignedWord)WordFactory.zero();
                    this.stored = null;
                }
                this.walk.setSP((Pointer)WordFactory.nullPointer());
                this.walk.setEndSP((Pointer)WordFactory.nullPointer());
                this.curRegularFrame = this.queryFrameInfo(info, ip);
            }
            finally {
                CodeInfoAccess.releaseTether(untetheredInfo, tether);
            }
            return true;
        }

        @Override
        protected void invalidate() {
            this.continuation = null;
            this.stored = null;
            this.walk = (JavaStackWalk)WordFactory.nullPointer();
        }

        @Override
        protected void checkState() {
            if (this.walk.isNull()) {
                throw new IllegalStateException("Continuation traversal no longer valid");
            }
        }
    }

    final class StackFrameSpliterator
    extends AbstractStackFrameSpliterator {
        private final Thread thread;
        private JavaStackWalk walk;

        StackFrameSpliterator(Target_java_lang_StackWalker this$0, JavaStackWalk walk, Thread curThread) {
            this.walk = walk;
            this.thread = curThread;
        }

        @Override
        protected void invalidate() {
            this.walk = (JavaStackWalk)WordFactory.nullPointer();
        }

        @Override
        protected void checkState() {
            if (this.thread != Thread.currentThread()) {
                throw new IllegalStateException("Invalid thread");
            }
            if (this.walk.isNull()) {
                throw new IllegalStateException("Stack traversal no longer valid");
            }
        }

        @Override
        protected boolean haveMoreFrames() {
            Pointer endSP = this.walk.getEndSP();
            Pointer curSP = this.walk.getSP();
            return curSP.isNonNull() && (endSP.isNull() || curSP.belowThan((UnsignedWord)endSP));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
        protected void advancePhysically() {
            CodePointer ip = FrameAccess.singleton().readReturnAddress(this.walk.getSP());
            this.walk.setPossiblyStaleIP(ip);
            DeoptimizedFrame deoptimizedFrame = Deoptimizer.checkDeoptimized(this.walk.getSP());
            if (deoptimizedFrame != null) {
                this.curDeoptimizedFrame = deoptimizedFrame.getTopFrame();
                this.walk.setIPCodeInfo((UntetheredCodeInfo)WordFactory.nullPointer());
                JavaStackWalker.continueWalk(this.walk, (CodeInfo)WordFactory.nullPointer());
            } else {
                UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo(ip);
                this.walk.setIPCodeInfo(untetheredInfo);
                Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
                try {
                    CodeInfo info = CodeInfoAccess.convert(untetheredInfo, tether);
                    this.curRegularFrame = this.queryFrameInfo(info, ip);
                    JavaStackWalker.continueWalk(this.walk, info);
                }
                finally {
                    CodeInfoAccess.releaseTether(untetheredInfo, tether);
                }
            }
        }
    }

    private abstract class AbstractStackFrameSpliterator
    implements Spliterator<StackWalker.StackFrame> {
        protected DeoptimizedFrame.VirtualFrame curDeoptimizedFrame;
        protected FrameInfoQueryResult curRegularFrame;

        private AbstractStackFrameSpliterator() {
        }

        @Override
        public Spliterator<StackWalker.StackFrame> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 1296;
        }

        @Uninterruptible(reason="Wraps the now safe call to query frame information.", calleeMustBe=false)
        protected FrameInfoQueryResult queryFrameInfo(CodeInfo info, CodePointer ip) {
            return CodeInfoTable.lookupCodeInfoQueryResult(info, ip).getFrameInfo();
        }

        @Override
        public boolean tryAdvance(Consumer<? super StackWalker.StackFrame> action) {
            this.checkState();
            boolean showHiddenFrames = Target_java_lang_StackWalker.this.options.contains((Object)StackWalker.Option.SHOW_HIDDEN_FRAMES);
            boolean showReflectFrames = Target_java_lang_StackWalker.this.options.contains((Object)StackWalker.Option.SHOW_REFLECT_FRAMES);
            while (true) {
                FrameInfoQueryResult frameInfo;
                if (this.curDeoptimizedFrame != null) {
                    frameInfo = this.curDeoptimizedFrame.getFrameInfo();
                    this.curDeoptimizedFrame = this.curDeoptimizedFrame.getCaller();
                    if (!this.shouldShowFrame(frameInfo, showHiddenFrames, showReflectFrames, showHiddenFrames)) continue;
                    action.accept(new StackFrameImpl(frameInfo));
                    return true;
                }
                if (this.curRegularFrame != null) {
                    frameInfo = this.curRegularFrame;
                    this.curRegularFrame = this.curRegularFrame.getCaller();
                    if (!this.shouldShowFrame(frameInfo, showHiddenFrames, showReflectFrames, showHiddenFrames)) continue;
                    action.accept(new StackFrameImpl(frameInfo));
                    return true;
                }
                if (!this.haveMoreFrames()) break;
                this.advancePhysically();
            }
            return false;
        }

        protected boolean shouldShowFrame(FrameInfoQueryResult frameInfo, boolean showLambdaFrames, boolean showReflectFrames, boolean showHiddenFrames) {
            return StackTraceUtils.shouldShowFrame(frameInfo, showLambdaFrames, showReflectFrames, showHiddenFrames);
        }

        protected void invalidate() {
        }

        protected void checkState() {
        }

        protected abstract boolean haveMoreFrames();

        protected abstract void advancePhysically();
    }

    final class StackFrameImpl
    implements StackWalker.StackFrame {
        private final FrameInfoQueryResult frameInfo;
        private StackTraceElement ste;

        StackFrameImpl(FrameInfoQueryResult frameInfo) {
            this.frameInfo = frameInfo;
        }

        @Override
        public String getClassName() {
            return this.frameInfo.getSourceClassName();
        }

        @Override
        public String getMethodName() {
            return this.frameInfo.getSourceMethodName();
        }

        @Override
        public Class<?> getDeclaringClass() {
            if (!Target_java_lang_StackWalker.this.retainClassRef) {
                throw new UnsupportedOperationException("This stack walker does not have RETAIN_CLASS_REFERENCE access");
            }
            return this.frameInfo.getSourceClass();
        }

        @Override
        public int getByteCodeIndex() {
            return this.frameInfo.getBci();
        }

        @Override
        public String getFileName() {
            return this.frameInfo.getSourceFileName();
        }

        @Override
        public int getLineNumber() {
            return this.frameInfo.getSourceLineNumber();
        }

        @Override
        public boolean isNativeMethod() {
            return this.frameInfo.isNativeMethod();
        }

        @Override
        public StackTraceElement toStackTraceElement() {
            if (this.ste == null) {
                this.ste = this.frameInfo.getSourceReference();
            }
            return this.ste;
        }

        public String toString() {
            return this.toStackTraceElement().toString();
        }
    }
}

