/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
public final class DynamicHubSupport {
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private int maxTypeId;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private byte[] referenceMapEncoding;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public DynamicHubSupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setMaxTypeId(int maxTypeId) {
        this.maxTypeId = maxTypeId;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public int getMaxTypeId() {
        return this.maxTypeId;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setData(NonmovableArray<Byte> referenceMapEncoding) {
        this.referenceMapEncoding = (byte[])NonmovableArrays.getHostedArray(referenceMapEncoding);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static NonmovableArray<Byte> getReferenceMapEncoding() {
        return NonmovableArrays.fromImageHeap((Object)((DynamicHubSupport)ImageSingletons.lookup(DynamicHubSupport.class)).referenceMapEncoding);
    }
}

