/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heapdump;

import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.heapdump.AllocationFreeOutputStream;
import com.oracle.svm.core.heapdump.HeapDumpUtils;
import com.oracle.svm.core.heapdump.HeapDumpWriter;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.stack.JavaStackFrameVisitor;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class HeapDumpWriterImpl
extends HeapDumpWriter {
    private static final long HPROF_SEGMENTED_HEAP_DUMP_THRESHOLD = 0x80000000L;
    private static final long HPROF_SEGMENTED_HEAP_DUMP_SEGMENT_SIZE = 0x40000000L;
    private static final int HPROF_NOSEEK_HEAP_DUMP_SEGMENT_SIZE = 0x100000;
    private static final String HPROF_HEADER_1_0_1 = "JAVA PROFILE 1.0.1";
    private static final String HPROF_HEADER_1_0_2 = "JAVA PROFILE 1.0.2";
    private static final int HPROF_UTF8 = 1;
    private static final int HPROF_LOAD_CLASS = 2;
    private static final int HPROF_FRAME = 4;
    private static final int HPROF_TRACE = 5;
    private static final int HPROF_HEAP_DUMP = 12;
    private static final int HPROF_HEAP_DUMP_SEGMENT = 28;
    private static final int HPROF_HEAP_DUMP_END = 44;
    private static final int HPROF_GC_ROOT_UNKNOWN = 255;
    private static final int HPROF_GC_ROOT_JNI_GLOBAL = 1;
    private static final int HPROF_GC_ROOT_STICKY_CLASS = 5;
    private static final int HPROF_GC_ROOT_THREAD_OBJ = 8;
    private static final int HPROF_GC_CLASS_DUMP = 32;
    private static final int HPROF_GC_INSTANCE_DUMP = 33;
    private static final int HPROF_GC_OBJ_ARRAY_DUMP = 34;
    private static final int HPROF_GC_PRIM_ARRAY_DUMP = 35;
    private static final int HPROF_NORMAL_OBJECT = 2;
    private static final int HPROF_BOOLEAN = 4;
    private static final int HPROF_CHAR = 5;
    private static final int HPROF_FLOAT = 6;
    private static final int HPROF_DOUBLE = 7;
    private static final int HPROF_BYTE = 8;
    private static final int HPROF_SHORT = 9;
    private static final int HPROF_INT = 10;
    private static final int HPROF_LONG = 11;
    private static final char JVM_SIGNATURE_BOOLEAN = 'Z';
    private static final char JVM_SIGNATURE_CHAR = 'C';
    private static final char JVM_SIGNATURE_BYTE = 'B';
    private static final char JVM_SIGNATURE_SHORT = 'S';
    private static final char JVM_SIGNATURE_INT = 'I';
    private static final char JVM_SIGNATURE_LONG = 'J';
    private static final char JVM_SIGNATURE_FLOAT = 'F';
    private static final char JVM_SIGNATURE_DOUBLE = 'D';
    private static final char JVM_SIGNATURE_ARRAY = '[';
    private static final char JVM_SIGNATURE_CLASS = 'L';
    private static final int DUMMY_STACK_TRACE_ID = 1;
    private static final Field[] ZERO_FIELD_ARR = new Field[0];
    private static final RuntimeException heapSegmentSizeOverflowException = new RuntimeException("Heap segment size overflow.");
    private AllocationFreeDataOutputStream out;
    private HeapDumpUtils heapDumpUtils;
    private Map<String, List<Field>> fieldsMap;
    private ClassToClassDataMap classDataCache;
    private boolean useSegmentedHeapDump;
    private long currentSegmentStart;
    private long segmentSize;

    @Override
    public void writeHeapTo(AllocationFreeOutputStream dataOutputStream, boolean gcBefore) throws IOException {
        this.initialize(true, 0x100000L);
        WriterOperation writerOperation = new WriterOperation(dataOutputStream, gcBefore, 0x100000);
        writerOperation.enqueue();
        IOException operationException = writerOperation.getException();
        if (operationException != null) {
            throw operationException;
        }
        dataOutputStream.close();
    }

    @Override
    public void writeHeapTo(FileOutputStream fileOutputStream, boolean gcBefore) throws IOException {
        this.initialize(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed() > 0x80000000L, 0x40000000L);
        WriterOperation writerOperation = new WriterOperation(fileOutputStream, gcBefore);
        writerOperation.enqueue();
        IOException operationException = writerOperation.getException();
        if (operationException != null) {
            throw operationException;
        }
        fileOutputStream.close();
    }

    private void initialize(boolean useSegmentedHeapDump, long segmentSize) {
        this.currentSegmentStart = 0L;
        this.useSegmentedHeapDump = useSegmentedHeapDump;
        this.segmentSize = segmentSize;
    }

    private void writeTo(AllocationFreeDataOutputStream outputStream, boolean gcBefore) throws IOException {
        if (gcBefore) {
            System.gc();
        }
        this.out = outputStream;
        this.heapDumpUtils = HeapDumpUtils.getHeapDumpUtils();
        this.writeFileHeader();
        this.writeDummyTrace();
        ArrayList classList = new ArrayList();
        Heap.getHeap().visitLoadedClasses(clazz -> classList.add((Class<?>)clazz));
        this.writeClassNames(classList);
        byte[] fieldsMapData = this.heapDumpUtils.getFieldsMap();
        if (fieldsMapData.length == 0) {
            throw new IOException("Empty fieldsMap");
        }
        this.fieldsMap = this.createFieldsMap(fieldsMapData);
        this.writeClasses(classList);
        this.dumpStackTraces();
        this.writeClassDumpRecords(classList);
        this.writeInstanceDumpRecords(classList);
        long dumpEnd = this.out.position();
        long dumpLenLong = dumpEnd - this.currentSegmentStart - 4L;
        this.fillInHeapRecordLength(dumpLenLong);
        if (this.useSegmentedHeapDump) {
            this.out.writeByte(44);
            this.out.writeInt(0);
            this.out.writeInt(0);
        }
        this.out.flush();
        this.out = null;
        this.heapDumpUtils = null;
        this.fieldsMap = null;
        this.classDataCache = null;
    }

    private void writeHeapRecordPrologue() throws IOException {
        if (this.currentSegmentStart == 0L) {
            this.out.flush();
            this.out.writeByte((byte)(this.useSegmentedHeapDump ? 28 : 12));
            this.out.writeInt(0);
            this.currentSegmentStart = this.out.position();
            this.out.writeInt(0);
        }
    }

    private void writeHeapRecordEpilogue() throws IOException {
        this.writeHeapRecordEpilogue(0L);
    }

    private void writeHeapRecordEpilogue(long dumpLenSize) throws IOException {
        long dumpEnd;
        long dumpLenLong;
        if (this.useSegmentedHeapDump && (dumpLenLong = (dumpEnd = this.out.position() + dumpLenSize) - this.currentSegmentStart - 4L) >= this.segmentSize) {
            this.fillInHeapRecordLength(dumpLenLong);
            this.out.flush();
            this.currentSegmentStart = 0L;
        }
    }

    private void fillInHeapRecordLength(long dumpLenLong) throws IOException {
        if (dumpLenLong >= 0x100000000L) {
            throw heapSegmentSizeOverflowException;
        }
        long currentPosition = this.out.position();
        this.out.position(this.currentSegmentStart);
        int dumpLen = (int)dumpLenLong;
        this.out.writeInt(dumpLen);
        this.out.position(currentPosition);
    }

    private void writeClassDumpRecords(List<Class<?>> classList) throws IOException {
        for (Class<?> cls : classList) {
            this.writeHeapRecordPrologue();
            this.writeClassDumpRecord(cls);
            this.writeHeapRecordEpilogue();
        }
    }

    private void writeInstanceDumpRecords(List<Class<?>> classList) throws IOException {
        StacksSlotsVisitorImpl stackVisitor = new StacksSlotsVisitorImpl();
        CollectedHeapVisitorImpl collectedVisitor = new CollectedHeapVisitorImpl();
        ImageHeapVisitorImpl imageVisitor = new ImageHeapVisitorImpl();
        this.heapDumpUtils.walkStacks(stackVisitor);
        IOException visitorException = stackVisitor.getException();
        if (visitorException != null) {
            throw visitorException;
        }
        this.heapDumpUtils.walkHeapObjects(imageVisitor, collectedVisitor);
        visitorException = collectedVisitor.getException();
        if (visitorException != null) {
            throw visitorException;
        }
        visitorException = imageVisitor.getException();
        if (visitorException != null) {
            throw visitorException;
        }
        this.writeStickyClasses(classList);
        this.writeJavaThreads();
    }

    private void writeStickyClasses(List<Class<?>> classList) throws IOException {
        for (Class<?> cls : classList) {
            this.writeHeapRecordPrologue();
            this.out.writeByte(5);
            this.writeObjectID(cls);
            this.writeHeapRecordEpilogue();
        }
    }

    private void writeImageGCRoot(Object obj) throws IOException {
        if (!(obj instanceof Class)) {
            this.writeHeapRecordPrologue();
            this.out.writeByte(1);
            this.writeObjectID(obj);
            this.writeObjectID(null);
            this.writeHeapRecordEpilogue();
        }
    }

    private void writeUnknownGCRoot(Object obj) throws IOException {
        if (obj != null) {
            this.writeHeapRecordPrologue();
            this.out.writeByte(-1);
            this.writeObjectID(obj);
            this.writeHeapRecordEpilogue();
        }
    }

    private void writeJavaThreads() throws IOException {
        int threadSerialNum = 1;
        IsolateThread vmThread = VMThreads.firstThread();
        while (vmThread.isNonNull()) {
            if (vmThread != CurrentIsolate.getCurrentThread()) {
                Thread jt = PlatformThreads.fromVMThread(vmThread);
                this.writeJavaThread(jt, threadSerialNum++);
            }
            vmThread = VMThreads.nextThread(vmThread);
        }
    }

    private void writeJavaThread(Thread jt, int threadSerialNum) throws IOException {
        this.writeHeapRecordPrologue();
        this.out.writeByte(8);
        this.writeObjectID(jt);
        this.out.writeInt(threadSerialNum);
        this.out.writeInt(threadSerialNum + 1);
        this.writeHeapRecordEpilogue();
    }

    private void writeClass(Class<?> clazz) throws IOException {
        if (this.classDataCache.get(clazz) == null) {
            this.writeInstance(clazz);
        }
    }

    private void writeClassDumpRecord(Class<?> cls) throws IOException {
        this.out.writeByte(32);
        this.writeObjectID(cls);
        this.out.writeInt(1);
        this.writeObjectID(cls.getSuperclass());
        if (!HeapDumpWriterImpl.isArray(cls)) {
            this.writeObjectID(cls.getClassLoader());
            this.writeObjectID(null);
            this.writeObjectID(null);
            this.writeObjectID(null);
            this.writeObjectID(null);
            this.out.writeInt(this.heapDumpUtils.instanceSizeOf(cls));
            this.out.writeShort(0);
            List<Field> declaredFields = this.getImmediateFields(cls);
            int staticFields = 0;
            int instanceFields = 0;
            for (int i = 0; i < declaredFields.size(); ++i) {
                Field field = declaredFields.get(i);
                if (field.isStatic()) {
                    ++staticFields;
                    continue;
                }
                ++instanceFields;
            }
            this.writeFieldDescriptors(true, staticFields, declaredFields);
            this.writeFieldDescriptors(false, instanceFields, declaredFields);
        } else {
            Class<?> baseClass = HeapDumpWriterImpl.getBaseClass(cls);
            this.writeObjectID(baseClass.getClassLoader());
            this.writeObjectID(null);
            this.writeObjectID(null);
            this.writeObjectID(null);
            this.writeObjectID(null);
            this.out.writeInt(0);
            this.out.writeShort(0);
            this.out.writeShort(0);
            this.out.writeShort(0);
        }
    }

    private void dumpStackTraces() throws IOException {
        this.writeHeader(5, 12);
        this.out.writeInt(1);
        this.out.writeInt(0);
        this.out.writeInt(0);
        int frameSerialNum = 0;
        int numThreads = 0;
        HashSet<String> names = new HashSet<String>();
        IsolateThread vmThread = VMThreads.firstThread();
        while (vmThread.isNonNull()) {
            if (vmThread != CurrentIsolate.getCurrentThread()) {
                final ArrayList stack = new ArrayList();
                JavaStackFrameVisitor visitor = new JavaStackFrameVisitor(this){

                    @Override
                    public boolean visitFrame(FrameInfoQueryResult frameInfo) {
                        if (frameInfo.getSourceClass() != null) {
                            stack.add(frameInfo);
                        }
                        return true;
                    }
                };
                JavaStackWalker.walkThread(vmThread, visitor);
                ++numThreads;
                int depth = stack.size();
                int threadFrameStart = frameSerialNum;
                for (int j = 0; j < depth; ++j) {
                    FrameInfoQueryResult frame = (FrameInfoQueryResult)stack.get(j);
                    ClassData cd = this.classDataCache.get(frame.getSourceClass());
                    int classSerialNum = cd.serialNum;
                    assert (classSerialNum > 0) : "class not found";
                    this.dumpStackFrame(++frameSerialNum, classSerialNum, frame, names);
                }
                this.writeHeader(5, 12 + depth * HeapDumpWriterImpl.getObjIDSize());
                int stackSerialNum = numThreads + 1;
                this.out.writeInt(stackSerialNum);
                this.out.writeInt(numThreads);
                this.out.writeInt(depth);
                for (int j = 1; j <= depth; ++j) {
                    this.writeObjectAddress(threadFrameStart + j);
                }
            }
            vmThread = VMThreads.nextThread(vmThread);
        }
        names = null;
    }

    private void dumpStackFrame(int frameSN, int classSN, FrameInfoQueryResult frame, Set<String> names) throws IOException {
        int lineNumber = frame.isNativeMethod() ? -3 : frame.getSourceLineNumber();
        String method = frame.getSourceMethodName();
        String source = frame.getSourceFileName();
        if (method == null || method.isEmpty()) {
            method = "";
        }
        if (source == null || source.isEmpty()) {
            source = "Unknown Source";
        }
        this.writeName(method, names);
        this.writeName("", names);
        this.writeName(source, names);
        this.writeHeader(4, 4 * HeapDumpWriterImpl.getObjIDSize() + 8);
        this.writeObjectAddress(frameSN);
        this.writeSymbolID(method);
        this.writeSymbolID("");
        this.writeSymbolID(source);
        this.out.writeInt(classSN);
        this.out.writeInt(lineNumber);
    }

    private void writeName(String name, Set<String> names) throws IOException {
        if (names.add(name)) {
            this.writeSymbol(name);
        }
    }

    private void writeHeapInstance(Object obj) throws IOException {
        this.writeHeapRecordPrologue();
        if (obj instanceof Class) {
            this.writeClass((Class)obj);
            this.writeHeapRecordEpilogue();
        } else if (this.heapDumpUtils.isJavaPrimitiveArray(obj)) {
            this.writePrimitiveArray(obj);
        } else if (HeapDumpWriterImpl.isArray(obj.getClass())) {
            this.writeObjectArray((Object[])obj);
        } else {
            this.writeInstance(obj);
            this.writeHeapRecordEpilogue();
        }
    }

    private List<Field> getImmediateFields(Class<?> cls) {
        String clsName = cls.getName();
        List<Field> fields = this.fieldsMap.get(clsName);
        if (fields == null) {
            return Collections.emptyList();
        }
        return fields;
    }

    private void writeObjectArray(Object[] array) throws IOException {
        this.out.writeByte(34);
        this.writeObjectID(array);
        this.out.writeInt(1);
        this.out.writeInt(array.length);
        this.writeObjectID(array.getClass());
        this.writeHeapRecordEpilogue(array.length * HeapDumpWriterImpl.getObjIDSize());
        for (Object o : array) {
            this.writeObjectID(o);
        }
    }

    private void writePrimitiveArray(Object pArray) throws IOException {
        this.out.writeByte(35);
        this.writeObjectID(pArray);
        this.out.writeInt(1);
        if (pArray instanceof char[]) {
            this.writeCharArray((char[])pArray);
        } else if (pArray instanceof byte[]) {
            this.writeByteArray((byte[])pArray);
        } else if (pArray instanceof int[]) {
            this.writeIntArray((int[])pArray);
        } else if (pArray instanceof long[]) {
            this.writeLongArray((long[])pArray);
        } else if (pArray instanceof boolean[]) {
            this.writeBooleanArray((boolean[])pArray);
        } else if (pArray instanceof short[]) {
            this.writeShortArray((short[])pArray);
        } else if (pArray instanceof double[]) {
            this.writeDoubleArray((double[])pArray);
        } else if (pArray instanceof float[]) {
            this.writeFloatArray((float[])pArray);
        } else {
            throw VMError.shouldNotReachHere(pArray.getClass().getName());
        }
    }

    private void writeBooleanArray(boolean[] array) throws IOException {
        this.out.writeInt(array.length);
        this.out.writeByte(4);
        this.writeHeapRecordEpilogue(array.length * 1);
        for (boolean b : array) {
            this.out.writeBoolean(b);
        }
    }

    private void writeByteArray(byte[] array) throws IOException {
        this.out.writeInt(array.length);
        this.out.writeByte(8);
        this.writeHeapRecordEpilogue(array.length * 1);
        for (byte b : array) {
            this.out.writeByte(b);
        }
    }

    private void writeShortArray(short[] array) throws IOException {
        this.out.writeInt(array.length);
        this.out.writeByte(9);
        this.writeHeapRecordEpilogue(array.length * 2);
        for (short s : array) {
            this.out.writeShort(s);
        }
    }

    private void writeIntArray(int[] array) throws IOException {
        this.out.writeInt(array.length);
        this.out.writeByte(10);
        this.writeHeapRecordEpilogue(array.length * 4);
        for (int i : array) {
            this.out.writeInt(i);
        }
    }

    private void writeLongArray(long[] array) throws IOException {
        this.out.writeInt(array.length);
        this.out.writeByte(11);
        this.writeHeapRecordEpilogue(array.length * 8);
        for (long l : array) {
            this.out.writeLong(l);
        }
    }

    private void writeCharArray(char[] array) throws IOException {
        this.out.writeInt(array.length);
        this.out.writeByte(5);
        this.writeHeapRecordEpilogue(array.length * 2);
        for (char c : array) {
            this.out.writeChar(c);
        }
    }

    private void writeFloatArray(float[] array) throws IOException {
        this.out.writeInt(array.length);
        this.out.writeByte(6);
        this.writeHeapRecordEpilogue(array.length * 4);
        for (float f : array) {
            this.out.writeFloat(f);
        }
    }

    private void writeDoubleArray(double[] array) throws IOException {
        this.out.writeInt(array.length);
        this.out.writeByte(7);
        this.writeHeapRecordEpilogue(array.length * 8);
        for (double d : array) {
            this.out.writeDouble(d);
        }
    }

    private void writeInstance(Object instance) throws IOException {
        this.out.writeByte(33);
        this.writeObjectID(instance);
        this.out.writeInt(1);
        Class<?> cls = instance.getClass();
        this.writeObjectID(cls);
        ClassData cd = this.classDataCache.get(cls);
        this.out.writeInt(cd.instSize);
        Pointer objRef = this.heapDumpUtils.objectToPointer(instance);
        for (int i = 0; i < cd.fields.length; ++i) {
            this.writeField(cd.fields[i], objRef);
        }
    }

    private void writeFieldDescriptors(boolean isStatic, int size, List<Field> fields) throws IOException {
        this.out.writeShort((short)size);
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            if (isStatic != field.isStatic()) continue;
            this.writeSymbolIDFromField(field);
            char typeCode = field.getStorageSignature();
            int kind = HeapDumpWriterImpl.signatureToHprofKind(typeCode);
            this.out.writeByte((byte)kind);
            if (!field.isStatic()) continue;
            char javaSignature = field.getStorageSignature();
            Object staticData = javaSignature == 'L' || javaSignature == '[' ? StaticFieldsSupport.getStaticObjectFields() : StaticFieldsSupport.getStaticPrimitiveFields();
            this.writeField(field, this.heapDumpUtils.objectToPointer(staticData));
        }
    }

    private static int signatureToHprofKind(char ch) {
        switch (ch) {
            case 'L': 
            case '[': {
                return 2;
            }
            case 'Z': {
                return 4;
            }
            case 'C': {
                return 5;
            }
            case 'F': {
                return 6;
            }
            case 'D': {
                return 7;
            }
            case 'B': {
                return 8;
            }
            case 'S': {
                return 9;
            }
            case 'I': {
                return 10;
            }
            case 'J': {
                return 11;
            }
        }
        throw new RuntimeException("Should not reach here");
    }

    private void writeField(Field field, Pointer p) throws IOException {
        char storageSignature = field.getStorageSignature();
        int location = field.getLocation();
        switch (storageSignature) {
            case 'Z': {
                this.out.writeByte(p.readByte(location));
                break;
            }
            case 'C': {
                this.out.writeChar(p.readChar(location));
                break;
            }
            case 'B': {
                this.out.writeByte(p.readByte(location));
                break;
            }
            case 'S': {
                this.out.writeShort(p.readShort(location));
                break;
            }
            case 'I': {
                this.out.writeInt(p.readInt(location));
                break;
            }
            case 'J': {
                this.out.writeLong(p.readLong(location));
                break;
            }
            case 'F': {
                this.out.writeFloat(p.readFloat(location));
                break;
            }
            case 'D': {
                this.out.writeDouble(p.readDouble(location));
                break;
            }
            case 'L': 
            case '[': {
                this.writeObjectID(ReferenceAccess.singleton().readObjectAt(p.add(location), true));
                break;
            }
            default: {
                throw VMError.shouldNotReachHere("HeapDumpWriter.writeField: storageSignature");
            }
        }
    }

    private void writeHeader(int tag, int len) throws IOException {
        this.out.writeByte((byte)tag);
        this.out.writeInt(0);
        this.out.writeInt(len);
    }

    private void writeDummyTrace() throws IOException {
        this.writeHeader(5, 12);
        this.out.writeInt(1);
        this.out.writeInt(0);
        this.out.writeInt(0);
    }

    private void writeSymbolFromField(byte[] data, Field field) throws IOException {
        this.writeHeader(1, field.getNameLength() + HeapDumpWriterImpl.getObjIDSize());
        this.writeSymbolIDFromField(field);
        this.out.write(data, field.getNameStartOffset(), field.getNameLength());
    }

    private void writeSymbol(String clsName) throws IOException {
        byte[] buf = clsName.getBytes(StandardCharsets.UTF_8);
        this.writeHeader(1, buf.length + HeapDumpWriterImpl.getObjIDSize());
        this.writeSymbolID(clsName);
        this.out.write(buf);
    }

    private void writeClassNames(List<Class<?>> classList) throws IOException {
        for (Class<?> cls : classList) {
            this.writeSymbol(cls.getName());
        }
    }

    private void writeClasses(List<Class<?>> classList) throws IOException {
        int serialNum = 1;
        HashMap classDataMap = new HashMap();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> cls : classList) {
            this.writeHeader(2, 2 * (HeapDumpWriterImpl.getObjIDSize() + 4));
            this.out.writeInt(serialNum);
            this.writeObjectID(cls);
            this.out.writeInt(1);
            this.writeSymbolID(cls.getName());
            assert (fields.isEmpty());
            this.addInstanceFieldsTo(fields, cls);
            int instSize = HeapDumpWriterImpl.getSizeForFields(fields);
            classDataMap.put(cls, new ClassData(serialNum, instSize, fields.toArray(ZERO_FIELD_ARR)));
            fields.clear();
            ++serialNum;
        }
        this.classDataCache = new ClassToClassDataMap(classDataMap);
    }

    private void writeFileHeader() throws IOException {
        if (this.useSegmentedHeapDump) {
            this.out.writeBytes(HPROF_HEADER_1_0_2);
        } else {
            this.out.writeBytes(HPROF_HEADER_1_0_1);
        }
        this.out.writeByte(0);
        this.out.writeInt(HeapDumpWriterImpl.getObjIDSize());
        this.out.writeLong(System.currentTimeMillis());
    }

    private void writeObjectID(Object obj) throws IOException {
        if (obj != null) {
            UnsignedWord ptr = ReferenceAccess.singleton().getCompressedRepresentation(obj);
            this.writeObjectAddress(ptr.rawValue());
        } else {
            this.writeObjectAddress(0L);
        }
    }

    private void writeSymbolID(String clsName) throws IOException {
        this.writeObjectID(clsName);
    }

    private void writeSymbolIDFromField(Field field) throws IOException {
        this.writeObjectID(field);
    }

    private void writeObjectAddress(long address) throws IOException {
        if (HeapDumpWriterImpl.getObjIDSize() == 4) {
            this.out.writeInt((int)address);
        } else {
            this.out.writeLong(address);
        }
    }

    private void addInstanceFieldsTo(List<Field> res, Class<?> cls) {
        for (Class<?> clazz = cls; clazz != null; clazz = clazz.getSuperclass()) {
            List<Field> curFields = this.getImmediateFields(clazz);
            for (int i = 0; i < curFields.size(); ++i) {
                Field f = curFields.get(i);
                if (f.isStatic()) continue;
                res.add(f);
            }
        }
    }

    private static int getSizeForFields(List<Field> fields) {
        int size = 0;
        block7: for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            char typeCode = field.getStorageSignature();
            switch (typeCode) {
                case 'B': 
                case 'Z': {
                    ++size;
                    continue block7;
                }
                case 'C': 
                case 'S': {
                    size += 2;
                    continue block7;
                }
                case 'F': 
                case 'I': {
                    size += 4;
                    continue block7;
                }
                case 'L': 
                case '[': {
                    size += HeapDumpWriterImpl.getObjIDSize();
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    size += 8;
                    continue block7;
                }
                default: {
                    throw new RuntimeException("Should not reach here");
                }
            }
        }
        return size;
    }

    private static int getObjIDSize() {
        return ConfigurationValues.getObjectLayout().getReferenceSize();
    }

    private static boolean isArray(Class<?> cls) {
        return cls.getName().startsWith("[");
    }

    private static Class<?> getBaseClass(Class<?> array) {
        Class<?> arr = array;
        while (HeapDumpWriterImpl.isArray(arr)) {
            arr = arr.getComponentType();
        }
        return arr;
    }

    private Map<String, List<Field>> createFieldsMap(byte[] data) throws IOException {
        int offset = 0;
        HashMap<String, List<Field>> fldMap = new HashMap<String, List<Field>>();
        while (offset < data.length) {
            ArrayList<Field> fields;
            String className;
            if (data[offset += (className = HeapDumpWriterImpl.readString(data, offset)).length() + 1] == 0 && data[offset + 1] == 0) {
                fields = Collections.emptyList();
                offset += 2;
            } else {
                fields = new ArrayList();
                offset = this.readFields(false, data, offset, fields);
                ++offset;
                offset = this.readFields(true, data, offset, fields);
                ++offset;
            }
            fldMap.put(className, fields);
        }
        return fldMap;
    }

    private int readFields(boolean isStatic, byte[] data, int dataOffset, List<Field> fields) throws IOException {
        int offset = dataOffset;
        while (data[offset] != 0) {
            int stringStart = offset;
            int stringLength = HeapDumpWriterImpl.readStringLength(data, offset);
            offset += stringLength + 1;
            char javaSig = (char)data[offset++];
            char storageSig = (char)data[offset++];
            int location = HeapDumpWriterImpl.readInt(data, offset);
            offset += 4;
            Field fieldDef = new Field(stringStart, stringLength, javaSig, storageSig, isStatic, location);
            this.writeSymbolFromField(data, fieldDef);
            fields.add(fieldDef);
        }
        return offset;
    }

    private static int readInt(byte[] data, int st) {
        int start = st;
        int ch1 = data[start++] & 0xFF;
        int ch2 = data[start++] & 0xFF;
        int ch3 = data[start++] & 0xFF;
        int ch4 = data[start++] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    private static String readString(byte[] data, int start) {
        int len = HeapDumpWriterImpl.readStringLength(data, start);
        return new String(data, start, len, StandardCharsets.UTF_8);
    }

    private static int readStringLength(byte[] data, int start) {
        int offset = start;
        while (data[offset] != 0) {
            ++offset;
        }
        return offset - start;
    }

    private class WriterOperation
    extends JavaVMOperation {
        private final AllocationFreeDataOutputStream dataOutput;
        private final boolean gcBefore;
        private IOException exception;

        WriterOperation(FileOutputStream fileOutputStream, boolean gcBefore) throws IOException {
            super(VMOperationInfos.get(WriterOperation.class, "Write heap dump", VMOperation.SystemEffect.SAFEPOINT));
            AllocationFreeFileOutputStream fos = ((AllocationFreeFileOutputStream)ImageSingletons.lookup(AllocationFreeFileOutputStream.class)).newStreamFor(fileOutputStream);
            this.dataOutput = new AllocationFreeDataOutputStream(new AllocationFreeBufferedOutputStream(fos));
            this.gcBefore = gcBefore;
        }

        WriterOperation(AllocationFreeOutputStream outputStream, boolean gcBefore, int bufferSize) {
            super(VMOperationInfos.get(WriterOperation.class, "Write heap dump", VMOperation.SystemEffect.SAFEPOINT));
            AllocationFreeFileOutputStreamWrapper fos = new AllocationFreeFileOutputStreamWrapper(HeapDumpWriterImpl.this, outputStream);
            this.dataOutput = new AllocationFreeDataOutputStream(new AllocationFreeBufferedOutputStream(fos, bufferSize + 32768));
            this.gcBefore = gcBefore;
        }

        @Override
        protected void operate() {
            try {
                HeapDumpWriterImpl.this.writeTo(this.dataOutput, this.gcBefore);
            }
            catch (IOException ex) {
                this.exception = ex;
            }
        }

        private IOException getException() {
            return this.exception;
        }
    }

    private static final class AllocationFreeDataOutputStream {
        private final AllocationFreeBufferedOutputStream out;

        private AllocationFreeDataOutputStream(AllocationFreeBufferedOutputStream o) {
            this.out = o;
        }

        private void writeBoolean(boolean v) throws IOException {
            this.out.write(v ? 1 : 0);
        }

        private void writeByte(int v) throws IOException {
            this.out.write(v);
        }

        private void writeChar(int v) throws IOException {
            this.out.write(v >>> 8 & 0xFF);
            this.out.write(v >>> 0 & 0xFF);
        }

        private void writeShort(int v) throws IOException {
            this.out.write(v >>> 8 & 0xFF);
            this.out.write(v >>> 0 & 0xFF);
        }

        private void writeInt(int v) throws IOException {
            this.out.write(v >>> 24 & 0xFF);
            this.out.write(v >>> 16 & 0xFF);
            this.out.write(v >>> 8 & 0xFF);
            this.out.write(v >>> 0 & 0xFF);
        }

        private void writeFloat(float v) throws IOException {
            this.writeInt(Float.floatToIntBits(v));
        }

        private void writeLong(long v) throws IOException {
            this.out.write((byte)(v >>> 56));
            this.out.write((byte)(v >>> 48));
            this.out.write((byte)(v >>> 40));
            this.out.write((byte)(v >>> 32));
            this.out.write((byte)(v >>> 24));
            this.out.write((byte)(v >>> 16));
            this.out.write((byte)(v >>> 8));
            this.out.write((byte)(v >>> 0));
        }

        private void writeDouble(double v) throws IOException {
            this.writeLong(Double.doubleToLongBits(v));
        }

        private void flush() throws IOException {
            this.out.flush();
        }

        private void write(byte[] buf) throws IOException {
            this.out.write(buf, 0, buf.length);
        }

        private void write(byte[] buf, int off, int len) throws IOException {
            this.out.write(buf, off, len);
        }

        private void writeBytes(String s) throws IOException {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                this.out.write((byte)s.charAt(i));
            }
        }

        private long position() throws IOException {
            return this.out.position();
        }

        private void position(long pos) throws IOException {
            this.out.position(pos);
        }
    }

    private static class ClassToClassDataMap {
        private final ClassData[] classDataArray;

        ClassToClassDataMap(Map<Class<?>, ClassData> map) {
            int maxTypeID = 0;
            for (Class<?> key : map.keySet()) {
                maxTypeID = Integer.max(maxTypeID, ClassToClassDataMap.typeIDFromClass(key));
            }
            this.classDataArray = new ClassData[maxTypeID + 1];
            for (Class<?> key : map.keySet()) {
                this.classDataArray[ClassToClassDataMap.typeIDFromClass(key)] = map.get(key);
            }
        }

        ClassData get(Class<?> clazz) {
            int id = ClassToClassDataMap.typeIDFromClass(clazz);
            if (id >= this.classDataArray.length) {
                return null;
            }
            return this.classDataArray[id];
        }

        private static int typeIDFromClass(Class<?> clazz) {
            return DynamicHub.fromClass(clazz).getTypeID();
        }
    }

    private class StacksSlotsVisitorImpl
    extends HeapDumpUtils.StacksSlotsVisitor {
        private IOException exception;

        private StacksSlotsVisitorImpl() {
        }

        @Override
        public boolean visitObjectReference(Pointer objRef, boolean compressed, Object holderObject) {
            try {
                Object obj = ReferenceAccess.singleton().readObjectAt(objRef, compressed);
                HeapDumpWriterImpl.this.writeUnknownGCRoot(obj);
                return true;
            }
            catch (IOException ex) {
                this.exception = ex;
                return false;
            }
        }

        private IOException getException() {
            return this.exception;
        }
    }

    private class CollectedHeapVisitorImpl
    implements ObjectVisitor {
        private IOException exception;

        private CollectedHeapVisitorImpl() {
        }

        @Override
        public boolean visitObject(Object obj) {
            Object asObject = obj;
            try {
                HeapDumpWriterImpl.this.writeHeapInstance(asObject);
            }
            catch (IOException ex) {
                this.exception = ex;
                return false;
            }
            return true;
        }

        private IOException getException() {
            return this.exception;
        }
    }

    private class ImageHeapVisitorImpl
    implements ObjectVisitor {
        private IOException exception;

        private ImageHeapVisitorImpl() {
        }

        @Override
        public boolean visitObject(Object obj) {
            Object asObject = obj;
            try {
                HeapDumpWriterImpl.this.writeHeapInstance(asObject);
                HeapDumpWriterImpl.this.writeImageGCRoot(asObject);
            }
            catch (IOException ex) {
                this.exception = ex;
                return false;
            }
            return true;
        }

        private IOException getException() {
            return this.exception;
        }
    }

    private static class ClassData {
        int serialNum;
        int instSize;
        Field[] fields;

        ClassData(int serialNum, int instSize, Field[] fields) {
            this.serialNum = serialNum;
            this.instSize = instSize;
            this.fields = fields;
        }
    }

    private static final class Field {
        private final int nameStart;
        private final int nameLength;
        private final char javaSig;
        private final char storageSig;
        private final boolean isStatic;
        private final int location;

        private Field(int ss, int sl, char jsig, char ssig, boolean s, int loc) {
            this.nameStart = ss;
            this.nameLength = sl;
            this.javaSig = (char)(jsig == 'A' ? 76 : (int)jsig);
            this.storageSig = (char)(ssig == 'A' ? 76 : (int)ssig);
            this.isStatic = s;
            this.location = loc;
        }

        private boolean isStatic() {
            return this.isStatic;
        }

        private char getJavaSignature() {
            return this.javaSig;
        }

        private char getStorageSignature() {
            return this.storageSig;
        }

        private int getNameStartOffset() {
            return this.nameStart;
        }

        private int getNameLength() {
            return this.nameLength;
        }

        private int getLocation() {
            return this.location;
        }
    }

    private static final class AllocationFreeBufferedOutputStream {
        private byte[] buf;
        private int position;
        private int size;
        private AllocationFreeFileOutputStream out;

        private AllocationFreeBufferedOutputStream(AllocationFreeFileOutputStream out) {
            this(out, 8192);
        }

        private AllocationFreeBufferedOutputStream(AllocationFreeFileOutputStream out, int size) {
            this.out = out;
            if (size <= 0) {
                throw new IllegalArgumentException("Buffer size <= 0");
            }
            this.buf = new byte[size];
        }

        private void flushBuffer() throws IOException {
            if (this.size > 0) {
                this.out.write(this.buf, 0, this.size);
                this.position = 0;
                this.size = 0;
            }
        }

        private void write(int b) throws IOException {
            if (this.position >= this.buf.length) {
                this.flushBuffer();
            }
            this.buf[this.position++] = (byte)b;
            this.setSize();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (len >= this.buf.length) {
                this.flushBuffer();
                this.out.write(b, off, len);
                return;
            }
            if (len > this.buf.length - this.position) {
                this.flushBuffer();
            }
            System.arraycopy(b, off, this.buf, this.position, len);
            this.position += len;
            this.setSize();
        }

        void flush() throws IOException {
            this.flushBuffer();
            this.out.flush();
        }

        private long position() throws IOException {
            return this.out.position() + (long)this.position;
        }

        private void position(long pos) throws IOException {
            long currentFlushPos = this.out.position();
            long newCount = pos - currentFlushPos;
            if (newCount >= 0L && newCount <= (long)this.size) {
                this.position = (int)newCount;
            } else {
                this.flush();
                this.out.position(pos);
            }
        }

        private void setSize() {
            if (this.position > this.size) {
                this.size = this.position;
            }
        }
    }

    private final class AllocationFreeFileOutputStreamWrapper
    extends AllocationFreeFileOutputStream {
        private final AllocationFreeOutputStream out;
        private long position;

        private AllocationFreeFileOutputStreamWrapper(HeapDumpWriterImpl heapDumpWriterImpl, AllocationFreeOutputStream outputStream) {
            this.out = outputStream;
            this.position = 0L;
        }

        @Override
        public AllocationFreeFileOutputStream newStreamFor(FileOutputStream fileOutputStream) throws IOException {
            throw VMError.shouldNotReachHereAtRuntime();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.position;
        }

        @Override
        public void write(byte[] b, int offset, int length) throws IOException {
            this.out.write(b, offset, length);
            this.position += (long)length;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        protected long position() throws IOException {
            return this.position;
        }

        @Override
        protected long position(long offset) throws IOException {
            throw VMError.shouldNotReachHereAtRuntime();
        }
    }

    public static abstract class AllocationFreeFileOutputStream
    extends OutputStream {
        public abstract AllocationFreeFileOutputStream newStreamFor(FileOutputStream var1) throws IOException;

        @Override
        public abstract void write(int var1) throws IOException;

        @Override
        public abstract void write(byte[] var1, int var2, int var3) throws IOException;

        @Override
        public abstract void close() throws IOException;

        @Override
        public void flush() throws IOException {
        }

        protected abstract long position() throws IOException;

        protected abstract long position(long var1) throws IOException;
    }
}

