/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.UnsignedUtils;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

public final class Pod<T> {
    private final RuntimeSupport.PodInfo podInfo;
    private final int arrayLength;
    private final byte[] referenceMap;
    private final T factory;

    private Pod(RuntimeSupport.PodInfo podInfo, int arrayLength, byte[] referenceMap) {
        this.podInfo = podInfo;
        try {
            Object factoryInstance = podInfo.factoryCtor.newInstance(this);
            this.factory = factoryInstance;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        this.arrayLength = arrayLength;
        this.referenceMap = referenceMap;
    }

    public T getFactory() {
        return this.factory;
    }

    public static final class RuntimeSupport {
        private final EconomicMap<PodSpec, PodInfo> pods = ImageHeapMap.create();

        @Fold
        public static boolean isPresent() {
            return ImageSingletons.contains(RuntimeSupport.class);
        }

        @Fold
        public static RuntimeSupport singleton() {
            return (RuntimeSupport)ImageSingletons.lookup(RuntimeSupport.class);
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public RuntimeSupport() {
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public boolean registerPod(PodSpec spec, PodInfo info) {
            return this.pods.putIfAbsent((Object)spec, (Object)info) == null;
        }

        PodInfo getInfo(PodSpec spec) {
            return (PodInfo)this.pods.get((Object)spec);
        }

        public static final class PodInfo {
            public final Class<?> podClass;
            public final Constructor<?> factoryCtor;

            public PodInfo(Class<?> podClass, Constructor<?> factoryCtor) {
                this.podClass = podClass;
                this.factoryCtor = factoryCtor;
            }
        }

        public static final class PodSpec {
            final Class<?> superClass;
            final Class<?> factoryInterface;

            public PodSpec(Class<?> superClass, Class<?> factoryInterface) {
                assert (superClass != null && factoryInterface != null);
                this.superClass = superClass;
                this.factoryInterface = factoryInterface;
            }

            public boolean equals(Object obj) {
                if (obj != this && this.getClass() == obj.getClass()) {
                    PodSpec other = (PodSpec)obj;
                    return this.superClass.equals(other.superClass) && this.factoryInterface.equals(other.factoryInterface);
                }
                return obj == this;
            }

            public int hashCode() {
                return 31 * this.superClass.hashCode() + this.factoryInterface.hashCode();
            }
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.TYPE})
        public static @interface PodFactory {
            public Class<?> podClass();
        }
    }

    private static final class ReferenceMapEncoder {
        private final BitSet bitset = new BitSet();
        private final int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();

        ReferenceMapEncoder(byte[] referenceMap) {
            if (referenceMap != null) {
                this.decode(referenceMap);
            }
        }

        void add(int offset, int size) {
            assert (offset % this.referenceSize == 0);
            assert (size == this.referenceSize);
            int index = offset / this.referenceSize;
            assert (!this.bitset.get(index));
            this.bitset.set(index);
        }

        byte[] encode() {
            int nrefs;
            if (this.bitset.isEmpty()) {
                return new byte[]{0, 0};
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            int index = 0;
            while (true) {
                int previous = index;
                index = this.bitset.nextClearBit(previous);
                nrefs = index - previous;
                ReferenceMapEncoder.putUV(buffer, nrefs);
                previous = index;
                index = this.bitset.nextSetBit(index);
                if (index == -1) break;
                ReferenceMapEncoder.putUV(buffer, index - previous);
            }
            buffer.write(0);
            if ((nrefs & 0xFF) == 0) {
                buffer.write(0);
                buffer.write(0);
            }
            byte[] bytes = buffer.toByteArray();
            int i = 0;
            for (int j = bytes.length - 1; i < j; ++i, --j) {
                byte t = bytes[i];
                bytes[i] = bytes[j];
                bytes[j] = t;
            }
            assert (this.bitset.equals(new ReferenceMapEncoder((byte[])bytes).bitset));
            return bytes;
        }

        private static void putUV(ByteArrayOutputStream buffer, int value) {
            int v;
            for (v = value; v > 255; v -= 255) {
                buffer.write(255);
                buffer.write(0);
            }
            buffer.write(v);
        }

        private void decode(byte[] encoded) {
            int nrefs;
            int gap;
            int bit = 0;
            int i = encoded.length - 1;
            do {
                nrefs = Byte.toUnsignedInt(encoded[i]);
                gap = Byte.toUnsignedInt(encoded[i - 1]);
                i -= 2;
                this.bitset.set(bit, bit + nrefs);
                bit += nrefs + gap;
            } while (gap != 0 || nrefs == 255);
        }
    }

    public static final class Field
    implements Comparable<Field> {
        private final int size;
        private final boolean isReference;
        private int offset = -1;

        Field(int size, boolean isReference) {
            assert (size > 0);
            this.size = size;
            this.isReference = isReference;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isReference() {
            return this.isReference;
        }

        public int getOffset() {
            if (this.offset == -1) {
                throw new IllegalStateException("Pod must be built before field offsets are assigned");
            }
            return this.offset;
        }

        void initOffset(int value) {
            assert (this.offset == -1);
            assert (value >= 0);
            this.offset = value;
        }

        @Override
        public int compareTo(Field f) {
            if (this.isReference != f.isReference) {
                return Boolean.compare(f.isReference, this.isReference);
            }
            return f.size - this.size;
        }
    }

    public static final class Builder<T> {
        private final Pod<T> superPod;
        private final RuntimeSupport.PodInfo podInfo;
        private final List<Field> fields = new ArrayList<Field>();
        private boolean built = false;

        public static Builder<Supplier<Object>> create() {
            return new Builder<Supplier<Object>>(Object.class, Supplier.class, null);
        }

        public static <T> Builder<T> createExtending(Pod<T> superPod) {
            return new Builder<T>(null, null, superPod);
        }

        public static <T> Builder<T> createExtending(Class<?> superClass, Class<T> factoryInterface) {
            return new Builder<T>(superClass, factoryInterface, null);
        }

        private Builder(Class<?> superClass, Class<?> factoryInterface, Pod<T> superPod) {
            assert (superPod == null || superClass == null && factoryInterface == null);
            if (!RuntimeSupport.isPresent()) {
                throw new UnsupportedOperationException("Pods are not available in this native image.");
            }
            if (superPod != null) {
                this.podInfo = superPod.podInfo;
            } else if (superClass != null && factoryInterface != null) {
                RuntimeSupport.PodSpec spec = new RuntimeSupport.PodSpec(superClass, factoryInterface);
                this.podInfo = RuntimeSupport.singleton().getInfo(spec);
                if (this.podInfo == null) {
                    throw new IllegalArgumentException("Pod superclass/factory interface pair was not registered during image build: " + String.valueOf(superClass) + ", " + String.valueOf(factoryInterface));
                }
            } else {
                throw new NullPointerException();
            }
            assert (DynamicHub.fromClass(this.podInfo.podClass).isPodInstanceClass());
            this.superPod = superPod;
        }

        private void guaranteeUnbuilt() {
            if (this.built) {
                throw new IllegalStateException();
            }
        }

        public Field addField(Class<?> type) {
            this.guaranteeUnbuilt();
            Objects.requireNonNull(type);
            if (type == Void.TYPE) {
                throw new IllegalArgumentException("Fields cannot be of type void");
            }
            JavaKind kind = JavaKind.fromJavaClass(type);
            int size = ConfigurationValues.getObjectLayout().sizeInBytes(kind);
            Field f = new Field(size, kind.isObject());
            this.fields.add(f);
            return f;
        }

        public Pod<T> build() {
            this.guaranteeUnbuilt();
            this.built = true;
            Collections.sort(this.fields);
            UnsignedWord baseOffset = LayoutEncoding.getArrayBaseOffset(DynamicHub.fromClass(this.podInfo.podClass).getLayoutEncoding());
            byte[] superRefMap = null;
            UnsignedWord nextOffset = baseOffset;
            if (this.superPod != null) {
                superRefMap = this.superPod.referenceMap;
                nextOffset = nextOffset.add(this.superPod.arrayLength - superRefMap.length);
            }
            ReferenceMapEncoder refMapEncoder = new ReferenceMapEncoder(superRefMap);
            while (!this.fields.isEmpty()) {
                boolean progress = false;
                for (int i = 0; i < this.fields.size(); ++i) {
                    Field field = this.fields.get(i);
                    if (!nextOffset.unsignedRemainder(field.size).equal(0)) continue;
                    field.initOffset(UnsignedUtils.safeToInt(nextOffset));
                    if (field.isReference) {
                        refMapEncoder.add(UnsignedUtils.safeToInt(nextOffset.subtract(baseOffset)), field.size);
                    }
                    this.fields.remove(i);
                    nextOffset = nextOffset.add(field.size);
                    progress = true;
                    break;
                }
                if (progress) continue;
                nextOffset = nextOffset.add(1);
            }
            byte[] referenceMap = refMapEncoder.encode();
            int arrayLength = UnsignedUtils.safeToInt(nextOffset) + referenceMap.length;
            return new Pod(this.podInfo, arrayLength, referenceMap);
        }
    }
}

