/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.amd64.AMD64CalleeSavedRegisters;
import com.oracle.svm.core.graal.amd64.AMD64ReservedRegisters;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64Backend;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64LoweringProvider;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64RegisterConfig;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64SuitesCreatorProvider;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateBackendFactory;
import com.oracle.svm.core.graal.code.SubstrateLoweringProviderFactory;
import com.oracle.svm.core.graal.code.SubstrateRegisterConfigFactory;
import com.oracle.svm.core.graal.code.SubstrateSuitesCreatorProvider;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.graal.compiler.nodes.spi.PlatformConfigurationProvider;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.DefaultJavaLoweringProvider;
import jdk.graal.compiler.replacements.TargetGraphBuilderPlugins;
import jdk.graal.compiler.replacements.amd64.AMD64GraphBuilderPlugins;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.AMD64.class})
class SubstrateAMD64Feature
implements InternalFeature {
    SubstrateAMD64Feature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(SubstrateRegisterConfigFactory.class, (Object)new SubstrateRegisterConfigFactory(this){

            @Override
            public RegisterConfig newRegisterFactory(SubstrateRegisterConfig.ConfigKind config, MetaAccessProvider metaAccess, TargetDescription target, Boolean preserveFramePointer) {
                return new SubstrateAMD64RegisterConfig(config, metaAccess, target, preserveFramePointer);
            }
        });
        ImageSingletons.add(ReservedRegisters.class, (Object)new AMD64ReservedRegisters());
        if (!SubstrateOptions.useLLVMBackend()) {
            ImageSingletons.add(SubstrateBackendFactory.class, (Object)new SubstrateBackendFactory(this){

                @Override
                public SubstrateBackend newBackend(Providers newProviders) {
                    return new SubstrateAMD64Backend(newProviders);
                }
            });
            ImageSingletons.add(SubstrateLoweringProviderFactory.class, (Object)new SubstrateLoweringProviderFactory(this){

                @Override
                public DefaultJavaLoweringProvider newLoweringProvider(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target) {
                    return new SubstrateAMD64LoweringProvider(metaAccess, foreignCalls, platformConfig, metaAccessExtensionProvider, target);
                }
            });
            ImageSingletons.add(TargetGraphBuilderPlugins.class, (Object)new AMD64GraphBuilderPlugins());
            ImageSingletons.add(SubstrateSuitesCreatorProvider.class, (Object)new SubstrateAMD64SuitesCreatorProvider());
        }
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        if (!SubstrateOptions.useLLVMBackend()) {
            AMD64CalleeSavedRegisters.createAndRegister();
        }
    }
}

