/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.amd64.AMD64CalleeSavedRegisters;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64BlockEndOp;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="FAR_RETURN")
public final class AMD64FarReturnOp
extends AMD64BlockEndOp {
    public static final LIRInstructionClass<AMD64FarReturnOp> TYPE = LIRInstructionClass.create(AMD64FarReturnOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue sp;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue ip;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    AllocatableValue cfiTargetRegister;
    private final boolean fromMethodWithCalleeSavedRegisters;

    public AMD64FarReturnOp(AllocatableValue result, AllocatableValue sp, AllocatableValue ip, boolean fromMethodWithCalleeSavedRegisters) {
        super(TYPE);
        this.result = result;
        this.sp = sp;
        this.ip = ip;
        this.fromMethodWithCalleeSavedRegisters = fromMethodWithCalleeSavedRegisters;
        this.cfiTargetRegister = fromMethodWithCalleeSavedRegisters && SubstrateControlFlowIntegrity.useSoftwareCFI() ? SubstrateControlFlowIntegrity.singleton().getCFITargetRegister().asValue() : Value.ILLEGAL;
    }

    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        if (SubstrateOptions.PreserveFramePointer.getValue().booleanValue()) {
            Label done = new Label();
            masm.cmpqAndJcc(AMD64.rsp, ValueUtil.asRegister((Value)this.sp), AMD64Assembler.ConditionFlag.Equal, done, true);
            masm.movq(AMD64.rbp, new AMD64Address(ValueUtil.asRegister((Value)this.sp), -(FrameAccess.returnAddressSize() + FrameAccess.singleton().savedBasePointerSize())));
            masm.bind(done);
        }
        masm.movq(AMD64.rsp, ValueUtil.asRegister((Value)this.sp));
        if (this.fromMethodWithCalleeSavedRegisters) {
            if (SubstrateControlFlowIntegrity.useSoftwareCFI()) {
                assert (LIRValueUtil.differentRegisters((Object[])new Object[]{this.result, this.cfiTargetRegister})) : Assertions.errorMessage((Object[])new Object[]{this.result, this.cfiTargetRegister});
                Register targetRegister = ValueUtil.asRegister((Value)this.cfiTargetRegister);
                masm.movq(targetRegister, ValueUtil.asRegister((Value)this.ip));
                AMD64CalleeSavedRegisters.singleton().emitRestore(masm, 0, ValueUtil.asRegister((Value)this.result), crb);
                masm.jmp(targetRegister);
            } else {
                AMD64Address ipAddress = new AMD64Address(AMD64.rsp, -FrameAccess.returnAddressSize());
                masm.movq(ipAddress, ValueUtil.asRegister((Value)this.ip));
                AMD64CalleeSavedRegisters.singleton().emitRestore(masm, 0, ValueUtil.asRegister((Value)this.result), crb);
                masm.jmp(ipAddress);
            }
        } else {
            masm.jmp(ValueUtil.asRegister((Value)this.ip));
        }
    }
}

