/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.genscavenge.AbstractMemoryPoolMXBean;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapAccounting;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.util.VMError;
import java.lang.management.MemoryUsage;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class GenScavengeMemoryPoolMXBeans {
    static final String YOUNG_GEN_SCAVENGER = "young generation scavenger";
    static final String COMPLETE_SCAVENGER = "complete scavenger";
    static final String EPSILON_SCAVENGER = "epsilon scavenger";
    static final String EDEN_SPACE = "eden space";
    static final String SURVIVOR_SPACE = "survivor space";
    static final String OLD_GEN_SPACE = "old generation space";
    static final String EPSILON_HEAP = "epsilon heap";
    private final AbstractMemoryPoolMXBean[] mxBeans;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public GenScavengeMemoryPoolMXBeans() {
        if (SubstrateOptions.UseSerialGC.getValue().booleanValue()) {
            this.mxBeans = new AbstractMemoryPoolMXBean[]{new EdenMemoryPoolMXBean(new String[]{YOUNG_GEN_SCAVENGER, COMPLETE_SCAVENGER}), new SurvivorMemoryPoolMXBean(new String[]{YOUNG_GEN_SCAVENGER, COMPLETE_SCAVENGER}), new OldGenerationMemoryPoolMXBean(COMPLETE_SCAVENGER)};
        } else {
            assert (SubstrateOptions.UseEpsilonGC.getValue().booleanValue());
            this.mxBeans = new AbstractMemoryPoolMXBean[]{new EpsilonMemoryPoolMXBean(EPSILON_SCAVENGER)};
        }
    }

    @Fold
    public static GenScavengeMemoryPoolMXBeans singleton() {
        return (GenScavengeMemoryPoolMXBeans)ImageSingletons.lookup(GenScavengeMemoryPoolMXBeans.class);
    }

    public AbstractMemoryPoolMXBean[] getMXBeans() {
        return this.mxBeans;
    }

    public void notifyBeforeCollection() {
        for (AbstractMemoryPoolMXBean mxBean : this.mxBeans) {
            mxBean.beforeCollection();
        }
    }

    public void notifyAfterCollection() {
        for (AbstractMemoryPoolMXBean mxBean : this.mxBeans) {
            mxBean.afterCollection();
        }
    }

    static final class EdenMemoryPoolMXBean
    extends AbstractMemoryPoolMXBean {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        EdenMemoryPoolMXBean(String ... managerNames) {
            super(GenScavengeMemoryPoolMXBeans.EDEN_SPACE, managerNames);
        }

        @Override
        void beforeCollection() {
            this.updatePeakUsage(HeapImpl.getAccounting().getEdenUsedBytes());
        }

        @Override
        void afterCollection() {
        }

        @Override
        UnsignedWord computeInitialValue() {
            return GCImpl.getPolicy().getInitialEdenSize();
        }

        @Override
        public MemoryUsage getUsage() {
            return this.memoryUsage(EdenMemoryPoolMXBean.getCurrentUsage());
        }

        @Override
        public MemoryUsage getPeakUsage() {
            this.updatePeakUsage(EdenMemoryPoolMXBean.getCurrentUsage());
            return this.memoryUsage((UnsignedWord)this.peakUsage.get());
        }

        @Override
        public MemoryUsage getCollectionUsage() {
            return this.memoryUsage((UnsignedWord)WordFactory.zero());
        }

        private static UnsignedWord getCurrentUsage() {
            return HeapImpl.getAccounting().getEdenUsedBytes();
        }
    }

    static final class SurvivorMemoryPoolMXBean
    extends AbstractMemoryPoolMXBean {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        SurvivorMemoryPoolMXBean(String ... managerNames) {
            super(GenScavengeMemoryPoolMXBeans.SURVIVOR_SPACE, managerNames);
        }

        @Override
        void beforeCollection() {
        }

        @Override
        void afterCollection() {
            this.updatePeakUsage(HeapImpl.getAccounting().getSurvivorUsedBytes());
        }

        @Override
        UnsignedWord computeInitialValue() {
            return GCImpl.getPolicy().getInitialSurvivorSize();
        }

        @Override
        public MemoryUsage getUsage() {
            return this.getCollectionUsage();
        }

        @Override
        public MemoryUsage getPeakUsage() {
            return this.memoryUsage((UnsignedWord)this.peakUsage.get());
        }

        @Override
        public MemoryUsage getCollectionUsage() {
            return this.memoryUsage(HeapImpl.getAccounting().getSurvivorUsedBytes());
        }
    }

    static final class OldGenerationMemoryPoolMXBean
    extends AbstractMemoryPoolMXBean {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        OldGenerationMemoryPoolMXBean(String ... managerNames) {
            super(GenScavengeMemoryPoolMXBeans.OLD_GEN_SPACE, managerNames);
        }

        @Override
        void beforeCollection() {
        }

        @Override
        void afterCollection() {
            this.updatePeakUsage(HeapImpl.getAccounting().getOldUsedBytes());
        }

        @Override
        UnsignedWord computeInitialValue() {
            return GCImpl.getPolicy().getInitialOldSize();
        }

        @Override
        public MemoryUsage getUsage() {
            return this.getCollectionUsage();
        }

        @Override
        public MemoryUsage getPeakUsage() {
            return this.memoryUsage((UnsignedWord)this.peakUsage.get());
        }

        @Override
        public MemoryUsage getCollectionUsage() {
            return this.memoryUsage(HeapImpl.getAccounting().getOldUsedBytes());
        }
    }

    static final class EpsilonMemoryPoolMXBean
    extends AbstractMemoryPoolMXBean {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        EpsilonMemoryPoolMXBean(String ... managerNames) {
            super(GenScavengeMemoryPoolMXBeans.EPSILON_HEAP, managerNames);
        }

        @Override
        void beforeCollection() {
            throw VMError.shouldNotReachHereAtRuntime();
        }

        @Override
        void afterCollection() {
            throw VMError.shouldNotReachHereAtRuntime();
        }

        @Override
        UnsignedWord computeInitialValue() {
            return GCImpl.getPolicy().getMinimumHeapSize();
        }

        @Override
        public MemoryUsage getUsage() {
            HeapAccounting accounting = HeapImpl.getAccounting();
            return this.memoryUsage(accounting.getUsedBytes(), accounting.getCommittedBytes());
        }

        @Override
        public MemoryUsage getPeakUsage() {
            return this.getUsage();
        }

        @Override
        public MemoryUsage getCollectionUsage() {
            return this.memoryUsage((UnsignedWord)WordFactory.zero());
        }
    }
}

