/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ProxyConfigurationParser;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdk.graal.compiler.util.json.JSONParserException;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

public class SerializationConfigurationParser
extends ConfigurationParser {
    public static final String NAME_KEY = "name";
    public static final String CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY = "customTargetConstructorClass";
    private static final String SERIALIZATION_TYPES_KEY = "types";
    private static final String LAMBDA_CAPTURING_SERIALIZATION_TYPES_KEY = "lambdaCapturingTypes";
    private static final String PROXY_SERIALIZATION_TYPES_KEY = "proxies";
    private final RuntimeSerializationSupport serializationSupport;
    private final ProxyConfigurationParser proxyConfigurationParser;

    public SerializationConfigurationParser(RuntimeSerializationSupport serializationSupport, boolean strictConfiguration) {
        super(strictConfiguration);
        this.serializationSupport = serializationSupport;
        this.proxyConfigurationParser = new ProxyConfigurationParser(conditionalElement -> serializationSupport.registerProxyClass(conditionalElement.getCondition(), (List)conditionalElement.getElement()), strictConfiguration);
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        if (json instanceof List) {
            this.parseOldConfiguration(SerializationConfigurationParser.asList(json, "First-level of document must be an array of serialization lists"));
        } else if (json instanceof EconomicMap) {
            this.parseNewConfiguration(SerializationConfigurationParser.asMap(json, "First-level of document must be a map of serialization types"));
        } else {
            throw new JSONParserException("First-level of document must either be an array of serialization lists or a map of serialization types");
        }
    }

    private void parseOldConfiguration(List<Object> listOfSerializationConfigurationObjects) {
        this.parseSerializationTypes(SerializationConfigurationParser.asList(listOfSerializationConfigurationObjects, "Second-level of document must be serialization descriptor objects"), false);
    }

    private void parseNewConfiguration(EconomicMap<String, Object> listOfSerializationConfigurationObjects) {
        if (!listOfSerializationConfigurationObjects.containsKey((Object)SERIALIZATION_TYPES_KEY) || !listOfSerializationConfigurationObjects.containsKey((Object)LAMBDA_CAPTURING_SERIALIZATION_TYPES_KEY)) {
            throw new JSONParserException("Second-level of document must be arrays of serialization descriptor objects");
        }
        this.parseSerializationTypes(SerializationConfigurationParser.asList(listOfSerializationConfigurationObjects.get((Object)SERIALIZATION_TYPES_KEY), "The types property must be an array of serialization descriptor objects"), false);
        this.parseSerializationTypes(SerializationConfigurationParser.asList(listOfSerializationConfigurationObjects.get((Object)LAMBDA_CAPTURING_SERIALIZATION_TYPES_KEY), "The lambdaCapturingTypes property must be an array of serialization descriptor objects"), true);
        if (listOfSerializationConfigurationObjects.containsKey((Object)PROXY_SERIALIZATION_TYPES_KEY)) {
            this.proxyConfigurationParser.parseAndRegister(listOfSerializationConfigurationObjects.get((Object)PROXY_SERIALIZATION_TYPES_KEY), null);
        }
    }

    private void parseSerializationTypes(List<Object> listOfSerializationTypes, boolean lambdaCapturingTypes) {
        for (Object serializationType : listOfSerializationTypes) {
            this.parseSerializationDescriptorObject(SerializationConfigurationParser.asMap(serializationType, "Third-level of document must be serialization descriptor objects"), lambdaCapturingTypes);
        }
    }

    private void parseSerializationDescriptorObject(EconomicMap<String, Object> data, boolean lambdaCapturingType) {
        if (lambdaCapturingType) {
            this.checkAttributes(data, "serialization descriptor object", Collections.singleton(NAME_KEY), Collections.singleton("condition"));
        } else {
            this.checkAttributes(data, "serialization descriptor object", Collections.singleton(NAME_KEY), Arrays.asList(CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY, "condition"));
        }
        ConfigurationCondition unresolvedCondition = this.parseCondition(data);
        String targetSerializationClass = SerializationConfigurationParser.asString(data.get((Object)NAME_KEY));
        if (lambdaCapturingType) {
            this.serializationSupport.registerLambdaCapturingClass(unresolvedCondition, targetSerializationClass);
        } else {
            Object optionalCustomCtorValue = data.get((Object)CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY);
            String customTargetConstructorClass = optionalCustomCtorValue != null ? SerializationConfigurationParser.asString(optionalCustomCtorValue) : null;
            this.serializationSupport.registerWithTargetConstructorClass(unresolvedCondition, targetSerializationClass, customTargetConstructorClass);
        }
    }
}

