/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import java.util.Objects;
import jdk.vm.ci.meta.JavaConstant;

class FrameInfoVerifier {
    FrameInfoVerifier() {
    }

    protected static void verifyFrames(FrameInfoEncoder.FrameData expectedData, FrameInfoQueryResult expectedTopFrame, FrameInfoQueryResult actualTopFrame) {
        FrameInfoQueryResult expectedFrame = expectedTopFrame;
        FrameInfoQueryResult actualFrame = actualTopFrame;
        while (expectedFrame != null) {
            assert (actualFrame != null);
            assert (expectedFrame.isDeoptEntry() == actualFrame.isDeoptEntry()) : actualFrame;
            assert (expectedFrame.hasLocalValueInfo() == actualFrame.hasLocalValueInfo()) : actualFrame;
            if (expectedFrame.hasLocalValueInfo()) {
                assert (expectedFrame.getEncodedBci() == actualFrame.getEncodedBci()) : actualFrame;
                assert (expectedFrame.getMethodId() == actualFrame.getMethodId()) : actualFrame;
                assert (expectedFrame.getDeoptMethod() == null && actualFrame.getDeoptMethod() == null || expectedFrame.getDeoptMethod() != null && expectedFrame.getDeoptMethod().equals(actualFrame.getDeoptMethod())) : actualFrame;
                assert (expectedFrame.getDeoptMethodOffset() == actualFrame.getDeoptMethodOffset()) : actualFrame;
                assert (expectedFrame.getNumLocals() == actualFrame.getNumLocals()) : actualFrame;
                assert (expectedFrame.getNumStack() == actualFrame.getNumStack()) : actualFrame;
                assert (expectedFrame.getNumLocks() == actualFrame.getNumLocks()) : actualFrame;
                FrameInfoVerifier.verifyValues(expectedFrame.getValueInfos(), actualFrame.getValueInfos());
                assert (expectedFrame.getVirtualObjects() == expectedTopFrame.getVirtualObjects()) : actualFrame;
                assert (actualFrame.getVirtualObjects() == actualTopFrame.getVirtualObjects()) : actualFrame;
            }
            assert (Objects.equals(expectedFrame.getSourceClass(), actualFrame.getSourceClass())) : actualFrame;
            assert (Objects.equals(expectedFrame.getSourceMethodName(), actualFrame.getSourceMethodName())) : actualFrame;
            assert (expectedFrame.getSourceLineNumber() == actualFrame.getSourceLineNumber()) : actualFrame;
            assert (expectedFrame.getMethodId() == actualFrame.getMethodId()) : actualFrame;
            assert (expectedFrame.sourceClassIndex == actualFrame.sourceClassIndex) : actualFrame;
            assert (expectedFrame.sourceMethodNameIndex == actualFrame.sourceMethodNameIndex) : actualFrame;
            expectedFrame = expectedFrame.caller;
            actualFrame = actualFrame.caller;
        }
        assert (actualFrame == null);
        if (actualTopFrame.hasLocalValueInfo()) {
            assert (expectedData.virtualObjects.length == actualTopFrame.virtualObjects.length) : actualTopFrame;
            for (int i = 0; i < expectedData.virtualObjects.length; ++i) {
                FrameInfoVerifier.verifyValues(expectedData.virtualObjects[i], actualTopFrame.virtualObjects[i]);
            }
        }
    }

    private static void verifyValues(FrameInfoQueryResult.ValueInfo[] expectedValues, FrameInfoQueryResult.ValueInfo[] actualValues) {
        assert (expectedValues.length == actualValues.length) : expectedValues.length + "!=" + actualValues.length;
        for (int i = 0; i < expectedValues.length; ++i) {
            FrameInfoQueryResult.ValueInfo expectedValue = expectedValues[i];
            FrameInfoQueryResult.ValueInfo actualValue = actualValues[i];
            assert (expectedValue.type == actualValue.type) : actualValue;
            assert (expectedValue.kind.equals((Object)actualValue.kind)) : actualValue;
            assert (expectedValue.isCompressedReference == actualValue.isCompressedReference) : actualValue;
            assert (expectedValue.isEliminatedMonitor == actualValue.isEliminatedMonitor) : actualValue;
            assert (expectedValue.data == actualValue.data) : actualValue;
            FrameInfoVerifier.verifyConstant(expectedValue.value, actualValue.value);
        }
    }

    protected static void verifyConstant(JavaConstant expectedConstant, JavaConstant actualConstant) {
        if (expectedConstant != null && expectedConstant.getJavaKind().isPrimitive()) {
            assert (FrameInfoEncoder.encodePrimitiveConstant(expectedConstant) == FrameInfoEncoder.encodePrimitiveConstant(actualConstant)) : actualConstant;
        } else assert (Objects.equals(expectedConstant, actualConstant)) : " Constants are not equal: expected=" + String.valueOf(expectedConstant) + " actual=" + String.valueOf(actualConstant);
    }
}

