/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reachability;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.graal.reachability.MethodSummary;
import com.oracle.graal.reachability.MethodSummaryProvider;
import com.oracle.graal.reachability.ReachabilityAnalysisEngine;
import com.oracle.graal.reachability.ReachabilityAnalysisMethod;
import com.oracle.graal.reachability.ReachabilityMethodProcessingHandler;
import com.oracle.svm.common.meta.MultiMethod;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.vm.ci.meta.JavaConstant;

public class MethodSummaryBasedHandler
implements ReachabilityMethodProcessingHandler {
    private final Timer summaryTimer;
    private final MethodSummaryProvider methodSummaryProvider;

    public MethodSummaryBasedHandler(MethodSummaryProvider methodSummaryProvider, TimerCollection timerCollection) {
        this.methodSummaryProvider = methodSummaryProvider;
        this.summaryTimer = timerCollection.createTimer("((summaries))");
    }

    @Override
    public void onMethodReachable(ReachabilityAnalysisEngine bb, ReachabilityAnalysisMethod method) {
        MethodSummary summary;
        try (Timer.StopTimer t = this.summaryTimer.start();){
            summary = this.methodSummaryProvider.getSummary(bb, method);
        }
        MethodSummaryBasedHandler.processSummary(bb, method, summary);
    }

    @Override
    public void processGraph(ReachabilityAnalysisEngine bb, StructuredGraph graph) {
        MethodSummary summary;
        try (Timer.StopTimer t = this.summaryTimer.start();){
            summary = this.methodSummaryProvider.getSummary(bb, graph);
        }
        ReachabilityAnalysisMethod method = (ReachabilityAnalysisMethod)graph.method();
        MethodSummaryBasedHandler.processSummary(bb, method, summary);
    }

    private static void processSummary(ReachabilityAnalysisEngine bb, ReachabilityAnalysisMethod method, MethodSummary summary) {
        for (AnalysisMethod invokedMethod : summary.virtualInvokedMethods) {
            bb.markMethodInvoked((ReachabilityAnalysisMethod)invokedMethod, (Object)method);
        }
        for (AnalysisMethod invokedMethod : summary.specialInvokedMethods) {
            bb.markMethodSpecialInvoked((ReachabilityAnalysisMethod)invokedMethod, (Object)method);
        }
        for (AnalysisMethod invokedMethod : summary.implementationInvokedMethods) {
            bb.markMethodImplementationInvoked((ReachabilityAnalysisMethod)invokedMethod, (Object)method);
        }
        for (AnalysisType type : summary.accessedTypes) {
            bb.registerTypeAsReachable(type, (Object)method);
        }
        for (AnalysisType type : summary.instantiatedTypes) {
            bb.registerTypeAsAllocated(type, (Object)method);
        }
        for (AnalysisField field : summary.readFields) {
            bb.markFieldRead(field, (Object)method);
            bb.registerTypeAsReachable(field.getType(), (Object)method);
        }
        for (AnalysisField field : summary.writtenFields) {
            bb.markFieldWritten(field, (Object)method);
        }
        for (JavaConstant constant : summary.embeddedConstants) {
            bb.handleEmbeddedConstant(method, constant, (Object)method);
        }
        for (AnalysisMethod rootMethod : summary.foreignCallTargets) {
            bb.addRootMethod(rootMethod, false, (Object)method, new MultiMethod.MultiMethodKey[0]);
        }
    }
}

