/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.phases.NoClassInitializationPlugin;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.graal.phases.TrustedInterfaceTypePlugin;
import com.oracle.svm.core.graal.word.SubstrateWordTypes;
import com.oracle.svm.core.jdk.VarHandleFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.phases.DirectMethodHandleEnsureInitializedNode;
import com.oracle.svm.hosted.phases.SubstrateClassInitializationPlugin;
import com.oracle.svm.hosted.snippets.IntrinsificationPluginRegistry;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ArithmeticOperation;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.TypePlugin;
import org.graalvm.compiler.nodes.java.FinalFieldBarrierNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.InlineDuringParsingPlugin;
import org.graalvm.compiler.replacements.MethodHandlePlugin;
import org.graalvm.compiler.word.WordOperationPlugin;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.nativeimage.ImageSingletons;

public class IntrinsifyMethodHandlesInvocationPlugin
implements NodePlugin {
    private final ParsingReason reason;
    private final Providers parsingProviders;
    private final HostedProviders universeProviders;
    private final AnalysisUniverse aUniverse;
    private final HostedUniverse hUniverse;
    private final ClassInitializationPlugin classInitializationPlugin;
    private final IntrinsificationRegistry intrinsificationRegistry;
    private final ResolvedJavaType methodHandleType;
    private final ResolvedJavaType varHandleType;
    private static final List<Pair<String, List<String>>> IGNORE_FILTER = Arrays.asList(Pair.create((Object)"java.lang.invoke.MethodHandle", Collections.singletonList("bindTo")), Pair.create((Object)"java.lang.invoke.MethodHandles", Arrays.asList("dropArguments", "filterReturnValue", "foldArguments", "insertArguments")), Pair.create((Object)"java.lang.invoke.Invokers", Collections.singletonList("spreadInvoker")));

    public IntrinsifyMethodHandlesInvocationPlugin(ParsingReason reason, HostedProviders providers, AnalysisUniverse aUniverse, HostedUniverse hUniverse) {
        this.reason = reason;
        this.aUniverse = aUniverse;
        this.hUniverse = hUniverse;
        this.universeProviders = providers;
        Providers originalProviders = GraalAccess.getOriginalProviders();
        this.parsingProviders = new Providers(originalProviders).copyWith((MetaAccessExtensionProvider)new MethodHandlesMetaAccessExtensionProvider());
        this.classInitializationPlugin = new SubstrateClassInitializationPlugin((SVMHost)aUniverse.hostVM());
        if (reason == ParsingReason.PointsToAnalysis) {
            this.intrinsificationRegistry = new IntrinsificationRegistry();
            ImageSingletons.add(IntrinsificationRegistry.class, (Object)this.intrinsificationRegistry);
        } else {
            this.intrinsificationRegistry = (IntrinsificationRegistry)ImageSingletons.lookup(IntrinsificationRegistry.class);
        }
        this.methodHandleType = this.universeProviders.getMetaAccess().lookupJavaType(MethodHandle.class);
        this.varHandleType = this.universeProviders.getMetaAccess().lookupJavaType(VarHandle.class);
    }

    public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] originalArgs) {
        ValueNode filteredReceiver;
        PhiNode phi;
        PhiNode receiverForNullCheck = null;
        ValueNode[] args = originalArgs;
        if ((!method.isStatic() || IntrinsifyMethodHandlesInvocationPlugin.isVarHandleGuards(method)) && args.length > 0 && args[0] instanceof PhiNode && !(phi = (PhiNode)args[0]).isLoopPhi() && (filteredReceiver = IntrinsifyMethodHandlesInvocationPlugin.filterNullPhiInputs(phi)) != phi && filteredReceiver.isJavaConstant()) {
            receiverForNullCheck = phi;
            args = Arrays.copyOf(args, args.length);
            args[0] = filteredReceiver;
        }
        if (b.getInvokeKind().isDirect() && (this.hasMethodHandleArgument(args) || this.isVarHandleMethod(method, args)) && !IntrinsifyMethodHandlesInvocationPlugin.ignoreMethod(method)) {
            if (b.bciCanBeDuplicated()) {
                return false;
            }
            if (receiverForNullCheck != null) {
                b.nullCheckedValue(receiverForNullCheck);
            }
            return this.processInvokeWithMethodHandle(b, this.universeProviders.getReplacements(), method, args);
        }
        if (this.methodHandleType.equals(method.getDeclaringClass())) {
            return false;
        }
        return false;
    }

    private static ValueNode filterNullPhiInputs(PhiNode phi) {
        ValueNode notAlwaysNullPhiInput = null;
        for (ValueNode phiInput : phi.values()) {
            if (StampTool.isPointerAlwaysNull((ValueNode)phiInput)) continue;
            if (notAlwaysNullPhiInput != null) {
                return phi;
            }
            notAlwaysNullPhiInput = phiInput;
        }
        return notAlwaysNullPhiInput;
    }

    private boolean hasMethodHandleArgument(ValueNode[] args) {
        for (ValueNode argument : args) {
            if (!argument.isConstant() || argument.getStackKind() != JavaKind.Object || !((UniverseMetaAccess)this.universeProviders.getMetaAccess()).isInstanceOf(argument.asJavaConstant(), this.methodHandleType)) continue;
            return true;
        }
        return false;
    }

    private boolean isVarHandleMethod(ResolvedJavaMethod method, ValueNode[] args) {
        if (IntrinsifyMethodHandlesInvocationPlugin.isVarHandleGuards(method)) {
            if (args.length < 1 || !args[0].isJavaConstant() || !this.isVarHandle(args[0])) {
                return false;
            }
            VarHandleFeature.eagerlyInitializeVarHandle((VarHandle)this.aUniverse.getSnippetReflection().asObject(VarHandle.class, args[0].asJavaConstant()));
            return true;
        }
        return false;
    }

    private static boolean isVarHandleGuards(ResolvedJavaMethod method) {
        return method.getDeclaringClass().toJavaName(true).equals("java.lang.invoke.VarHandleGuards");
    }

    private boolean isVarHandle(ValueNode arg) {
        return this.varHandleType.isAssignableFrom(this.universeProviders.getMetaAccess().lookupJavaType(arg.asJavaConstant()));
    }

    private static boolean ignoreMethod(ResolvedJavaMethod method) {
        String className = method.getDeclaringClass().toJavaName(true);
        String methodName = method.getName();
        for (Pair<String, List<String>> ignored : IGNORE_FILTER) {
            if (!((String)ignored.getLeft()).equals(className) || !((List)ignored.getRight()).contains(methodName)) continue;
            return true;
        }
        return false;
    }

    private static ResolvedJavaField findField(ResolvedJavaType type, String name) {
        for (ResolvedJavaField field : type.getInstanceFields(false)) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw GraalError.shouldNotReachHere((String)("Required field " + name + " not found in " + type));
    }

    private static void registerInvocationPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.lang.invoke.DirectMethodHandle", replacements);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("ensureInitialized", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                GraalError.guarantee((boolean)receiver.isConstant(), (String)"Not a java constant %s", (Object)receiver.get());
                ResolvedJavaField memberField = IntrinsifyMethodHandlesInvocationPlugin.findField(targetMethod.getDeclaringClass(), "member");
                JavaConstant member = b.getConstantReflection().readFieldValue(memberField, receiver.get().asJavaConstant());
                ResolvedJavaField clazzField = IntrinsifyMethodHandlesInvocationPlugin.findField(memberField.getType().resolve(memberField.getDeclaringClass()), "clazz");
                JavaConstant clazz = b.getConstantReflection().readFieldValue(clazzField, member);
                b.add((Node)new DirectMethodHandleEnsureInitializedNode(b.getConstantReflection().asJavaType((Constant)clazz)));
                return true;
            }
        });
        r = new InvocationPlugins.Registration(plugins, "java.lang.invoke.Invokers", replacements);
        r.register((InvocationPlugin)new InvocationPlugin.OptionalInvocationPlugin("maybeCustomize", new Type[]{MethodHandle.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode mh) {
                return true;
            }
        });
        r = new InvocationPlugins.Registration(plugins, Objects.class, replacements);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("requireNonNull", new Type[]{Object.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode object) {
                b.push(JavaKind.Object, b.addNonNullCast(object));
                return true;
            }
        });
        r = new InvocationPlugins.Registration(plugins, MethodHandle.class, replacements);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("asType", new Type[]{InvocationPlugin.Receiver.class, MethodType.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode newTypeNode) {
                ValueNode methodHandleNode = receiver.get(false);
                if (methodHandleNode.isJavaConstant() && newTypeNode.isJavaConstant()) {
                    MethodHandle asType;
                    SnippetReflectionProvider snippetReflection = GraalAccess.getOriginalSnippetReflection();
                    MethodHandle mh = (MethodHandle)snippetReflection.asObject(MethodHandle.class, methodHandleNode.asJavaConstant());
                    MethodType mt = (MethodType)snippetReflection.asObject(MethodType.class, newTypeNode.asJavaConstant());
                    if (mh == null || mt == null) {
                        return false;
                    }
                    try {
                        asType = mh.asType(mt);
                    }
                    catch (WrongMethodTypeException t) {
                        return false;
                    }
                    JavaConstant asTypeConstant = snippetReflection.forObject((Object)asType);
                    ConstantNode asTypeNode = ConstantNode.forConstant((JavaConstant)asTypeConstant, (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph());
                    b.push(JavaKind.Object, (ValueNode)asTypeNode);
                    return true;
                }
                return false;
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean processInvokeWithMethodHandle(GraphBuilderContext b, Replacements replacements, ResolvedJavaMethod methodHandleMethod, ValueNode[] methodHandleArguments) {
        if (!this.reason.duringAnalysis() && this.intrinsificationRegistry.get(b.getMethod(), b.bci()) != Boolean.TRUE) {
            return false;
        }
        GraphBuilderConfiguration.Plugins graphBuilderPlugins = new GraphBuilderConfiguration.Plugins(this.parsingProviders.getReplacements().getGraphBuilderPlugins());
        IntrinsifyMethodHandlesInvocationPlugin.registerInvocationPlugins(graphBuilderPlugins.getInvocationPlugins(), replacements);
        graphBuilderPlugins.prependParameterPlugin((ParameterPlugin)new MethodHandlesParameterPlugin(methodHandleArguments));
        graphBuilderPlugins.clearInlineInvokePlugins();
        graphBuilderPlugins.prependInlineInvokePlugin((InlineInvokePlugin)new MethodHandlesInlineInvokePlugin());
        graphBuilderPlugins.prependNodePlugin((NodePlugin)new MethodHandlePlugin(this.parsingProviders.getConstantReflection().getMethodHandleAccess(), false));
        SnippetReflectionProvider originalSnippetReflection = GraalAccess.getOriginalSnippetReflection();
        ConstantReflectionProvider originalConstantReflection = GraalAccess.getOriginalProviders().getConstantReflection();
        WordOperationPlugin wordOperationPlugin = new WordOperationPlugin(originalSnippetReflection, originalConstantReflection, (WordTypes)new SubstrateWordTypes(this.parsingProviders.getMetaAccess(), FrameAccess.getWordKind()), this.parsingProviders.getPlatformConfigurationProvider().getBarrierSet());
        graphBuilderPlugins.appendInlineInvokePlugin((InlineInvokePlugin)wordOperationPlugin);
        graphBuilderPlugins.appendTypePlugin((TypePlugin)wordOperationPlugin);
        graphBuilderPlugins.appendTypePlugin((TypePlugin)new TrustedInterfaceTypePlugin());
        graphBuilderPlugins.appendNodePlugin((NodePlugin)wordOperationPlugin);
        graphBuilderPlugins.setClassInitializationPlugin((ClassInitializationPlugin)new NoClassInitializationPlugin());
        GraphBuilderConfiguration graphBuilderConfig = GraphBuilderConfiguration.getSnippetDefault((GraphBuilderConfiguration.Plugins)graphBuilderPlugins);
        GraphBuilderPhase.Instance graphBuilder = new GraphBuilderPhase.Instance((CoreProviders)this.parsingProviders, graphBuilderConfig, OptimisticOptimizations.NONE, null);
        DebugContext debug = b.getDebug();
        StructuredGraph graph = new StructuredGraph.Builder(b.getOptions(), debug).method(IntrinsifyMethodHandlesInvocationPlugin.toOriginal(methodHandleMethod)).recordInlinedMethods(false).build();
        try (DebugContext.Scope s = debug.scope((Object)"IntrinsifyMethodHandles", (Object)graph);){
            graphBuilder.apply(graph);
            CanonicalizerPhase.create().apply(graph, (Object)this.parsingProviders);
            debug.dump(3, (Object)graph, "Intrinisfication graph before transplant");
            NodeMap transplanted = new NodeMap((Graph)graph);
            for (ParameterNode oParam22 : graph.getNodes(ParameterNode.TYPE)) {
                transplanted.put((Node)oParam22, (Object)methodHandleArguments[oParam22.index()]);
            }
            Transplanter transplanter = new Transplanter(b, (NodeMap<Node>)transplanted);
            try {
                transplanter.graph(graph);
                if (this.reason.duringAnalysis()) {
                    this.intrinsificationRegistry.add(b.getMethod(), b.bci(), Boolean.TRUE);
                }
                boolean oParam22 = true;
                return oParam22;
            }
            catch (AbortTransplantException ex) {
                boolean bl;
                block14: {
                    bl = ex.handled;
                    if (s == null) break block14;
                    s.close();
                }
                return bl;
            }
        }
        catch (Throwable ex2) {
            throw debug.handle(ex2);
        }
    }

    private void maybeEmitClassInitialization(GraphBuilderContext b, boolean isStatic, ResolvedJavaType declaringClass) {
        if (isStatic) {
            this.classInitializationPlugin.apply(b, declaringClass, () -> ((BytecodeParser)b).getFrameStateBuilder().create(b.bci(), (BytecodeParser)b.getNonIntrinsicAncestor(), false, null, null));
        }
    }

    private ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        Object result = this.aUniverse.lookup((JavaMethod)method);
        if (this.hUniverse != null) {
            result = this.hUniverse.lookup((JavaMethod)result);
        }
        return result;
    }

    private ResolvedJavaField lookup(ResolvedJavaField field) {
        Object result = this.aUniverse.lookup((JavaField)field);
        if (this.hUniverse != null) {
            result = this.hUniverse.lookup((JavaField)result);
        }
        return result;
    }

    private ResolvedJavaType lookup(ResolvedJavaType type) {
        Object result = this.aUniverse.lookup((JavaType)type);
        if (this.hUniverse != null) {
            result = this.hUniverse.lookup((JavaType)result);
        }
        return result;
    }

    private ResolvedJavaType optionalLookup(ResolvedJavaType type) {
        Object result = this.aUniverse.optionalLookup(type);
        if (result != null && this.hUniverse != null) {
            result = this.hUniverse.optionalLookup((JavaType)result);
        }
        return result;
    }

    private JavaConstant lookup(JavaConstant constant) {
        return this.aUniverse.lookup(constant);
    }

    private JavaConstant toOriginal(JavaConstant constant) {
        return this.aUniverse.toHosted(constant);
    }

    private static ResolvedJavaMethod toOriginal(ResolvedJavaMethod method) {
        if (method instanceof HostedMethod) {
            return ((HostedMethod)method).wrapped.wrapped;
        }
        if (method instanceof AnalysisMethod) {
            return ((AnalysisMethod)method).wrapped;
        }
        return method;
    }

    private static ResolvedJavaType toOriginalWithResolve(ResolvedJavaType type) {
        if (type instanceof HostedType) {
            return ((HostedType)type).getWrapped().getWrappedWithResolve();
        }
        if (type instanceof AnalysisType) {
            return ((AnalysisType)type).getWrappedWithResolve();
        }
        return type;
    }

    class MethodHandlesMetaAccessExtensionProvider
    implements MetaAccessExtensionProvider {
        MethodHandlesMetaAccessExtensionProvider() {
        }

        public JavaKind getStorageKind(JavaType type) {
            throw VMError.shouldNotReachHere("storage kind information is only needed for optimization phases not used by the method handle intrinsification");
        }

        public boolean canConstantFoldDynamicAllocation(ResolvedJavaType type) {
            if (IntrinsifyMethodHandlesInvocationPlugin.this.hUniverse == null) {
                return true;
            }
            ResolvedJavaType convertedType = IntrinsifyMethodHandlesInvocationPlugin.this.optionalLookup(type);
            return convertedType != null && ((HostedType)convertedType).isInstantiated();
        }

        public boolean isGuaranteedSafepoint(ResolvedJavaMethod method, boolean isDirect) {
            throw VMError.shouldNotReachHereAtRuntime();
        }

        public boolean canVirtualize(ResolvedJavaType instanceType) {
            return true;
        }
    }

    public static class IntrinsificationRegistry
    extends IntrinsificationPluginRegistry {
    }

    class MethodHandlesParameterPlugin
    implements ParameterPlugin {
        private final ValueNode[] methodHandleArguments;

        MethodHandlesParameterPlugin(ValueNode[] methodHandleArguments) {
            this.methodHandleArguments = methodHandleArguments;
        }

        public FloatingNode interceptParameter(GraphBuilderTool b, int index, StampPair stamp) {
            if (this.methodHandleArguments[index].isConstant()) {
                return ConstantNode.forConstant((JavaConstant)IntrinsifyMethodHandlesInvocationPlugin.this.toOriginal(this.methodHandleArguments[index].asJavaConstant()), (MetaAccessProvider)IntrinsifyMethodHandlesInvocationPlugin.this.parsingProviders.getMetaAccess());
            }
            Stamp argStamp = this.methodHandleArguments[index].stamp(NodeView.DEFAULT);
            ResolvedJavaType argType = StampTool.typeOrNull((Stamp)argStamp);
            if (argType != null) {
                TypeReference typeref = TypeReference.createWithoutAssumptions((ResolvedJavaType)IntrinsifyMethodHandlesInvocationPlugin.toOriginalWithResolve(argType));
                argStamp = StampTool.isPointerNonNull((Stamp)argStamp) ? StampFactory.objectNonNull((TypeReference)typeref) : StampFactory.object((TypeReference)typeref);
            }
            return new ParameterNode(index, StampPair.createSingle((Stamp)argStamp));
        }
    }

    class MethodHandlesInlineInvokePlugin
    implements InlineInvokePlugin {
        MethodHandlesInlineInvokePlugin() {
        }

        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
            if (b.getDepth() > 20 || b.getGraph().getNodeCount() > 1000) {
                return null;
            }
            String className = method.getDeclaringClass().toJavaName(true);
            if (className.startsWith("java.lang.invoke.VarHandle") && (!className.equals("java.lang.invoke.VarHandle") || method.getName().equals("getMethodHandleUncached"))) {
                return null;
            }
            if (className.startsWith("java.lang.invoke") && !className.contains("InvokerBytecodeGenerator")) {
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)method);
            }
            if (className.equals("sun.invoke.util.ValueConversions")) {
                return new InlineDuringParsingPlugin().shouldInlineInvoke(b, method, args);
            }
            return null;
        }
    }

    class Transplanter {
        private final BytecodeParser b;
        private final NodeMap<Node> transplanted;
        private JavaKind tempFrameStackValue;

        Transplanter(GraphBuilderContext b, NodeMap<Node> transplanted) {
            this.b = (BytecodeParser)b;
            this.transplanted = transplanted;
            this.tempFrameStackValue = null;
        }

        void graph(StructuredGraph graph) throws AbortTransplantException {
            JavaKind returnResultKind = this.b.getInvokeReturnType().getJavaKind().getStackKind();
            FixedNode oNode = graph.start().next();
            while (this.fixedWithNextNode(oNode)) {
                oNode = ((FixedWithNextNode)oNode).next();
            }
            if (oNode instanceof ReturnNode) {
                ReturnNode oReturn = (ReturnNode)oNode;
                if (returnResultKind != JavaKind.Void) {
                    this.b.push(returnResultKind, this.node((Node)oReturn.result()));
                }
                return;
            }
            throw this.bailout();
        }

        private boolean frameStackHasSpaceForKind(JavaKind javaKind) {
            return this.b.getFrameStateBuilder().stackSize() + (javaKind.needsTwoSlots() ? 2 : 1) <= this.b.getMethod().getMaxStackSize();
        }

        private void pushToFrameStack(ValueNode value) {
            JavaKind kind = value.getStackKind();
            if (this.frameStackHasSpaceForKind(kind)) {
                this.b.push(kind, value);
                this.tempFrameStackValue = kind;
            }
        }

        private void popTempFrameStackValue() {
            if (this.tempFrameStackValue != null) {
                this.b.pop(this.tempFrameStackValue);
                this.tempFrameStackValue = null;
            }
        }

        private boolean fixedWithNextNode(FixedNode oNode) throws AbortTransplantException {
            if (oNode.getClass() == InvokeNode.class) {
                InvokeNode oInvoke = (InvokeNode)oNode;
                MethodCallTargetNode oCallTarget = (MethodCallTargetNode)oInvoke.callTarget();
                this.transplantInvoke(oInvoke, IntrinsifyMethodHandlesInvocationPlugin.this.lookup(oCallTarget.targetMethod()), oCallTarget.invokeKind(), this.nodes((List<ValueNode>)oCallTarget.arguments()), oCallTarget.returnKind());
                return true;
            }
            if (oNode.getClass() == FixedGuardNode.class) {
                FixedGuardNode oGuard = (FixedGuardNode)oNode;
                if (this.b.needsExplicitException()) {
                    ValueNode[] tExceptionArguments;
                    BytecodeExceptionNode.BytecodeExceptionKind tExceptionKind;
                    if (oGuard.getReason() == DeoptimizationReason.NullCheckException) {
                        tExceptionKind = BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER;
                        tExceptionArguments = ValueNode.EMPTY_ARRAY;
                    } else if (oGuard.getReason() == DeoptimizationReason.ClassCastException && oGuard.condition().getClass() == InstanceOfNode.class) {
                        InstanceOfNode oCondition = (InstanceOfNode)oGuard.condition();
                        tExceptionKind = BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST;
                        tExceptionArguments = new ValueNode[]{this.node((Node)oCondition.getValue()), ConstantNode.forConstant((JavaConstant)this.b.getConstantReflection().asJavaClass(IntrinsifyMethodHandlesInvocationPlugin.this.lookup(oCondition.type().getType())), (MetaAccessProvider)this.b.getMetaAccess(), (StructuredGraph)this.b.getGraph())};
                    } else {
                        return false;
                    }
                    AbstractBeginNode tPassingSuccessor = this.b.emitBytecodeExceptionCheck((LogicNode)this.node((Node)oGuard.condition()), !oGuard.isNegated(), tExceptionKind, tExceptionArguments);
                    this.transplanted.put((Node)oGuard, tPassingSuccessor != null ? tPassingSuccessor : this.b.add((Node)new BeginNode()));
                    return true;
                }
                LogicNode condition = (LogicNode)this.node((Node)oGuard.condition().asNode());
                FixedGuardNode tGuard = (FixedGuardNode)this.b.add((Node)new FixedGuardNode(condition, oGuard.getReason(), oGuard.getAction(), oGuard.isNegated()));
                this.transplanted.put((Node)oGuard, (Object)tGuard);
                return true;
            }
            if (oNode.getClass() == LoadFieldNode.class) {
                LoadFieldNode oLoad = (LoadFieldNode)oNode;
                ResolvedJavaField tTarget = IntrinsifyMethodHandlesInvocationPlugin.this.lookup(oLoad.field());
                IntrinsifyMethodHandlesInvocationPlugin.this.maybeEmitClassInitialization((GraphBuilderContext)this.b, tTarget.isStatic(), tTarget.getDeclaringClass());
                ValueNode tLoad = (ValueNode)this.b.add((Node)LoadFieldNode.create(null, (ValueNode)this.node((Node)oLoad.object()), (ResolvedJavaField)tTarget));
                this.transplanted.put((Node)oLoad, (Object)tLoad);
                return true;
            }
            if (oNode.getClass() == StoreFieldNode.class) {
                StoreFieldNode oStore = (StoreFieldNode)oNode;
                ResolvedJavaField tTarget = IntrinsifyMethodHandlesInvocationPlugin.this.lookup(oStore.field());
                IntrinsifyMethodHandlesInvocationPlugin.this.maybeEmitClassInitialization((GraphBuilderContext)this.b, tTarget.isStatic(), tTarget.getDeclaringClass());
                this.b.add((Node)new StoreFieldNode(this.node((Node)oStore.object()), tTarget, this.node((Node)oStore.value())));
                return true;
            }
            if (oNode.getClass() == NewInstanceNode.class) {
                NewInstanceNode oNew = (NewInstanceNode)oNode;
                ResolvedJavaType tInstanceClass = IntrinsifyMethodHandlesInvocationPlugin.this.lookup(oNew.instanceClass());
                IntrinsifyMethodHandlesInvocationPlugin.this.maybeEmitClassInitialization((GraphBuilderContext)this.b, true, tInstanceClass);
                NewInstanceNode tNew = (NewInstanceNode)this.b.add((Node)new NewInstanceNode(tInstanceClass, oNew.fillContents()));
                this.transplanted.put((Node)oNew, (Object)tNew);
                return true;
            }
            if (oNode.getClass() == NewArrayNode.class) {
                NewArrayNode oNew = (NewArrayNode)oNode;
                NewArrayNode tNew = (NewArrayNode)this.b.add((Node)new NewArrayNode(IntrinsifyMethodHandlesInvocationPlugin.this.lookup(oNew.elementType()), this.b.maybeEmitExplicitNegativeArraySizeCheck(this.node((Node)oNew.length())), oNew.fillContents()));
                this.transplanted.put((Node)oNew, (Object)tNew);
                return true;
            }
            if (oNode.getClass() == FinalFieldBarrierNode.class) {
                FinalFieldBarrierNode oNew = (FinalFieldBarrierNode)oNode;
                FinalFieldBarrierNode tNew = (FinalFieldBarrierNode)this.b.add((Node)new FinalFieldBarrierNode(this.node((Node)oNew.getValue())));
                this.transplanted.put((Node)oNew, (Object)tNew);
                return true;
            }
            if (oNode.getClass() == DirectMethodHandleEnsureInitializedNode.class) {
                DirectMethodHandleEnsureInitializedNode oInit = (DirectMethodHandleEnsureInitializedNode)oNode;
                ResolvedJavaType tInstanceClass = IntrinsifyMethodHandlesInvocationPlugin.this.lookup(oInit.instanceClass());
                IntrinsifyMethodHandlesInvocationPlugin.this.maybeEmitClassInitialization((GraphBuilderContext)this.b, true, tInstanceClass);
                return true;
            }
            return false;
        }

        private ValueNode[] nodes(List<ValueNode> oNodes) throws AbortTransplantException {
            ValueNode[] tNodes = new ValueNode[oNodes.size()];
            for (int i = 0; i < tNodes.length; ++i) {
                tNodes[i] = this.node((Node)oNodes.get(i));
            }
            return tNodes;
        }

        private ValueNode node(Node oNode) throws AbortTransplantException {
            if (oNode == null) {
                return null;
            }
            Node tNode = (Node)this.transplanted.get(oNode);
            if (tNode != null) {
                return (ValueNode)tNode;
            }
            if (oNode.getClass() == ConstantNode.class) {
                ConstantNode oConstant = (ConstantNode)oNode;
                tNode = ConstantNode.forConstant((JavaConstant)this.constant(oConstant.getValue()), (MetaAccessProvider)IntrinsifyMethodHandlesInvocationPlugin.this.universeProviders.getMetaAccess());
            } else {
                if (oNode.getClass() == DirectMethodHandleEnsureInitializedNode.class) {
                    return null;
                }
                if (oNode.getClass() == PiNode.class) {
                    PiNode oPi = (PiNode)oNode;
                    tNode = new PiNode(this.node((Node)oPi.object()), this.stamp(oPi.piStamp()), this.node((Node)oPi.getGuard().asNode()));
                } else if (oNode.getClass() == InstanceOfNode.class) {
                    InstanceOfNode oInstanceOf = (InstanceOfNode)oNode;
                    tNode = InstanceOfNode.createHelper((ObjectStamp)this.stamp(oInstanceOf.getCheckedStamp()), (ValueNode)this.node((Node)oInstanceOf.getValue()), (JavaTypeProfile)oInstanceOf.profile(), (AnchoringNode)((AnchoringNode)this.node((Node)((ValueNode)oInstanceOf.getAnchor()))));
                } else if (oNode.getClass() == IsNullNode.class) {
                    IsNullNode oIsNull = (IsNullNode)oNode;
                    tNode = IsNullNode.create((ValueNode)this.node((Node)oIsNull.getValue()));
                } else if (oNode instanceof ArithmeticOperation) {
                    for (Node input : oNode.inputs()) {
                        this.node(input);
                    }
                    List<Node> oNodes = Collections.singletonList(oNode);
                    EconomicMap tNodes = this.b.getGraph().addDuplicates(oNodes, oNode.graph(), 1, this.transplanted);
                    assert (StreamSupport.stream(tNodes.getKeys().spliterator(), false).count() == 1L);
                    tNode = (Node)tNodes.get((Object)oNode);
                } else {
                    throw this.bailout();
                }
            }
            tNode = this.b.add((Node)((ValueNode)tNode));
            assert (tNode.verify());
            this.transplanted.put(oNode, (Object)tNode);
            return (ValueNode)tNode;
        }

        private void transplantInvoke(InvokeNode oNode, ResolvedJavaMethod tTargetMethod, CallTargetNode.InvokeKind invokeKind, ValueNode[] arguments, JavaKind invokeResultKind) {
            IntrinsifyMethodHandlesInvocationPlugin.this.maybeEmitClassInitialization((GraphBuilderContext)this.b, invokeKind == CallTargetNode.InvokeKind.Static, tTargetMethod.getDeclaringClass());
            if (invokeResultKind == JavaKind.Void) {
                InvokeNode pred = oNode;
                while ((pred = pred.predecessor()).getClass() == FixedGuardNode.class) {
                }
                if (pred.getClass() == NewInstanceNode.class && this.transplanted.containsKey((Node)pred)) {
                    Node tNew = (Node)this.transplanted.get((Node)pred);
                    this.pushToFrameStack((ValueNode)tNew);
                }
            }
            this.b.handleReplacedInvoke(invokeKind, tTargetMethod, arguments, false, IntrinsifyMethodHandlesInvocationPlugin.this.lookup(oNode.callTarget().referencedType()));
            if (invokeResultKind != JavaKind.Void) {
                this.transplanted.put((Node)oNode, (Object)this.b.pop(invokeResultKind));
            } else {
                this.popTempFrameStackValue();
            }
        }

        private <T extends Stamp> T stamp(T oStamp) throws AbortTransplantException {
            Object result;
            if (oStamp.getClass() == ObjectStamp.class) {
                ObjectStamp oObjectStamp = (ObjectStamp)oStamp;
                result = new ObjectStamp(IntrinsifyMethodHandlesInvocationPlugin.this.lookup(oObjectStamp.type()), oObjectStamp.isExactType(), oObjectStamp.nonNull(), oObjectStamp.alwaysNull(), oObjectStamp.isAlwaysArray());
            } else if (oStamp instanceof PrimitiveStamp) {
                result = oStamp;
            } else {
                throw this.bailout();
            }
            assert (oStamp.getClass() == result.getClass());
            return result;
        }

        private JavaConstant constant(Constant oConstant) throws AbortTransplantException {
            Object oldObject;
            Object newObject;
            if (oConstant == JavaConstant.NULL_POINTER) {
                return JavaConstant.NULL_POINTER;
            }
            if (!(oConstant instanceof JavaConstant)) {
                throw this.bailout();
            }
            JavaConstant tConstant = IntrinsifyMethodHandlesInvocationPlugin.this.lookup((JavaConstant)oConstant);
            if (tConstant.getJavaKind() == JavaKind.Object && (newObject = IntrinsifyMethodHandlesInvocationPlugin.this.aUniverse.replaceObject(oldObject = IntrinsifyMethodHandlesInvocationPlugin.this.aUniverse.getSnippetReflection().asObject(Object.class, tConstant))) != oldObject) {
                return IntrinsifyMethodHandlesInvocationPlugin.this.aUniverse.getSnippetReflection().forObject(newObject);
            }
            return tConstant;
        }

        private RuntimeException bailout() throws AbortTransplantException {
            boolean handled = false;
            throw new AbortTransplantException(handled);
        }
    }

    static class AbortTransplantException
    extends Exception {
        private final boolean handled;

        AbortTransplantException(boolean handled) {
            this.handled = handled;
        }
    }
}

