/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.NativeImageClassLoaderOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.ClasspathUtils;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageClassLoader;
import com.oracle.svm.hosted.NativeImageGeneratorRunner;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtractor;
import com.oracle.svm.hosted.option.HostedOptionParser;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.File;
import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.FindException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.internal.module.Modules;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.nativeimage.impl.AnnotationExtractor;

public class NativeImageClassLoaderSupport {
    private final List<Path> imagecp;
    private final List<Path> buildcp;
    private final List<Path> imagemp;
    private final List<Path> buildmp;
    private final EconomicMap<URI, EconomicSet<String>> classes = EconomicMap.create();
    private final EconomicMap<URI, EconomicSet<String>> packages = EconomicMap.create();
    private final EconomicSet<String> emptySet = EconomicSet.create();
    private final EconomicSet<URI> builderURILocations = EconomicSet.create();
    private final ConcurrentHashMap<String, LinkedHashSet<String>> serviceProviders = new ConcurrentHashMap();
    private final NativeImageClassLoader classLoader;
    public final ModuleFinder upgradeAndSystemModuleFinder;
    public final ModuleLayer moduleLayerForImageBuild;
    public final ModuleFinder modulepathModuleFinder;
    public final AnnotationExtractor annotationExtractor;
    private HostedOptionParser hostedOptionParser;
    private OptionValues parsedHostedOptions;
    private List<String> remainingArguments;

    protected NativeImageClassLoaderSupport(ClassLoader defaultSystemClassLoader, String[] classpath, String[] modulePath) {
        String[] builderClassPathEntries;
        this.imagecp = Arrays.stream(classpath).map(x$0 -> Path.of(x$0, new String[0])).flatMap(NativeImageClassLoaderSupport::toRealPath).collect(Collectors.toUnmodifiableList());
        String builderClassPathString = System.getProperty("java.class.path");
        String[] stringArray = builderClassPathEntries = builderClassPathString.isEmpty() ? new String[]{} : builderClassPathString.split(File.pathSeparator);
        if (Arrays.asList(builderClassPathEntries).contains(".")) {
            VMError.shouldNotReachHere("The classpath of " + NativeImageGeneratorRunner.class.getName() + " must not contain \".\". This can happen implicitly if the builder runs exclusively on the --module-path but specifies the " + NativeImageGeneratorRunner.class.getName() + " main class without --module.");
        }
        this.buildcp = Arrays.stream(builderClassPathEntries).map(x$0 -> Path.of(x$0, new String[0])).flatMap(NativeImageClassLoaderSupport::toRealPath).collect(Collectors.toUnmodifiableList());
        this.buildcp.stream().map(Path::toUri).forEach(arg_0 -> this.builderURILocations.add(arg_0));
        this.imagemp = Arrays.stream(modulePath).map(x$0 -> Path.of(x$0, new String[0])).flatMap(NativeImageClassLoaderSupport::toRealPath).collect(Collectors.toUnmodifiableList());
        this.buildmp = Optional.ofNullable(System.getProperty("jdk.module.path")).stream().flatMap(s -> Arrays.stream(s.split(File.pathSeparator))).map(x$0 -> Path.of(x$0, new String[0])).flatMap(NativeImageClassLoaderSupport::toRealPath).collect(Collectors.toUnmodifiableList());
        this.upgradeAndSystemModuleFinder = NativeImageClassLoaderSupport.createUpgradeAndSystemModuleFinder();
        ModuleFinder modulePathsFinder = ModuleFinder.of((Path[])this.imagemp.toArray(Path[]::new));
        Set<String> moduleNames = modulePathsFinder.findAll().stream().map(moduleReference -> moduleReference.descriptor().name()).collect(Collectors.toSet());
        Configuration configuration = ModuleLayer.boot().configuration().resolve(modulePathsFinder, this.upgradeAndSystemModuleFinder, moduleNames);
        this.classLoader = new NativeImageClassLoader(this.imagecp, configuration, defaultSystemClassLoader);
        ModuleLayer moduleLayer = ModuleLayer.defineModules(configuration, List.of(ModuleLayer.boot()), ignored -> this.classLoader).layer();
        NativeImageClassLoaderSupport.adjustBootLayerQualifiedExports(moduleLayer);
        this.moduleLayerForImageBuild = moduleLayer;
        NativeImageClassLoaderSupport.allLayers(this.moduleLayerForImageBuild).stream().flatMap(layer -> layer.modules().stream()).forEach(this::registerModulePathServiceProviders);
        this.modulepathModuleFinder = ModuleFinder.of((Path[])this.modulepath().toArray(Path[]::new));
        this.annotationExtractor = new SubstrateAnnotationExtractor();
    }

    private static Stream<Path> toRealPath(Path p) {
        try {
            return Stream.of(p.toRealPath(new LinkOption[0]));
        }
        catch (IOException e) {
            return Stream.empty();
        }
    }

    List<Path> classpath() {
        return Stream.concat(this.imagecp.stream(), this.buildcp.stream()).distinct().collect(Collectors.toList());
    }

    List<Path> applicationClassPath() {
        return this.imagecp;
    }

    public NativeImageClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void loadAllClasses(ForkJoinPool executor, ImageClassLoader imageClassLoader) {
        new LoadClassHandler(executor, imageClassLoader).run();
    }

    public void setupHostedOptionParser(List<String> arguments) {
        this.hostedOptionParser = new HostedOptionParser(this.getClassLoader(), arguments);
        this.remainingArguments = Collections.unmodifiableList(this.hostedOptionParser.parse());
        this.parsedHostedOptions = new OptionValues(this.hostedOptionParser.getHostedValues());
    }

    public HostedOptionParser getHostedOptionParser() {
        return this.hostedOptionParser;
    }

    public List<String> getRemainingArguments() {
        return this.remainingArguments;
    }

    public OptionValues getParsedHostedOptions() {
        return this.parsedHostedOptions;
    }

    public EconomicSet<String> classes(URI container) {
        return (EconomicSet)this.classes.get((Object)container, this.emptySet);
    }

    public EconomicSet<String> packages(URI container) {
        return (EconomicSet)this.packages.get((Object)container, this.emptySet);
    }

    public boolean noEntryForURI(EconomicSet<String> set) {
        return set == this.emptySet;
    }

    private static ModuleFinder createUpgradeAndSystemModuleFinder() {
        ModuleFinder finder = ModuleFinder.ofSystem();
        ModuleFinder upgradeModulePath = NativeImageClassLoaderSupport.finderFor("jdk.module.upgrade.path");
        if (upgradeModulePath != null) {
            finder = ModuleFinder.compose(upgradeModulePath, finder);
        }
        return finder;
    }

    static ModuleFinder finderFor(String prop) {
        String s = System.getProperty(prop);
        if (s == null || s.isEmpty()) {
            return null;
        }
        String[] dirs = s.split(File.pathSeparator);
        Path[] paths = new Path[dirs.length];
        int i = 0;
        for (String dir : dirs) {
            paths[i++] = Path.of(dir, new String[0]);
        }
        return ModuleFinder.of(paths);
    }

    private static void adjustBootLayerQualifiedExports(ModuleLayer layer) {
        for (Module module : ModuleLayer.boot().modules()) {
            for (ModuleDescriptor.Exports export : module.getDescriptor().exports()) {
                for (String target : export.targets()) {
                    Optional<Module> optExportTargetModule = layer.findModule(target);
                    if (optExportTargetModule.isEmpty()) continue;
                    Module exportTargetModule = optExportTargetModule.get();
                    if (module.isExported(export.source(), exportTargetModule)) continue;
                    Modules.addExports(module, export.source(), exportTargetModule);
                }
            }
        }
    }

    private void registerModulePathServiceProviders(Module module) {
        ModuleDescriptor descriptor = module.getDescriptor();
        for (ModuleDescriptor.Provides provides : descriptor.provides()) {
            this.serviceProviders(provides.service()).addAll(provides.providers());
        }
    }

    private LinkedHashSet<String> serviceProviders(String serviceName) {
        return this.serviceProviders.computeIfAbsent(serviceName, unused -> new LinkedHashSet());
    }

    void serviceProvidersForEach(BiConsumer<String, Collection<String>> action) {
        this.serviceProviders.forEach((key, val) -> action.accept((String)key, Collections.unmodifiableCollection(val)));
    }

    private static void implAddReadsAllUnnamed(Module module) {
        try {
            Method implAddReadsAllUnnamed = Module.class.getDeclaredMethod("implAddReadsAllUnnamed", new Class[0]);
            ModuleSupport.accessModuleByClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, NativeImageClassLoaderSupport.class, Module.class);
            implAddReadsAllUnnamed.setAccessible(true);
            implAddReadsAllUnnamed.invoke((Object)module, new Object[0]);
        }
        catch (ReflectiveOperationException | NoSuchElementException e) {
            VMError.shouldNotReachHere("Could reflectively call Module.implAddReadsAllUnnamed", e);
        }
    }

    protected List<Path> modulepath() {
        return Stream.concat(this.imagemp.stream(), this.buildmp.stream()).toList();
    }

    protected List<Path> applicationModulePath() {
        return this.imagemp;
    }

    public Optional<Module> findModule(String moduleName) {
        return this.moduleLayerForImageBuild.findModule(moduleName);
    }

    void processClassLoaderOptions() {
        if (((Boolean)NativeImageClassLoaderOptions.ListModules.getValue(this.parsedHostedOptions)).booleanValue()) {
            NativeImageClassLoaderSupport.processListModulesOption(this.moduleLayerForImageBuild);
        }
        this.processOption(NativeImageClassLoaderOptions.AddExports).forEach(val -> {
            if (val.module.getPackages().contains(val.packageName)) {
                if (val.targetModules.isEmpty()) {
                    Modules.addExportsToAllUnnamed(val.module, val.packageName);
                } else {
                    for (Module targetModule : val.targetModules) {
                        Modules.addExports(val.module, val.packageName, targetModule);
                    }
                }
            } else {
                NativeImageClassLoaderSupport.warn("package " + val.packageName + " not in " + val.module.getName());
            }
        });
        this.processOption(NativeImageClassLoaderOptions.AddOpens).forEach(val -> {
            if (val.module.getPackages().contains(val.packageName)) {
                if (val.targetModules.isEmpty()) {
                    Modules.addOpensToAllUnnamed(val.module, val.packageName);
                } else {
                    for (Module targetModule : val.targetModules) {
                        Modules.addOpens(val.module, val.packageName, targetModule);
                    }
                }
            } else {
                NativeImageClassLoaderSupport.warn("package " + val.packageName + " not in " + val.module.getName());
            }
        });
        this.processOption(NativeImageClassLoaderOptions.AddReads).forEach(val -> {
            if (val.targetModules.isEmpty()) {
                NativeImageClassLoaderSupport.implAddReadsAllUnnamed(val.module);
            } else {
                for (Module targetModule : val.targetModules) {
                    Modules.addReads(val.module, targetModule);
                }
            }
        });
    }

    private static void warn(String m) {
        LogUtils.warning((String)"WARNING", (String)m, (boolean)true);
    }

    private static void processListModulesOption(ModuleLayer layer) {
        Class launcherHelperClass = ReflectionUtil.lookupClass((boolean)false, (String)"sun.launcher.LauncherHelper");
        Method initOutputMethod = ReflectionUtil.lookupMethod((Class)launcherHelperClass, (String)"initOutput", (Class[])new Class[]{Boolean.TYPE});
        Method showModuleMethod = ReflectionUtil.lookupMethod((Class)launcherHelperClass, (String)"showModule", (Class[])new Class[]{ModuleReference.class});
        boolean first = true;
        for (ModuleLayer moduleLayer : NativeImageClassLoaderSupport.allLayers(layer)) {
            List<ResolvedModule> resolvedModules = moduleLayer.configuration().modules().stream().sorted(Comparator.comparing(ResolvedModule::name)).toList();
            if (first) {
                try {
                    initOutputMethod.invoke(null, false);
                }
                catch (ReflectiveOperationException e) {
                    throw VMError.shouldNotReachHere("Unable to use " + initOutputMethod + " to set printing with " + showModuleMethod + " to System.out.", e);
                }
                first = false;
            } else if (!resolvedModules.isEmpty()) {
                System.out.println();
            }
            for (ResolvedModule resolvedModule : resolvedModules) {
                try {
                    showModuleMethod.invoke(null, resolvedModule.reference());
                }
                catch (ReflectiveOperationException e) {
                    throw VMError.shouldNotReachHere("Unable to use " + showModuleMethod + " for printing list of modules.", e);
                }
            }
        }
        throw new InterruptImageBuilding("");
    }

    public void propagateQualifiedExports(String fromTargetModule, String toTargetModule) {
        Optional<Module> optFromTarget = this.moduleLayerForImageBuild.findModule(fromTargetModule);
        Optional<Module> optToTarget = this.moduleLayerForImageBuild.findModule(toTargetModule);
        VMError.guarantee(optFromTarget.isPresent() && optToTarget.isPresent());
        Module toTarget = optToTarget.get();
        Module fromTarget = optFromTarget.get();
        NativeImageClassLoaderSupport.allLayers(this.moduleLayerForImageBuild).stream().flatMap(layer -> layer.modules().stream()).forEach(m -> {
            if (!m.equals(toTarget)) {
                for (String p : m.getPackages()) {
                    if (m.isExported(p, fromTarget)) {
                        Modules.addExports(m, p, toTarget);
                    }
                    if (!m.isOpen(p, fromTarget)) continue;
                    Modules.addOpens(m, p, toTarget);
                }
            }
        });
    }

    public static List<ModuleLayer> allLayers(ModuleLayer moduleLayer) {
        ArrayList<ModuleLayer> allLayers = new ArrayList<ModuleLayer>();
        HashSet<ModuleLayer> visited = new HashSet<ModuleLayer>();
        ArrayDeque<ModuleLayer> stack = new ArrayDeque<ModuleLayer>();
        visited.add(moduleLayer);
        stack.push(moduleLayer);
        while (!stack.isEmpty()) {
            ModuleLayer layer = (ModuleLayer)stack.pop();
            allLayers.add(layer);
            for (int i = layer.parents().size() - 1; i >= 0; --i) {
                ModuleLayer parent = layer.parents().get(i);
                if (visited.contains(parent)) continue;
                visited.add(parent);
                stack.push(parent);
            }
        }
        return allLayers;
    }

    private Stream<AddExportsAndOpensAndReadsFormatValue> processOption(OptionKey<LocatableMultiOptionValue.Strings> specificOption) {
        Stream<Pair<Pair, OptionOrigin>> valuesWithOrigins = ((LocatableMultiOptionValue.Strings)specificOption.getValue(this.parsedHostedOptions)).getValuesWithOrigins();
        Stream<AddExportsAndOpensAndReadsFormatValue> parsedOptions = valuesWithOrigins.flatMap(valWithOrig -> {
            try {
                return Stream.of(this.asAddExportsAndOpensAndReadsFormatValue(specificOption, (Pair<String, OptionOrigin>)valWithOrig));
            }
            catch (FindException e) {
                LogUtils.warning((String)"WARNING", (String)e.getMessage(), (boolean)true);
                return Stream.empty();
            }
        });
        return parsedOptions;
    }

    private AddExportsAndOpensAndReadsFormatValue asAddExportsAndOpensAndReadsFormatValue(OptionKey<?> option, Pair<String, OptionOrigin> valueOrigin) {
        String packageName;
        String moduleName;
        OptionOrigin optionOrigin = (OptionOrigin)valueOrigin.getRight();
        String optionValue = (String)valueOrigin.getLeft();
        boolean reads = option.equals(NativeImageClassLoaderOptions.AddReads);
        String format = reads ? "<module>=<target-module>(,<target-module>)*" : "<module>/<package>=<target-module>(,<target-module>)*";
        String syntaxErrorMessage = " Allowed value format: " + format;
        int equalsPos = optionValue.indexOf("=");
        if (equalsPos <= 0) {
            throw NativeImageClassLoaderSupport.userErrorAddExportsAndOpensAndReads(option, optionOrigin, optionValue, syntaxErrorMessage);
        }
        String modulePackage = optionValue.substring(0, equalsPos);
        String targetModuleNames = optionValue.substring(equalsPos + 1);
        if (targetModuleNames.isEmpty()) {
            throw NativeImageClassLoaderSupport.userErrorAddExportsAndOpensAndReads(option, optionOrigin, optionValue, syntaxErrorMessage);
        }
        ArrayList<String> targetModuleNamesList = new ArrayList<String>();
        for (String s : targetModuleNames.split(",")) {
            if (s.isEmpty()) continue;
            targetModuleNamesList.add(s);
        }
        if (targetModuleNamesList.isEmpty()) {
            throw NativeImageClassLoaderSupport.userErrorAddExportsAndOpensAndReads(option, optionOrigin, optionValue, syntaxErrorMessage);
        }
        if (reads) {
            moduleName = modulePackage;
            packageName = null;
        } else {
            String[] moduleAndPackage = modulePackage.split("/");
            if (moduleAndPackage.length != 2) {
                throw NativeImageClassLoaderSupport.userErrorAddExportsAndOpensAndReads(option, optionOrigin, optionValue, syntaxErrorMessage);
            }
            moduleName = moduleAndPackage[0];
            packageName = moduleAndPackage[1];
            if (moduleName.isEmpty() || packageName.isEmpty()) {
                throw NativeImageClassLoaderSupport.userErrorAddExportsAndOpensAndReads(option, optionOrigin, optionValue, syntaxErrorMessage);
            }
        }
        Module module = this.findModule(moduleName).orElseThrow(() -> {
            throw NativeImageClassLoaderSupport.userWarningModuleNotFound(option, moduleName);
        });
        List<Module> targetModules = targetModuleNamesList.contains("ALL-UNNAMED") ? Collections.emptyList() : targetModuleNamesList.stream().map(mn -> this.findModule((String)mn).orElseThrow(() -> {
            throw NativeImageClassLoaderSupport.userWarningModuleNotFound(option, mn);
        })).collect(Collectors.toList());
        return new AddExportsAndOpensAndReadsFormatValue(module, packageName, targetModules);
    }

    private static UserError.UserException userErrorAddExportsAndOpensAndReads(OptionKey<?> option, OptionOrigin origin, String value, String detailMessage) {
        Objects.requireNonNull(detailMessage, "missing detailMessage");
        return UserError.abort("Invalid option %s provided by %s.%s", SubstrateOptionsParser.commandArgument(option, value), origin, detailMessage);
    }

    private static FindException userWarningModuleNotFound(OptionKey<?> option, String moduleName) {
        String optionName = SubstrateOptionsParser.commandArgument(option, "");
        return new FindException("Unknown module: " + moduleName + " specified to " + optionName);
    }

    Class<?> loadClassFromModule(Module module, String className) {
        assert (NativeImageClassLoaderSupport.isModuleClassLoader(this.classLoader, module.getClassLoader())) : "Argument `module` is java.lang.Module from unknown ClassLoader";
        return Class.forName(module, className);
    }

    private static boolean isModuleClassLoader(ClassLoader loader, ClassLoader moduleClassLoader) {
        if (moduleClassLoader == loader) {
            return true;
        }
        if (loader == null) {
            return false;
        }
        return NativeImageClassLoaderSupport.isModuleClassLoader(loader.getParent(), moduleClassLoader);
    }

    Optional<String> getMainClassFromModule(Object module) {
        assert (module instanceof Module) : "Argument `module` is not an instance of java.lang.Module";
        return ((Module)module).getDescriptor().mainClass();
    }

    public void reportBuilderClassesInApplication() {
        EconomicMap builderClasses = EconomicMap.create();
        EconomicMap applicationClasses = EconomicMap.create();
        MapCursor classesEntries = this.classes.getEntries();
        while (classesEntries.advance()) {
            EconomicMap destinationMap = this.builderURILocations.contains((Object)((URI)classesEntries.getKey())) ? builderClasses : applicationClasses;
            destinationMap.put((Object)((URI)classesEntries.getKey()), (Object)((EconomicSet)classesEntries.getValue()));
        }
        boolean tolerateViolations = (Boolean)SubstrateOptions.AllowDeprecatedBuilderClassesOnImageClasspath.getValue(this.parsedHostedOptions);
        MapCursor applicationClassesEntries = applicationClasses.getEntries();
        while (applicationClassesEntries.advance()) {
            URI applicationClassContainer = (URI)applicationClassesEntries.getKey();
            for (String applicationClass : (EconomicSet)applicationClassesEntries.getValue()) {
                MapCursor builderClassesEntries = builderClasses.getEntries();
                while (builderClassesEntries.advance()) {
                    URI builderClassContainer = (URI)builderClassesEntries.getKey();
                    if (!((EconomicSet)builderClassesEntries.getValue()).contains((Object)applicationClass)) continue;
                    String message = String.format("Class-path entry %s contains class %s. This class is part of the image builder itself (in %s) and must not be passed via -cp.", applicationClassContainer, applicationClass, builderClassContainer);
                    if (!tolerateViolations) {
                        String errorMessage = String.join((CharSequence)" ", message, "This can be caused by a fat-jar that illegally includes svm.jar (or graal-sdk.jar) due to its build-time dependency on it.", "As a workaround, %s allows turning this error into a warning. Note that this option is deprecated and will be removed in a future version.");
                        throw UserError.abort(errorMessage, SubstrateOptionsParser.commandArgument(SubstrateOptions.AllowDeprecatedBuilderClassesOnImageClasspath, "+"));
                    }
                    LogUtils.warning((String)message);
                }
            }
        }
    }

    private final class LoadClassHandler {
        private final ForkJoinPool executor;
        private final ImageClassLoader imageClassLoader;
        LongAdder entriesProcessed;
        volatile String currentlyProcessedEntry;
        boolean initialReport;
        private static final String CLASS_EXTENSION = ".class";
        private static final String SERVICE_PREFIX = "META-INF/services/";
        private static final String SERVICE_PREFIX_VARIANT = File.separatorChar == '/' ? null : "META-INF/services/".replace('/', File.separatorChar);

        private LoadClassHandler(ForkJoinPool executor, ImageClassLoader imageClassLoader) {
            this.executor = executor;
            this.imageClassLoader = imageClassLoader;
            this.entriesProcessed = new LongAdder();
            this.currentlyProcessedEntry = "Unknown Entry";
            this.initialReport = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run() {
            ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            try {
                scheduledExecutor.scheduleAtFixedRate(() -> {
                    if (this.initialReport) {
                        this.initialReport = false;
                        System.out.println("Loading classes is taking a long time. This can be caused by class- or module-path entries that point to large directory structures.");
                    }
                    System.out.println("Total processed entries: " + this.entriesProcessed.longValue() + ", current entry: " + this.currentlyProcessedEntry);
                }, 5L, 1L, TimeUnit.MINUTES);
                List<String> requiresInit = Arrays.asList("jdk.internal.vm.ci", "jdk.internal.vm.compiler", "com.oracle.graal.graal_enterprise", "org.graalvm.nativeimage", "org.graalvm.truffle", "org.graalvm.truffle.runtime", "org.graalvm.truffle.compiler", "com.oracle.truffle.enterprise", "org.graalvm.jniutils", "org.graalvm.nativebridge");
                for (ModuleReference moduleReference : NativeImageClassLoaderSupport.this.upgradeAndSystemModuleFinder.findAll()) {
                    if (!requiresInit.contains(moduleReference.descriptor().name())) continue;
                    this.initModule(moduleReference);
                }
                for (ModuleReference moduleReference : NativeImageClassLoaderSupport.this.modulepathModuleFinder.findAll()) {
                    this.initModule(moduleReference);
                }
                NativeImageClassLoaderSupport.this.classpath().forEach(this::loadClassesFromPath);
            }
            finally {
                scheduledExecutor.shutdown();
            }
        }

        private void initModule(ModuleReference moduleReference) {
            String moduleReferenceLocation;
            this.currentlyProcessedEntry = moduleReferenceLocation = moduleReference.location().map(URI::toString).orElse("UnknownModuleReferenceLocation");
            Optional<Module> optionalModule = NativeImageClassLoaderSupport.this.findModule(moduleReference.descriptor().name());
            if (optionalModule.isEmpty()) {
                return;
            }
            try (ModuleReader moduleReader = moduleReference.open();){
                Module module = optionalModule.get();
                URI container = moduleReference.location().orElseThrow();
                if (ModuleLayer.boot().equals(module.getLayer())) {
                    NativeImageClassLoaderSupport.this.builderURILocations.add((Object)container);
                }
                moduleReader.list().forEach(moduleResource -> {
                    char fileSystemSeparatorChar = '/';
                    String className = this.extractClassName((String)moduleResource, fileSystemSeparatorChar);
                    if (className != null) {
                        this.currentlyProcessedEntry = moduleReferenceLocation + fileSystemSeparatorChar + moduleResource;
                        this.executor.execute(() -> this.handleClassFileName(container, module, className));
                    }
                    this.entriesProcessed.increment();
                });
            }
            catch (IOException e) {
                throw new RuntimeException("Unable get list of resources in module" + moduleReference.descriptor().name(), e);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void loadClassesFromPath(Path path) {
            if (ClasspathUtils.isJar(path)) {
                try {
                    FileSystem probeJarFileSystem;
                    URI container = path.toAbsolutePath().toUri();
                    URI jarURI = new URI("jar:" + container);
                    try {
                        probeJarFileSystem = FileSystems.newFileSystem(jarURI, Collections.emptyMap());
                    }
                    catch (UnsupportedOperationException e) {
                        return;
                    }
                    if (probeJarFileSystem == null) return;
                    try (FileSystem jarFileSystem = probeJarFileSystem;){
                        this.loadClassesFromPath(container, jarFileSystem.getPath("/", new String[0]), null, Collections.emptySet());
                        return;
                    }
                }
                catch (ClosedByInterruptException ignored) {
                    throw new InterruptImageBuilding();
                }
                catch (IOException | URISyntaxException e) {
                    throw VMError.shouldNotReachHere(e);
                }
            }
            URI container = path.toUri();
            this.loadClassesFromPath(container, path, ClassUtil.CLASS_MODULE_PATH_EXCLUDE_DIRECTORIES_ROOT, ClassUtil.CLASS_MODULE_PATH_EXCLUDE_DIRECTORIES);
        }

        private void loadClassesFromPath(final URI container, final Path root, Path excludeRoot, final Set<Path> excludes) {
            final boolean useFilter = root.equals(excludeRoot);
            if (useFilter) {
                String excludesStr = excludes.stream().map(Path::toString).collect(Collectors.joining(", "));
                LogUtils.warning((String)"Using directory %s on classpath is discouraged. Reading classes/resources from directories %s will be suppressed.", (Object[])new Object[]{excludeRoot, excludesStr});
            }
            SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){
                private final char fileSystemSeparatorChar;
                {
                    this.fileSystemSeparatorChar = root.getFileSystem().getSeparator().charAt(0);
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    LoadClassHandler.this.currentlyProcessedEntry = dir.toUri().toString();
                    if (useFilter && excludes.contains(dir)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return super.preVisitDirectory(dir, attrs);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    assert (!excludes.contains(file.getParent())) : "Visiting file '" + file + "' with excluded parent directory";
                    String fileName = root.relativize(file).toString();
                    LoadClassHandler.this.registerClassPathServiceProviders(fileName, file);
                    String className = LoadClassHandler.this.extractClassName(fileName, this.fileSystemSeparatorChar);
                    if (className != null) {
                        LoadClassHandler.this.currentlyProcessedEntry = file.toUri().toString();
                        LoadClassHandler.this.executor.execute(() -> LoadClassHandler.this.handleClassFileName(container, null, className));
                    }
                    LoadClassHandler.this.entriesProcessed.increment();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            };
            try {
                Files.walkFileTree(root, (FileVisitor<? super Path>)visitor);
            }
            catch (IOException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerClassPathServiceProviders(String fileName, Path serviceRegistrationFile) {
            boolean found;
            boolean bl = found = fileName.startsWith(SERVICE_PREFIX) || SERVICE_PREFIX_VARIANT != null && fileName.startsWith(SERVICE_PREFIX_VARIANT);
            if (!found) {
                return;
            }
            Path serviceFileName = serviceRegistrationFile.getFileName();
            if (serviceFileName == null) {
                return;
            }
            String serviceName = serviceFileName.toString();
            if (!serviceName.isEmpty()) {
                ArrayList providerNames = new ArrayList();
                try (Stream<String> serviceConfig = Files.lines(serviceRegistrationFile);){
                    serviceConfig.forEach(ln -> {
                        int ci = ln.indexOf(35);
                        String providerName = (ci >= 0 ? ln.substring(0, ci) : ln).trim();
                        if (!providerName.isEmpty()) {
                            providerNames.add(providerName);
                        }
                    });
                }
                catch (Exception e) {
                    LogUtils.warning((String)("Image builder cannot read service configuration file " + fileName));
                }
                if (!providerNames.isEmpty()) {
                    LinkedHashSet<String> providersForService;
                    LinkedHashSet<String> linkedHashSet = providersForService = NativeImageClassLoaderSupport.this.serviceProviders(serviceName);
                    synchronized (linkedHashSet) {
                        providersForService.addAll(providerNames);
                    }
                }
            }
        }

        private String extractClassName(String fileName, char fileSystemSeparatorChar) {
            String strippedClassFileName;
            int versionedSuffixIndex;
            if (!fileName.endsWith(CLASS_EXTENSION)) {
                return null;
            }
            String versionedPrefix = "META-INF/versions/";
            String versionedSuffix = "/";
            String result = fileName;
            if (fileName.startsWith(versionedPrefix) && (versionedSuffixIndex = fileName.indexOf(versionedSuffix, versionedPrefix.length())) >= 0) {
                result = fileName.substring(versionedSuffixIndex + versionedSuffix.length());
            }
            return (strippedClassFileName = result.substring(0, result.length() - CLASS_EXTENSION.length())).equals("module-info") ? null : strippedClassFileName.replace(fileSystemSeparatorChar, '.');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleClassFileName(URI container, Module module, String className) {
            EconomicMap<URI, EconomicSet<String>> economicMap = NativeImageClassLoaderSupport.this.classes;
            synchronized (economicMap) {
                EconomicSet classNames = (EconomicSet)NativeImageClassLoaderSupport.this.classes.get((Object)container);
                if (classNames == null) {
                    classNames = EconomicSet.create();
                    NativeImageClassLoaderSupport.this.classes.put((Object)container, (Object)classNames);
                }
                classNames.add((Object)className);
            }
            int packageSep = className.lastIndexOf(46);
            String packageName = packageSep > 0 ? className.substring(0, packageSep) : "";
            EconomicMap<URI, EconomicSet<String>> economicMap2 = NativeImageClassLoaderSupport.this.packages;
            synchronized (economicMap2) {
                EconomicSet packageNames = (EconomicSet)NativeImageClassLoaderSupport.this.packages.get((Object)container);
                if (packageNames == null) {
                    packageNames = EconomicSet.create();
                    NativeImageClassLoaderSupport.this.packages.put((Object)container, (Object)packageNames);
                }
                packageNames.add((Object)packageName);
            }
            Class<?> clazz = null;
            try {
                clazz = this.imageClassLoader.forName(className, module);
            }
            catch (AssertionError error) {
                VMError.shouldNotReachHere((Throwable)((Object)error));
            }
            catch (Throwable t) {
                ImageClassLoader.handleClassLoadingError(t);
            }
            if (clazz != null) {
                this.imageClassLoader.handleClass(clazz);
            }
        }
    }

    private record AddExportsAndOpensAndReadsFormatValue(Module module, String packageName, List<Module> targetModules) {
    }
}

