/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.SubstrateControlFlowIntegrityFeature;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.thread.Continuation;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.thread.LoomVirtualThreads;
import com.oracle.svm.core.thread.VirtualThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.List;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.impl.InternalPlatform;

@AutomaticallyRegisteredFeature
public class ContinuationsFeature
implements InternalFeature {
    private boolean finishedRegistration = false;

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(SubstrateControlFlowIntegrityFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        int firstLoomPreviewVersion = 19;
        int lastLoomPreviewVersion = 20;
        boolean supportLoom = false;
        if (JavaVersionUtil.JAVA_SPEC >= 19) {
            boolean haveLoom;
            if (JavaVersionUtil.JAVA_SPEC > 20 && Platform.includedIn(InternalPlatform.NATIVE_ONLY.class)) {
                haveLoom = true;
            } else {
                try {
                    haveLoom = (Boolean)Class.forName("jdk.internal.misc.PreviewFeatures").getDeclaredMethod("isEnabled", new Class[0]).invoke(null, new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw VMError.shouldNotReachHere(e);
                }
                if (!haveLoom) {
                    RuntimeClassInitialization.initializeAtRunTime((String[])new String[]{"jdk.internal.vm.Continuation"});
                }
            }
            boolean bl = supportLoom = haveLoom && !DeoptimizationSupport.enabled() && !SubstrateOptions.useLLVMBackend() && SubstrateControlFlowIntegrity.singleton().continuationsSupported();
        }
        if (supportLoom) {
            LoomVirtualThreads vt = new LoomVirtualThreads();
            ImageSingletons.add(VirtualThreads.class, (Object)vt);
            ImageSingletons.add(LoomVirtualThreads.class, (Object)vt);
        }
        this.finishedRegistration = true;
    }

    boolean hasFinishedRegistration() {
        return this.finishedRegistration;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (Continuation.isSupported()) {
            if (!ImageSingletons.contains(ContinuationSupport.class)) {
                ImageSingletons.add(ContinuationSupport.class, (Object)new ContinuationSupport());
            }
            Field ipField = ReflectionUtil.lookupField(StoredContinuation.class, (String)"ip");
            access.registerAsAccessed(ipField);
            access.registerReachabilityHandler(a -> access.registerAsInHeap(StoredContinuation.class), new Object[]{ReflectionUtil.lookupMethod(StoredContinuationAccess.class, (String)"allocate", (Class[])new Class[]{Integer.TYPE})});
        } else {
            access.registerReachabilityHandler(a -> ContinuationsFeature.abortIfUnsupported(), new Object[]{StoredContinuationAccess.class});
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (Continuation.isSupported()) {
            Field ipField = ReflectionUtil.lookupField(StoredContinuation.class, (String)"ip");
            long offset = access.objectFieldOffset(ipField);
            ContinuationSupport.singleton().setIPOffset(offset);
        }
    }

    static void abortIfUnsupported() {
        VMError.guarantee(Continuation.isSupported(), "Virtual threads internals are reachable but support is not available or active.");
    }
}

