/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.graal.amd64.SubstrateAMD64Backend;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.amd64.AMD64BlockEndOp;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="RETURN")
public class AMD64ReturnOp
extends AMD64BlockEndOp
implements StandardOp.BlockEndOp {
    public static final LIRInstructionClass<AMD64ReturnOp> TYPE = LIRInstructionClass.create(AMD64ReturnOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value x;

    protected AMD64ReturnOp(Value x, LIRInstructionClass<? extends AMD64BlockEndOp> type) {
        super(type);
        this.x = x;
    }

    public AMD64ReturnOp(Value x) {
        this(x, TYPE);
    }

    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        crb.frameContext.leave(crb);
        if (SubstrateAMD64Backend.runtimeToAOTIsAvxSseTransition(crb.target)) {
            masm.vzeroupper();
        }
        this.emitReturn(masm);
        crb.frameContext.returned(crb);
    }

    protected void emitReturn(AMD64MacroAssembler masm) {
        masm.ret(0);
    }
}

