/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.heap.AbstractPinnedObjectSupport;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;

public final class PinnedObjectSupportImpl
extends AbstractPinnedObjectSupport {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PinnedObjectSupportImpl() {
    }

    @Override
    @Uninterruptible(reason="Ensure that pinned object counts and PinnedObjects are consistent.", callerMustBe=true)
    protected void pinObject(Object object) {
        PinnedObjectSupportImpl.modifyPinnedObjectCount(object, 1);
    }

    @Override
    @Uninterruptible(reason="Ensure that pinned object counts and PinnedObjects are consistent.", callerMustBe=true)
    protected void unpinObject(Object object) {
        PinnedObjectSupportImpl.modifyPinnedObjectCount(object, -1);
    }

    @Uninterruptible(reason="Ensure that pinned object counts and PinnedObjects are consistent.", callerMustBe=true)
    private static void modifyPinnedObjectCount(Object object, int delta) {
        int oldValue;
        Pointer pinnedObjectCount = HeapChunk.getEnclosingHeapChunk(object).addressOfPinnedObjectCount();
        while (!pinnedObjectCount.logicCompareAndSwapInt(0, oldValue = pinnedObjectCount.readInt(0), oldValue + delta, NamedLocationIdentity.OFF_HEAP_LOCATION)) {
        }
        assert (oldValue < Integer.MAX_VALUE);
    }
}

