/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.CodeInfoVerifier;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.code.ReferenceAdjuster;
import com.oracle.svm.core.deopt.DeoptEntryInfopoint;
import com.oracle.svm.core.heap.CodeReferenceMapEncoder;
import com.oracle.svm.core.heap.ReferenceMapEncoder;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.core.util.Counter;
import com.oracle.svm.core.util.VMError;
import java.util.TreeMap;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ExceptionHandler;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.util.FrequencyEncoder;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;
import org.graalvm.nativeimage.ImageSingletons;

public class CodeInfoEncoder {
    private final TreeMap<Long, IPData> entries = new TreeMap();
    private final Encoders encoders;
    private final FrameInfoEncoder frameInfoEncoder;
    private NonmovableArray<Byte> codeInfoIndex;
    private NonmovableArray<Byte> codeInfoEncodings;
    private NonmovableArray<Byte> referenceMapEncoding;

    public CodeInfoEncoder(FrameInfoEncoder.Customization frameInfoCustomization, Encoders encoders) {
        this.encoders = encoders;
        this.frameInfoEncoder = new FrameInfoEncoder(frameInfoCustomization, encoders);
    }

    public Encoders getEncoders() {
        return this.encoders;
    }

    public static int getEntryOffset(Infopoint infopoint) {
        if (infopoint instanceof Call || infopoint instanceof DeoptEntryInfopoint) {
            int offset = infopoint.pcOffset;
            if (infopoint instanceof Call) {
                offset += ((Call)infopoint).size;
            }
            return offset;
        }
        return -1;
    }

    public void addMethod(SharedMethod method, CompilationResult compilation, int compilationOffset, int compilationSize) {
        FrameInfoEncoder.FrameData defaultFrameData;
        int totalFrameSize = compilation.getTotalFrameSize();
        boolean isEntryPoint = method.isEntryPoint();
        boolean hasCalleeSavedRegisters = method.hasCalleeSavedRegisters();
        IPData startEntry = this.makeEntry(compilationOffset);
        startEntry.frameData = defaultFrameData = this.frameInfoEncoder.addDefaultDebugInfo(method, totalFrameSize);
        startEntry.frameSizeEncoding = this.encodeFrameSize(totalFrameSize, true, isEntryPoint, hasCalleeSavedRegisters);
        for (long entryIP = CodeInfoDecoder.lookupEntryIP(CodeInfoDecoder.indexGranularity() + (long)compilationOffset); entryIP <= CodeInfoDecoder.lookupEntryIP(compilationSize + compilationOffset - 1); entryIP += CodeInfoDecoder.indexGranularity()) {
            IPData entry = this.makeEntry(entryIP);
            entry.frameData = defaultFrameData;
            entry.frameSizeEncoding = this.encodeFrameSize(totalFrameSize, false, isEntryPoint, hasCalleeSavedRegisters);
        }
        EconomicSet infopointOffsets = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
        EconomicSet deoptEntryBcis = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
        for (Infopoint infopoint : compilation.getInfopoints()) {
            BytecodeFrame frame;
            long encodedBci;
            int offset;
            DebugInfo debugInfo = infopoint.debugInfo;
            if (debugInfo == null || (offset = CodeInfoEncoder.getEntryOffset(infopoint)) < 0) continue;
            boolean added = infopointOffsets.add((Object)offset);
            if (!added) {
                throw VMError.shouldNotReachHere("Encoding two infopoints at same offset. Conflicting infopoint: " + infopoint);
            }
            IPData entry = this.makeEntry(offset + compilationOffset);
            assert (entry.referenceMap == null && (entry.frameData == null || entry.frameData.isDefaultFrameData));
            entry.referenceMap = (ReferenceMapEncoder.Input)debugInfo.getReferenceMap();
            entry.frameData = this.frameInfoEncoder.addDebugInfo(method, compilation, infopoint, totalFrameSize);
            if (entry.frameData == null || !entry.frameData.frame.isDeoptEntry || (added = deoptEntryBcis.add((Object)(encodedBci = FrameInfoEncoder.encodeBci((frame = debugInfo.frame()).getBCI(), frame.duringCall, frame.rethrowException))))) continue;
            throw VMError.shouldNotReachHere(String.format("Encoding two deopt entries at same encoded bci: %s (bci %s)%nmethod: %s", encodedBci, FrameInfoDecoder.readableBci(encodedBci), method));
        }
        for (ExceptionHandler handler : compilation.getExceptionHandlers()) {
            IPData entry = this.makeEntry(handler.pcOffset + compilationOffset);
            assert (entry.exceptionOffset == 0);
            entry.exceptionOffset = handler.handlerPos - handler.pcOffset;
        }
        ((Counters)ImageSingletons.lookup(Counters.class)).methodCount.inc();
        ((Counters)ImageSingletons.lookup(Counters.class)).codeSize.add(compilationSize);
    }

    private IPData makeEntry(long ip) {
        IPData result = this.entries.get(ip);
        if (result == null) {
            result = new IPData();
            result.ip = ip;
            this.entries.put(ip, result);
        }
        return result;
    }

    public void encodeAllAndInstall(CodeInfo target, ReferenceAdjuster adjuster) {
        this.encoders.encodeAllAndInstall(target, adjuster);
        this.encodeReferenceMaps();
        this.frameInfoEncoder.encodeAllAndInstall(target);
        this.encodeIPData();
        this.install(target);
    }

    private void install(CodeInfo target) {
        CodeInfoAccess.setCodeInfo(target, this.codeInfoIndex, this.codeInfoEncodings, this.referenceMapEncoding);
    }

    private void encodeReferenceMaps() {
        CodeReferenceMapEncoder referenceMapEncoder = new CodeReferenceMapEncoder();
        for (IPData data : this.entries.values()) {
            referenceMapEncoder.add(data.referenceMap);
        }
        this.referenceMapEncoding = referenceMapEncoder.encodeAll();
        ((Counters)ImageSingletons.lookup(Counters.class)).addToReferenceMapSize(referenceMapEncoder.getEncodingSize());
        for (IPData data : this.entries.values()) {
            data.referenceMapIndex = referenceMapEncoder.lookupEncoding(data.referenceMap);
        }
    }

    protected int encodeFrameSize(int totalFrameSize, boolean methodStart, boolean isEntryPoint, boolean hasCalleeSavedRegisters) {
        VMError.guarantee((totalFrameSize & 7) == 0, "Frame size must be aligned");
        return totalFrameSize | (methodStart ? 1 : 0) | (isEntryPoint ? 2 : 0) | (hasCalleeSavedRegisters ? 4 : 0);
    }

    private void encodeIPData() {
        IPData first = null;
        IPData prev = null;
        for (IPData cur : this.entries.values()) {
            if (first == null) {
                first = cur;
            } else {
                while (!TypeConversion.isU1((long)(cur.ip - prev.ip))) {
                    IPData filler = new IPData();
                    filler.ip = prev.ip + 255L;
                    prev.next = filler;
                    prev = filler;
                }
                prev.next = cur;
            }
            prev = cur;
        }
        long nextIndexIP = 0L;
        UnsafeArrayTypeWriter indexBuffer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        UnsafeArrayTypeWriter encodingBuffer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        IPData data = first;
        while (data != null) {
            assert (data.ip <= nextIndexIP);
            if (data.ip == nextIndexIP) {
                indexBuffer.putU4(encodingBuffer.getBytesWritten());
                nextIndexIP += CodeInfoDecoder.indexGranularity();
            }
            int entryFlags = 0;
            entryFlags |= CodeInfoEncoder.flagsForSizeEncoding(data) << 0;
            entryFlags |= CodeInfoEncoder.flagsForExceptionOffset(data) << 2;
            entryFlags |= CodeInfoEncoder.flagsForReferenceMapIndex(data) << 4;
            encodingBuffer.putU1((long)(entryFlags |= CodeInfoEncoder.flagsForDeoptFrameInfo(data) << 6));
            encodingBuffer.putU1(data.next == null ? 0L : data.next.ip - data.ip);
            CodeInfoEncoder.writeSizeEncoding(encodingBuffer, data, entryFlags);
            CodeInfoEncoder.writeExceptionOffset(encodingBuffer, data, entryFlags);
            CodeInfoEncoder.writeReferenceMapIndex(encodingBuffer, data, entryFlags);
            CodeInfoEncoder.writeEncodedFrameInfo(encodingBuffer, data, entryFlags);
            data = data.next;
        }
        this.codeInfoIndex = NonmovableArrays.createByteArray(TypeConversion.asU4((long)indexBuffer.getBytesWritten()));
        indexBuffer.toByteBuffer(NonmovableArrays.asByteBuffer(this.codeInfoIndex));
        this.codeInfoEncodings = NonmovableArrays.createByteArray(TypeConversion.asU4((long)encodingBuffer.getBytesWritten()));
        encodingBuffer.toByteBuffer(NonmovableArrays.asByteBuffer(this.codeInfoEncodings));
    }

    private static int flagsForSizeEncoding(IPData data) {
        if (data.frameSizeEncoding == 0) {
            return 0;
        }
        if (TypeConversion.isS1((long)data.frameSizeEncoding)) {
            return 1;
        }
        if (TypeConversion.isS2((long)data.frameSizeEncoding)) {
            return 2;
        }
        if (TypeConversion.isS4((long)data.frameSizeEncoding)) {
            return 3;
        }
        throw new IllegalArgumentException();
    }

    private static void writeSizeEncoding(UnsafeArrayTypeWriter writeBuffer, IPData data, int entryFlags) {
        switch (CodeInfoDecoder.extractFS(entryFlags)) {
            case 1: {
                writeBuffer.putS1((long)data.frameSizeEncoding);
                break;
            }
            case 2: {
                writeBuffer.putS2((long)data.frameSizeEncoding);
                break;
            }
            case 3: {
                writeBuffer.putS4((long)data.frameSizeEncoding);
            }
        }
    }

    private static int flagsForExceptionOffset(IPData data) {
        if (data.exceptionOffset == 0) {
            return 0;
        }
        if (TypeConversion.isS1((long)data.exceptionOffset)) {
            return 1;
        }
        if (TypeConversion.isS2((long)data.exceptionOffset)) {
            return 2;
        }
        if (TypeConversion.isS4((long)data.exceptionOffset)) {
            return 3;
        }
        throw new IllegalArgumentException();
    }

    private static void writeExceptionOffset(UnsafeArrayTypeWriter writeBuffer, IPData data, int entryFlags) {
        switch (CodeInfoDecoder.extractEX(entryFlags)) {
            case 1: {
                writeBuffer.putS1((long)data.exceptionOffset);
                break;
            }
            case 2: {
                writeBuffer.putS2((long)data.exceptionOffset);
                break;
            }
            case 3: {
                writeBuffer.putS4((long)data.exceptionOffset);
            }
        }
    }

    private static int flagsForReferenceMapIndex(IPData data) {
        if (data.referenceMap == null) {
            return 0;
        }
        if (data.referenceMap.isEmpty()) {
            return 1;
        }
        if (TypeConversion.isU2((long)data.referenceMapIndex)) {
            return 2;
        }
        if (TypeConversion.isU4((long)data.referenceMapIndex)) {
            return 3;
        }
        throw new IllegalArgumentException();
    }

    private static void writeReferenceMapIndex(UnsafeArrayTypeWriter writeBuffer, IPData data, int entryFlags) {
        switch (CodeInfoDecoder.extractRM(entryFlags)) {
            case 2: {
                writeBuffer.putU2(data.referenceMapIndex);
                break;
            }
            case 3: {
                writeBuffer.putU4(data.referenceMapIndex);
            }
        }
    }

    private static int flagsForDeoptFrameInfo(IPData data) {
        if (data.frameData == null) {
            return 0;
        }
        if (TypeConversion.isS4((long)data.frameData.encodedFrameInfoIndex)) {
            if (data.frameData.frame.isDeoptEntry) {
                return 1;
            }
            if (data.frameData.isDefaultFrameData) {
                return 3;
            }
            return 2;
        }
        throw new IllegalArgumentException();
    }

    private static void writeEncodedFrameInfo(UnsafeArrayTypeWriter writeBuffer, IPData data, int entryFlags) {
        switch (CodeInfoDecoder.extractFI(entryFlags)) {
            case 1: 
            case 2: 
            case 3: {
                writeBuffer.putS4(data.frameData.encodedFrameInfoIndex);
            }
        }
    }

    public static boolean verifyMethod(SharedMethod method, CompilationResult compilation, int compilationOffset, int compilationSize, CodeInfo info) {
        CodeInfoVerifier.verifyMethod(method, compilation, compilationOffset, compilationSize, info);
        return true;
    }

    public boolean verifyFrameInfo(CodeInfo info) {
        this.frameInfoEncoder.verifyEncoding(info);
        return true;
    }

    public static final class Encoders {
        public final FrequencyEncoder<JavaConstant> objectConstants = FrequencyEncoder.createEqualityEncoder();
        public final FrequencyEncoder<Class<?>> sourceClasses = FrequencyEncoder.createEqualityEncoder();
        public final FrequencyEncoder<String> sourceMethodNames = FrequencyEncoder.createEqualityEncoder();
        final FrequencyEncoder<String> names = FrequencyEncoder.createEqualityEncoder();

        private void encodeAllAndInstall(CodeInfo target, ReferenceAdjuster adjuster) {
            JavaConstant[] encodedJavaConstants = (JavaConstant[])this.objectConstants.encodeAll((Object[])new JavaConstant[this.objectConstants.getLength()]);
            Class[] sourceClassesArray = (Class[])this.sourceClasses.encodeAll((Object[])new Class[this.sourceClasses.getLength()]);
            String[] sourceMethodNamesArray = (String[])this.sourceMethodNames.encodeAll((Object[])new String[this.sourceMethodNames.getLength()]);
            Encoders.install(target, encodedJavaConstants, sourceClassesArray, sourceMethodNamesArray, adjuster);
        }

        @Uninterruptible(reason="Nonmovable object arrays are not visible to GC until installed in target.")
        private static void install(CodeInfo target, JavaConstant[] objectConstantsArray, Class<?>[] sourceClassesArray, String[] sourceMethodNamesArray, ReferenceAdjuster adjuster) {
            NonmovableObjectArray frameInfoObjectConstants = adjuster.copyOfObjectConstantArray((Constant[])objectConstantsArray);
            NonmovableObjectArray<Class<?>> frameInfoSourceClasses = sourceClassesArray != null ? adjuster.copyOfObjectArray(sourceClassesArray) : (NonmovableObjectArray<Class<?>>)NonmovableArrays.nullArray();
            NonmovableObjectArray<String> frameInfoSourceMethodNames = sourceMethodNamesArray != null ? adjuster.copyOfObjectArray(sourceMethodNamesArray) : (NonmovableObjectArray<String>)NonmovableArrays.nullArray();
            CodeInfoAccess.setEncodings(target, frameInfoObjectConstants, frameInfoSourceClasses, frameInfoSourceMethodNames);
        }
    }

    static class IPData {
        protected long ip;
        protected int frameSizeEncoding;
        protected int exceptionOffset;
        protected ReferenceMapEncoder.Input referenceMap;
        protected long referenceMapIndex;
        protected FrameInfoEncoder.FrameData frameData;
        protected IPData next;

        IPData() {
        }
    }

    public static class Counters {
        public final Counter.Group group = new Counter.Group(Options.CodeInfoEncoderCounters, "CodeInfoEncoder");
        final Counter methodCount = new Counter(this.group, "Number of methods", "Number of methods encoded");
        final Counter codeSize = new Counter(this.group, "Code size", "Total size of machine code");
        final Counter referenceMapSize = new Counter(this.group, "Reference map size", "Total size of encoded reference maps");
        final Counter frameInfoSize = new Counter(this.group, "Frame info size", "Total size of encoded frame information");
        final Counter frameCount = new Counter(this.group, "Number of frames", "Number of frames encoded");
        final Counter stackValueCount = new Counter(this.group, "Number of stack values", "Number of stack values encoded");
        final Counter registerValueCount = new Counter(this.group, "Number of register values", "Number of register values encoded");
        final Counter constantValueCount = new Counter(this.group, "Number of constant values", "Number of constant values encoded");
        final Counter virtualObjectsCount = new Counter(this.group, "Number of virtual objects", "Number of virtual objects encoded");

        public void addToReferenceMapSize(long size) {
            this.referenceMapSize.add(size);
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> CodeInfoEncoderCounters = new HostedOptionKey<Boolean>(false);
    }
}

