/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ReachabilityRegistrationNode;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.util.Set;
import jdk.internal.vm.annotation.ForceInline;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.extended.ValueAnchorNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.ValueProxy;
import org.graalvm.compiler.nodes.virtual.AllocatedObjectNode;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.replacements.nodes.MethodHandleWithExceptionNode;
import org.graalvm.nativeimage.AnnotationAccess;
import sun.invoke.util.ValueConversions;

public class InlineBeforeAnalysisPolicyUtils {
    public final int optionAllowedNodes = Options.InlineBeforeAnalysisAllowedNodes.getValue();
    public final int optionAllowedInvokes = Options.InlineBeforeAnalysisAllowedInvokes.getValue();
    public final int optionAllowedDepth = Options.InlineBeforeAnalysisAllowedDepth.getValue();
    public final int optionAllowedInlinings = Options.InlineBeforeAnalysisAllowedInlinings.getValue();
    public final int optionMethodHandleAllowedNodes = Options.InlineBeforeAnalysisMethodHandleAllowedNodes.getValue();
    public final int optionMethodHandleAllowedInvokes = Options.InlineBeforeAnalysisMethodHandleAllowedInvokes.getValue();
    public final int optionMethodHandleAllowedDepth = Options.InlineBeforeAnalysisMethodHandleAllowedDepth.getValue();
    public final int optionMethodHandleAllowedInlinings = Options.InlineBeforeAnalysisMethodHandleAllowedInlinings.getValue();
    public static final Class<? extends Annotation> COMPILED_LAMBDA_FORM_ANNOTATION = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.LambdaForm$Compiled");
    private static final Set<Class<?>> INLINE_METHOD_HANDLE_CLASSES = Set.of(ValueConversions.class);
    private static final Set<Executable> INLINE_METHOD_HANDLE_METHODS = Set.of(ReflectionUtil.lookupMethod((Class)ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.DirectMethodHandle"), (String)"allocateInstance", (Class[])new Class[]{Object.class}), ReflectionUtil.lookupMethod((Class)ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.DirectMethodHandle$Accessor"), (String)"checkCast", (Class[])new Class[]{Object.class}), ReflectionUtil.lookupMethod((Class)ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.DirectMethodHandle$StaticAccessor"), (String)"checkCast", (Class[])new Class[]{Object.class}));

    public boolean shouldInlineInvoke(GraphBuilderContext b, SVMHost hostVM, AccumulativeInlineScope policyScope, ResolvedJavaMethod method) {
        boolean result = this.shouldInlineInvoke0(b, hostVM, policyScope, method);
        if (result && policyScope != null) {
            ++policyScope.accumulativeCounters.totalInlinedMethods;
        }
        return result;
    }

    private boolean shouldInlineInvoke0(GraphBuilderContext b, SVMHost hostVM, AccumulativeInlineScope policyScope, ResolvedJavaMethod method) {
        int actualDepth;
        int allowedInlinings;
        if (!InlineBeforeAnalysisPolicyUtils.inliningAllowed(hostVM, b, method)) {
            return false;
        }
        if (this.alwaysInlineInvoke((AnalysisMetaAccess)b.getMetaAccess(), method)) {
            return true;
        }
        boolean inMethodHandleIntrinsification = policyScope != null && policyScope.accumulativeCounters.inMethodHandleIntrinsification;
        int n = allowedInlinings = inMethodHandleIntrinsification ? this.optionMethodHandleAllowedInlinings : this.optionAllowedInlinings;
        if (policyScope != null && policyScope.accumulativeCounters.totalInlinedMethods >= allowedInlinings) {
            return false;
        }
        int allowedDepth = inMethodHandleIntrinsification ? this.optionMethodHandleAllowedDepth : this.optionAllowedDepth;
        int n2 = actualDepth = policyScope == null ? 0 : policyScope.inliningDepth;
        if (actualDepth >= allowedDepth) {
            return false;
        }
        if (!inMethodHandleIntrinsification) {
            if (b.recursiveInliningDepth(method) > 0) {
                return false;
            }
            if (policyScope != null && AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, COMPILED_LAMBDA_FORM_ANNOTATION)) {
                return false;
            }
        }
        return true;
    }

    public static boolean inliningAllowed(SVMHost hostVM, GraphBuilderContext b, ResolvedJavaMethod method) {
        AnalysisMethod callee;
        AnalysisMethod caller = (AnalysisMethod)b.getMethod();
        if (hostVM.neverInlineTrivial(caller, callee = (AnalysisMethod)method)) {
            return false;
        }
        if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, Fold.class) || AnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, Node.NodeIntrinsic.class)) {
            return false;
        }
        if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, RestrictHeapAccess.class)) {
            return false;
        }
        if (!Uninterruptible.Utils.inliningAllowed((AnnotatedElement)caller, (AnnotatedElement)callee)) {
            return false;
        }
        return !callee.getReturnsAllInstantiatedTypes();
    }

    public boolean alwaysInlineInvoke(AnalysisMetaAccess metaAccess, ResolvedJavaMethod method) {
        return false;
    }

    public AccumulativeInlineScope createAccumulativeInlineScope(AccumulativeInlineScope outer, ResolvedJavaMethod m) {
        AccumulativeCounters accumulativeCounters;
        int depth;
        AnalysisMethod method = (AnalysisMethod)m;
        if (outer == null) {
            depth = 1;
            accumulativeCounters = AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, COMPILED_LAMBDA_FORM_ANNOTATION) ? new AccumulativeCounters(this.optionMethodHandleAllowedNodes, this.optionMethodHandleAllowedInvokes, true) : new AccumulativeCounters(this.optionAllowedNodes, this.optionAllowedInvokes, false);
        } else if (outer.accumulativeCounters.inMethodHandleIntrinsification && !InlineBeforeAnalysisPolicyUtils.inlineForMethodHandleIntrinsification(method)) {
            depth = 1;
            accumulativeCounters = new AccumulativeCounters(this.optionAllowedNodes, this.optionAllowedInvokes, false);
        } else {
            depth = outer.inliningDepth + 1;
            accumulativeCounters = outer.accumulativeCounters;
        }
        return new AccumulativeInlineScope(accumulativeCounters, depth);
    }

    private static boolean inlineForMethodHandleIntrinsification(AnalysisMethod method) {
        return AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, ForceInline.class) || AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, COMPILED_LAMBDA_FORM_ANNOTATION) || INLINE_METHOD_HANDLE_CLASSES.contains(method.getDeclaringClass().getJavaClass()) || INLINE_METHOD_HANDLE_METHODS.contains(method.getJavaMethod());
    }

    protected boolean shouldOmitIntermediateMethodInState(ResolvedJavaMethod method) {
        return method.isAnnotationPresent(COMPILED_LAMBDA_FORM_ANNOTATION);
    }

    public static class Options {
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisAllowedNodes = new HostedOptionKey<Integer>(1);
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisAllowedInvokes = new HostedOptionKey<Integer>(1);
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisAllowedDepth = new HostedOptionKey<Integer>(20);
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisAllowedInlinings = new HostedOptionKey<Integer>(10000);
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisMethodHandleAllowedNodes = new HostedOptionKey<Integer>(10000);
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisMethodHandleAllowedInvokes = new HostedOptionKey<Integer>(1000);
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisMethodHandleAllowedDepth = new HostedOptionKey<Integer>(1000);
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisMethodHandleAllowedInlinings = new HostedOptionKey<Integer>(10000);
    }

    public final class AccumulativeInlineScope
    extends InlineBeforeAnalysisPolicy.AbstractPolicyScope {
        final AccumulativeCounters accumulativeCounters;
        int numNodes;
        int numInvokes;

        AccumulativeInlineScope(AccumulativeCounters accumulativeCounters, int inliningDepth) {
            super(inliningDepth);
            this.numNodes = 0;
            this.numInvokes = 0;
            this.accumulativeCounters = accumulativeCounters;
        }

        public boolean allowAbort() {
            return true;
        }

        public void commitCalleeScope(InlineBeforeAnalysisPolicy.AbstractPolicyScope callee) {
            AccumulativeInlineScope calleeScope = (AccumulativeInlineScope)callee;
            if (this.accumulativeCounters != calleeScope.accumulativeCounters) {
                assert (this.accumulativeCounters.inMethodHandleIntrinsification != calleeScope.accumulativeCounters.inMethodHandleIntrinsification);
                this.accumulativeCounters.maxNodes += calleeScope.numNodes;
                this.accumulativeCounters.maxInvokes += calleeScope.numInvokes;
                this.accumulativeCounters.numNodes += calleeScope.numNodes;
                this.accumulativeCounters.numInvokes += calleeScope.numInvokes;
            }
            this.numNodes += calleeScope.numNodes;
            this.numInvokes += calleeScope.numInvokes;
        }

        public void abortCalleeScope(InlineBeforeAnalysisPolicy.AbstractPolicyScope callee) {
            AccumulativeInlineScope calleeScope = (AccumulativeInlineScope)callee;
            if (this.accumulativeCounters == calleeScope.accumulativeCounters) {
                this.accumulativeCounters.numNodes -= calleeScope.numNodes;
                this.accumulativeCounters.numInvokes -= calleeScope.numInvokes;
            } else assert (this.accumulativeCounters.inMethodHandleIntrinsification != calleeScope.accumulativeCounters.inMethodHandleIntrinsification);
        }

        public boolean processNode(AnalysisMetaAccess metaAccess, ResolvedJavaMethod method, Node node) {
            if (node instanceof StartNode || node instanceof ParameterNode || node instanceof ReturnNode || node instanceof UnwindNode || node instanceof CallTargetNode || node instanceof MethodHandleWithExceptionNode) {
                throw VMError.shouldNotReachHere("Node must not be visible to policy: " + node.getClass().getTypeName());
            }
            if (InlineBeforeAnalysisPolicyUtils.this.alwaysInlineInvoke(metaAccess, method)) {
                return true;
            }
            if (node instanceof FullInfopointNode || node instanceof ValueProxy || node instanceof ValueAnchorNode || node instanceof FrameState || node instanceof AbstractBeginNode || node instanceof AbstractEndNode) {
                return true;
            }
            if (node instanceof ConstantNode || node instanceof LogicConstantNode) {
                return true;
            }
            if (node instanceof ConditionalNode) {
                return true;
            }
            if (node instanceof ReachabilityRegistrationNode) {
                return true;
            }
            boolean allow = true;
            if (node instanceof AbstractNewObjectNode) {
                ValueNode newArrayLength;
                if (node instanceof NewArrayNode && (newArrayLength = ((NewArrayNode)node).length()).isJavaConstant() && newArrayLength.asJavaConstant().asInt() == 0) {
                    return true;
                }
                allow = false;
            } else if (node instanceof VirtualObjectNode) {
                int newArrayLength;
                if (node instanceof VirtualArrayNode && (newArrayLength = ((VirtualArrayNode)node).entryCount()) == 0) {
                    return true;
                }
                allow = false;
            } else if (node instanceof CommitAllocationNode || node instanceof AllocatedObjectNode) {
                return true;
            }
            if (node instanceof Invoke) {
                if (this.accumulativeCounters.numInvokes >= this.accumulativeCounters.maxInvokes) {
                    return false;
                }
                ++this.numInvokes;
                ++this.accumulativeCounters.numInvokes;
            }
            if (this.accumulativeCounters.numNodes >= this.accumulativeCounters.maxNodes) {
                return false;
            }
            ++this.numNodes;
            ++this.accumulativeCounters.numNodes;
            return allow || this.accumulativeCounters.inMethodHandleIntrinsification;
        }

        public boolean processNonInlinedInvoke(CoreProviders providers, CallTargetNode node) {
            return node.targetMethod() == null || !AnnotationAccess.isAnnotationPresent((AnnotatedElement)node.targetMethod(), COMPILED_LAMBDA_FORM_ANNOTATION);
        }

        public String toString() {
            return "AccumulativeInlineScope: " + this.numNodes + "/" + this.numInvokes + " (" + this.accumulativeCounters.numNodes + "/" + this.accumulativeCounters.numInvokes + ")";
        }
    }

    static final class AccumulativeCounters {
        int maxNodes;
        int maxInvokes;
        final boolean inMethodHandleIntrinsification;
        int numNodes;
        int numInvokes;
        int totalInlinedMethods;

        private AccumulativeCounters(int maxNodes, int maxInvokes, boolean inMethodHandleIntrinsification) {
            this.maxNodes = maxNodes;
            this.maxInvokes = maxInvokes;
            this.inMethodHandleIntrinsification = inMethodHandleIntrinsification;
        }
    }

    public static class AlwaysInlineScope
    extends InlineBeforeAnalysisPolicy.AbstractPolicyScope {
        public AlwaysInlineScope(int inliningDepth) {
            super(inliningDepth);
        }

        public boolean allowAbort() {
            return false;
        }

        public void commitCalleeScope(InlineBeforeAnalysisPolicy.AbstractPolicyScope callee) {
        }

        public void abortCalleeScope(InlineBeforeAnalysisPolicy.AbstractPolicyScope callee) {
        }

        public boolean processNode(AnalysisMetaAccess metaAccess, ResolvedJavaMethod method, Node node) {
            return true;
        }

        public boolean processNonInlinedInvoke(CoreProviders providers, CallTargetNode node) {
            return true;
        }

        public String toString() {
            return "AlwaysInlineScope";
        }
    }
}

