/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.methodhandles;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.methodhandles.MethodHandleInvokerSubstitutionType;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.meta.ResolvedJavaType;

public class MethodHandleInvokerRenamingSubstitutionProcessor
extends SubstitutionProcessor {
    private static final Method CLASS_GET_CLASS_DATA_METHOD = ReflectionUtil.lookupMethod(Class.class, (String)"getClassData", (Class[])new Class[0]);
    private static final Class<?> LAMBDA_FORM_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.LambdaForm");
    private static final Field LAMBDA_FORM_CUSTOMIZED_FIELD = ReflectionUtil.lookupField(LAMBDA_FORM_CLASS, (String)"customized");
    private static final Class<?> DIRECT_METHOD_HANDLE_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"java.lang.invoke.DirectMethodHandle");
    private static final Method DIRECT_METHOD_HANDLE_INTERNAL_MEMBER_NAME_METHOD = ReflectionUtil.lookupMethod(DIRECT_METHOD_HANDLE_CLASS, (String)"internalMemberName", (Class[])new Class[0]);
    private static final String CLASS_NAME_SUBSTRING = "LambdaForm$DMH";
    private static final String STABLE_NAME_TEMPLATE = "Ljava/lang/invoke/LambdaForm$DMH.s";
    private final BigBang bb;
    private final ConcurrentMap<ResolvedJavaType, MethodHandleInvokerSubstitutionType> typeSubstitutions = new ConcurrentHashMap<ResolvedJavaType, MethodHandleInvokerSubstitutionType>();
    private final Set<String> uniqueTypeNames = new HashSet<String>();

    MethodHandleInvokerRenamingSubstitutionProcessor(BigBang bb) {
        this.bb = bb;
    }

    public ResolvedJavaType lookup(ResolvedJavaType type) {
        if (!MethodHandleInvokerRenamingSubstitutionProcessor.shouldReplace(type)) {
            return type;
        }
        return this.getSubstitution(type);
    }

    private static boolean shouldReplace(ResolvedJavaType type) {
        return !(type instanceof MethodHandleInvokerSubstitutionType) && type.isFinalFlagSet() && type.getName().contains(CLASS_NAME_SUBSTRING);
    }

    public ResolvedJavaType resolve(ResolvedJavaType type) {
        if (type instanceof MethodHandleInvokerSubstitutionType) {
            return ((MethodHandleInvokerSubstitutionType)type).getOriginal();
        }
        return type;
    }

    private ResolvedJavaType getSubstitution(ResolvedJavaType type) {
        return this.typeSubstitutions.computeIfAbsent(type, original -> {
            Object lambdaForm;
            Object customizedMemberName;
            block5: {
                customizedMemberName = null;
                try {
                    List list;
                    Class clazz = OriginalClassProvider.getJavaClass((ResolvedJavaType)original);
                    Object classData = CLASS_GET_CLASS_DATA_METHOD.invoke((Object)clazz, new Object[0]);
                    if (LAMBDA_FORM_CLASS.isInstance(classData)) {
                        lambdaForm = classData;
                        break block5;
                    }
                    if (classData instanceof List && (list = (List)classData).size() == 2) {
                        lambdaForm = list.get(0);
                        Object customizedHandle = list.get(1);
                        VMError.guarantee(LAMBDA_FORM_CLASS.isInstance(lambdaForm) && DIRECT_METHOD_HANDLE_CLASS.isInstance(customizedHandle) && LAMBDA_FORM_CUSTOMIZED_FIELD.get(lambdaForm) == customizedHandle, "Expected classData to contain LambdaForm and its customization: %s", classData);
                        customizedMemberName = DIRECT_METHOD_HANDLE_INTERNAL_MEMBER_NAME_METHOD.invoke(customizedHandle, new Object[0]);
                        break block5;
                    }
                    throw VMError.shouldNotReachHere("Unexpected classData: %s", classData);
                }
                catch (ReflectiveOperationException e) {
                    throw VMError.shouldNotReachHere(e);
                }
            }
            int hash = lambdaForm.toString().hashCode();
            if (customizedMemberName != null) {
                hash = hash * 31 + customizedMemberName.toString().hashCode();
            }
            return new MethodHandleInvokerSubstitutionType((ResolvedJavaType)original, this.findUniqueName(hash));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findUniqueName(int hashCode) {
        String baseName = STABLE_NAME_TEMPLATE + Integer.toHexString(hashCode);
        String name = baseName + ";";
        Set<String> set = this.uniqueTypeNames;
        synchronized (set) {
            int suffix = 1;
            while (this.uniqueTypeNames.contains(name)) {
                name = baseName + "_" + suffix + ";";
                ++suffix;
            }
            this.uniqueTypeNames.add(name);
            return name;
        }
    }

    boolean checkAllTypeNames() {
        if (!SubstrateUtil.assertionsEnabled()) {
            throw new AssertionError((Object)"Expensive check: should only run with assertions enabled.");
        }
        List types = this.bb.getUniverse().getTypes();
        if (types.stream().anyMatch(aType -> MethodHandleInvokerRenamingSubstitutionProcessor.shouldReplace(aType.getWrapped()))) {
            throw new AssertionError((Object)"All relevant types must have been substituted.");
        }
        HashSet names = new HashSet();
        types.stream().map(AnalysisType::getName).filter(x -> x.contains(CLASS_NAME_SUBSTRING)).forEach(name -> {
            if (names.contains(name)) {
                throw new AssertionError((Object)("Duplicate name: " + name));
            }
            names.add(name);
        });
        return true;
    }
}

