/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.stubs;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.hosted.FeatureImpl;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.LocationIdentity;

@Platforms(value={Platform.AMD64.class, Platform.AARCH64.class})
public class StubForeignCallsFeatureBase
implements InternalFeature {
    private final Class<?> stubsHolder;
    private final StubDescriptor[] stubDescriptors;

    protected StubForeignCallsFeatureBase(Class<?> stubsHolder, StubDescriptor[] stubDescriptors) {
        this.stubsHolder = stubsHolder;
        this.stubDescriptors = stubDescriptors;
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return !SubstrateOptions.useLLVMBackend();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        for (StubDescriptor sd : this.stubDescriptors) {
            StubForeignCallsFeatureBase.registerStubRoots(access, sd.getStubs(this.stubsHolder));
        }
    }

    @Override
    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        for (StubDescriptor sd : this.stubDescriptors) {
            foreignCalls.register(sd.getStubs(this.stubsHolder));
        }
    }

    private static void registerStubRoots(Feature.BeforeAnalysisAccess access, SnippetRuntime.SubstrateForeignCallDescriptor[] foreignCalls) {
        FeatureImpl.BeforeAnalysisAccessImpl impl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        AnalysisMetaAccess metaAccess = impl.getMetaAccess();
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : foreignCalls) {
            AnalysisMethod method = (AnalysisMethod)descriptor.findMethod((MetaAccessProvider)metaAccess);
            impl.registerAsRoot(method, true, "Foreign call stubs, registered in " + StubForeignCallsFeatureBase.class, new MultiMethod.MultiMethodKey[0]);
        }
    }

    private static EnumSet<?> getBuildtimeFeatures() {
        Architecture arch = ((SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class))).arch;
        if (arch instanceof AMD64) {
            return ((AMD64)arch).getFeatures();
        }
        if (arch instanceof AArch64) {
            return ((AArch64)arch).getFeatures();
        }
        throw GraalError.unsupportedArchitecture((Architecture)arch);
    }

    public static final class StubDescriptor {
        private final ForeignCallDescriptor[] foreignCallDescriptors;
        private final Set<?> minimumRequiredFeatures;
        private final Function<ForeignCallDescriptor, EnumSet<?>> minimumRequiredFeaturesGetter;
        private final Set<?> runtimeCheckedCPUFeatures;
        private SnippetRuntime.SubstrateForeignCallDescriptor[] stubs;

        public StubDescriptor(ForeignCallDescriptor foreignCallDescriptors, EnumSet<?> minimumRequiredFeatures, EnumSet<?> runtimeCheckedCPUFeatures) {
            this(new ForeignCallDescriptor[]{foreignCallDescriptors}, minimumRequiredFeatures, runtimeCheckedCPUFeatures);
        }

        public StubDescriptor(ForeignCallDescriptor[] foreignCallDescriptors, EnumSet<?> minimumRequiredFeatures, EnumSet<?> runtimeCheckedCPUFeatures) {
            this.foreignCallDescriptors = foreignCallDescriptors;
            this.minimumRequiredFeatures = minimumRequiredFeatures;
            this.minimumRequiredFeaturesGetter = null;
            this.runtimeCheckedCPUFeatures = runtimeCheckedCPUFeatures;
        }

        public StubDescriptor(ForeignCallDescriptor[] foreignCallDescriptors, Function<ForeignCallDescriptor, EnumSet<?>> minimumRequiredFeaturesGetter, EnumSet<?> runtimeCheckedCPUFeatures) {
            this.foreignCallDescriptors = foreignCallDescriptors;
            this.minimumRequiredFeatures = null;
            this.minimumRequiredFeaturesGetter = minimumRequiredFeaturesGetter;
            this.runtimeCheckedCPUFeatures = runtimeCheckedCPUFeatures;
        }

        private SnippetRuntime.SubstrateForeignCallDescriptor[] getStubs(Class<?> stubsHolder) {
            if (this.stubs == null) {
                this.stubs = this.mapStubs(stubsHolder);
            }
            return this.stubs;
        }

        private SnippetRuntime.SubstrateForeignCallDescriptor[] mapStubs(Class<?> stubsHolder) {
            EnumSet<?> buildtimeCPUFeatures = StubForeignCallsFeatureBase.getBuildtimeFeatures();
            boolean isJITCompilationEnabled = RuntimeCompilation.isEnabled();
            boolean generateRuntimeChecked = !buildtimeCPUFeatures.containsAll(this.runtimeCheckedCPUFeatures) && isJITCompilationEnabled;
            ArrayList<SnippetRuntime.SubstrateForeignCallDescriptor> ret = new ArrayList<SnippetRuntime.SubstrateForeignCallDescriptor>();
            for (ForeignCallDescriptor call : this.foreignCallDescriptors) {
                boolean generateBaseline;
                Set<?> minimumFeatures = this.getMinimumRequiredFeatures(call);
                boolean bl = generateBaseline = buildtimeCPUFeatures.containsAll(minimumFeatures) || isJITCompilationEnabled && !minimumFeatures.equals(this.runtimeCheckedCPUFeatures);
                if (generateBaseline) {
                    ret.add(SnippetRuntime.findForeignCall(stubsHolder, call.getName(), call.isReexecutable(), new LocationIdentity[0]));
                }
                if (!generateRuntimeChecked) continue;
                ret.add(SnippetRuntime.findForeignCall(stubsHolder, call.getName() + "RTC", call.isReexecutable(), new LocationIdentity[0]));
            }
            return ret.toArray(new SnippetRuntime.SubstrateForeignCallDescriptor[0]);
        }

        private Set<?> getMinimumRequiredFeatures(ForeignCallDescriptor call) {
            if (this.minimumRequiredFeatures == null) {
                assert (this.minimumRequiredFeaturesGetter != null);
                return this.minimumRequiredFeaturesGetter.apply(call);
            }
            assert (this.minimumRequiredFeaturesGetter == null);
            return this.minimumRequiredFeatures;
        }
    }
}

