/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.JfrThreadState;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.sampler.SamplerBuffer;
import com.oracle.svm.core.sampler.SamplerBufferAccess;
import com.oracle.svm.core.sampler.SamplerSampleWriterData;
import com.oracle.svm.core.sampler.SamplerSampleWriterDataAccess;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class SamplerSampleWriter {
    public static final long JFR_STACK_TRACE_END = -1L;
    public static final long EXECUTION_SAMPLE_END = -2L;
    public static final int END_MARKER_SIZE = 8;

    private SamplerSampleWriter() {
    }

    @Fold
    public static int getHeaderSize() {
        return 40;
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    public static void begin(SamplerSampleWriterData data) {
        assert (SamplerSampleWriterDataAccess.verify(data));
        assert (SamplerSampleWriter.getUncommittedSize(data).equal(0));
        assert (data.getCurrentPos().unsignedRemainder(8).equal(0));
        SamplerSampleWriter.putInt(data, 0);
        SamplerSampleWriter.putInt(data, 0);
        SamplerSampleWriter.putInt(data, 0);
        SamplerSampleWriter.putInt(data, 0);
        SamplerSampleWriter.putLong(data, JfrTicks.elapsedTicks());
        SamplerSampleWriter.putLong(data, SubstrateJVM.getCurrentThreadId());
        SamplerSampleWriter.putLong(data, JfrThreadState.getId(Thread.State.RUNNABLE));
        assert (SamplerSampleWriter.getHeaderSize() % 8 == 0);
        assert (!SamplerSampleWriter.isValid(data) || SamplerSampleWriter.getUncommittedSize(data).equal(SamplerSampleWriter.getHeaderSize()));
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    public static boolean end(SamplerSampleWriterData data, long endMarker) {
        if (!SamplerSampleWriter.isValid(data)) {
            return false;
        }
        UnsignedWord sampleSize = SamplerSampleWriter.getSampleSize(data);
        SamplerSampleWriter.putUncheckedLong(data, endMarker);
        Pointer currentPos = data.getCurrentPos();
        data.setCurrentPos(data.getStartPos());
        SamplerSampleWriter.putUncheckedInt(data, data.getHashCode());
        SamplerSampleWriter.putUncheckedInt(data, data.getTruncated() ? 1 : 0);
        SamplerSampleWriter.putUncheckedInt(data, (int)sampleSize.rawValue());
        data.setCurrentPos(currentPos);
        SamplerSampleWriter.commit(data);
        return true;
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    public static boolean putLong(SamplerSampleWriterData data, long value) {
        if (SamplerSampleWriter.ensureSize(data, 8)) {
            SamplerSampleWriter.putUncheckedLong(data, value);
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    private static void putUncheckedLong(SamplerSampleWriterData data, long value) {
        assert (SamplerSampleWriter.getAvailableSize(data).aboveOrEqual(8));
        data.getCurrentPos().writeLong(0, value);
        SamplerSampleWriter.increaseCurrentPos(data, WordFactory.unsigned((int)8));
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    public static boolean putInt(SamplerSampleWriterData data, int value) {
        if (SamplerSampleWriter.ensureSize(data, 4)) {
            SamplerSampleWriter.putUncheckedInt(data, value);
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    private static void putUncheckedInt(SamplerSampleWriterData data, int value) {
        assert (SamplerSampleWriter.getAvailableSize(data).aboveOrEqual(4));
        data.getCurrentPos().writeInt(0, value);
        SamplerSampleWriter.increaseCurrentPos(data, WordFactory.unsigned((int)4));
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    private static void commit(SamplerSampleWriterData data) {
        assert (SamplerSampleWriter.isValid(data));
        assert (SamplerSampleWriter.getUncommittedSize(data).unsignedRemainder(8).equal(0));
        SamplerBuffer buffer = data.getSamplerBuffer();
        assert (buffer.getPos().equal((UnsignedWord)data.getStartPos()));
        assert (SamplerBufferAccess.getDataEnd(data.getSamplerBuffer()).equal((UnsignedWord)data.getEndPos()));
        Pointer newPosition = data.getCurrentPos();
        buffer.setPos(newPosition);
        data.setStartPos(newPosition);
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    private static boolean ensureSize(SamplerSampleWriterData data, int requested) {
        assert (requested > 0);
        if (!SamplerSampleWriter.isValid(data)) {
            return false;
        }
        int totalRequested = requested + 8;
        if (SamplerSampleWriter.getAvailableSize(data).belowThan(totalRequested) && !SamplerSampleWriter.accommodate(data, SamplerSampleWriter.getUncommittedSize(data))) {
            assert (!SamplerSampleWriter.isValid(data));
            return false;
        }
        assert (SamplerSampleWriter.getAvailableSize(data).aboveOrEqual(totalRequested));
        return true;
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    private static boolean accommodate(SamplerSampleWriterData data, UnsignedWord uncommitted) {
        if (SamplerBufferAccess.isEmpty(data.getSamplerBuffer())) {
            SamplerSampleWriter.cancel(data);
            return false;
        }
        SamplerBuffer newBuffer = SubstrateJVM.getSamplerBufferPool().acquireBuffer(data.getAllowBufferAllocation());
        if (newBuffer.isNull()) {
            SamplerSampleWriter.cancel(data);
            return false;
        }
        JfrThreadLocal.setSamplerBuffer(newBuffer);
        UnmanagedMemoryUtil.copy(data.getStartPos(), SamplerBufferAccess.getDataStart(newBuffer), uncommitted);
        SamplerBuffer oldBuffer = data.getSamplerBuffer();
        SubstrateJVM.getSamplerBufferPool().pushFullBuffer(oldBuffer);
        SubstrateJVM.getRecorderThread().signal();
        data.setSamplerBuffer(newBuffer);
        SamplerSampleWriter.reset(data);
        SamplerSampleWriter.increaseCurrentPos(data, uncommitted);
        return true;
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    private static void reset(SamplerSampleWriterData data) {
        SamplerBuffer buffer = data.getSamplerBuffer();
        data.setStartPos(buffer.getPos());
        data.setCurrentPos(buffer.getPos());
        data.setEndPos(SamplerBufferAccess.getDataEnd(buffer));
    }

    @Uninterruptible(reason="Accesses a native JFR buffer.", callerMustBe=true)
    private static void cancel(SamplerSampleWriterData data) {
        data.setEndPos((Pointer)WordFactory.nullPointer());
        JfrThreadLocal.increaseMissedSamples();
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    public static boolean isValid(SamplerSampleWriterData data) {
        return data.getEndPos().isNonNull();
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    private static UnsignedWord getAvailableSize(SamplerSampleWriterData data) {
        return data.getEndPos().subtract((UnsignedWord)data.getCurrentPos());
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    private static UnsignedWord getUncommittedSize(SamplerSampleWriterData data) {
        return data.getCurrentPos().subtract((UnsignedWord)data.getStartPos());
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    private static UnsignedWord getSampleSize(SamplerSampleWriterData data) {
        return SamplerSampleWriter.getUncommittedSize(data).subtract(SamplerSampleWriter.getHeaderSize());
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    private static void increaseCurrentPos(SamplerSampleWriterData data, UnsignedWord delta) {
        data.setCurrentPos(data.getCurrentPos().add(delta));
    }
}

