/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.localization.OptimizedLocalizationSupport;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;
import org.graalvm.nativeimage.impl.RuntimeResourceSupport;

public class LocalizationSupport {
    public final Map<String, Charset> charsets = new HashMap<String, Charset>();
    public final Locale defaultLocale;
    public final Locale[] allLocales;
    public final Set<String> supportedLanguageTags;
    public final ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT);
    public final Charset defaultCharset;

    public LocalizationSupport(Locale defaultLocale, Set<Locale> locales, Charset defaultCharset) {
        this.defaultLocale = defaultLocale;
        this.allLocales = locales.toArray(new Locale[0]);
        this.defaultCharset = defaultCharset;
        this.supportedLanguageTags = locales.stream().map(Locale::toString).collect(Collectors.toSet());
    }

    public boolean optimizedMode() {
        return false;
    }

    public boolean jvmMode() {
        return !this.optimizedMode();
    }

    public boolean substituteLoadLookup() {
        return false;
    }

    public OptimizedLocalizationSupport asOptimizedSupport() {
        GraalError.guarantee((boolean)this.optimizedMode(), (String)"Optimized support only available in optimized localization mode.");
        return (OptimizedLocalizationSupport)this;
    }

    public Map<String, Object> getBundleContentOf(Object bundle) {
        throw VMError.unsupportedFeature("Resource bundle lookup must be loaded during native image generation: " + bundle.getClass());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void prepareBundle(String bundleName, ResourceBundle bundle, Locale locale) {
        if (bundle instanceof PropertyResourceBundle) {
            Object resultingPattern;
            String[] bundleNameWithModule = SubstrateUtil.split(bundleName, ":", 2);
            if (bundleNameWithModule.length < 2) {
                resultingPattern = this.control.toBundleName(bundleName, locale).replace('.', '/');
            } else {
                String patternWithLocale = this.control.toBundleName(bundleNameWithModule[1], locale).replace('.', '/');
                resultingPattern = bundleNameWithModule[0] + ":" + patternWithLocale;
            }
            ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), (String)resultingPattern + "\\.properties");
        } else {
            this.registerRequiredReflectionAndResourcesForBundle(bundleName, Set.of(locale));
            RuntimeReflection.register((Class[])new Class[]{bundle.getClass()});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{bundle.getClass()});
            this.onBundlePrepared(bundle);
        }
    }

    public String getResultingPattern(String bundleName, Locale locale) {
        String fixedBundleName = bundleName.replace("$", "\\$");
        return this.getBundleName(fixedBundleName, locale);
    }

    private String getBundleName(String fixedBundleName, Locale locale) {
        String[] bundleNameWithModule = SubstrateUtil.split(fixedBundleName, ":", 2);
        if (bundleNameWithModule.length < 2) {
            return this.control.toBundleName(fixedBundleName, locale).replace('.', '/');
        }
        String patternWithLocale = this.control.toBundleName(bundleNameWithModule[1], locale).replace('.', '/');
        return bundleNameWithModule[0] + ":" + patternWithLocale;
    }

    public void registerRequiredReflectionAndResourcesForBundle(String baseName, Collection<Locale> wantedLocales) {
        int i = baseName.lastIndexOf(46);
        if (i > 0) {
            String name = baseName.substring(i + 1) + "Provider";
            String providerName = baseName.substring(0, i) + ".spi." + name;
            ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).registerClassLookup(ConfigurationCondition.alwaysTrue(), providerName);
        }
        ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).registerClassLookup(ConfigurationCondition.alwaysTrue(), baseName);
        for (Locale locale : wantedLocales) {
            this.registerRequiredReflectionAndResourcesForBundleAndLocale(baseName, locale);
        }
    }

    private void registerRequiredReflectionAndResourcesForBundleAndLocale(String baseName, Locale baseLocale) {
        for (Locale locale : this.control.getCandidateLocales(baseName, baseLocale)) {
            String bundleWithLocale = this.control.toBundleName(baseName, locale);
            RuntimeReflection.registerClassLookup((String)bundleWithLocale);
            Resources.singleton().registerNegativeQuery(bundleWithLocale.replace('.', '/') + ".properties");
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void onBundlePrepared(ResourceBundle bundle) {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void onClassBundlePrepared(Class<?> bundleClass) {
    }

    public boolean shouldSubstituteLoadLookup(String className) {
        return false;
    }

    public void prepareNonCompliant(Class<?> clazz) throws ReflectiveOperationException {
    }

    public boolean isNotIncluded(String bundleName) {
        return false;
    }

    public static Locale parseLocaleFromTag(String tag) {
        try {
            return new Locale.Builder().setLanguageTag(tag).build();
        }
        catch (IllformedLocaleException ex) {
            String[] parts = tag.split("-");
            switch (parts.length) {
                case 1: {
                    return new Locale(parts[0]);
                }
                case 2: {
                    return new Locale(parts[0], parts[1]);
                }
                case 3: {
                    return new Locale(parts[0], parts[1], parts[2]);
                }
            }
            return null;
        }
    }

    public void prepareClassResourceBundle(String basename, Class<?> bundleClass) {
        LocalizationSupport.registerNullaryConstructor(bundleClass);
        this.onClassBundlePrepared(bundleClass);
    }

    private static void registerNullaryConstructor(Class<?> bundleClass) {
        Constructor<?> nullaryConstructor;
        RuntimeReflection.register((Class[])new Class[]{bundleClass});
        try {
            nullaryConstructor = bundleClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            RuntimeReflection.registerConstructorLookup(bundleClass, (Class[])new Class[0]);
            return;
        }
        RuntimeReflection.register((Executable[])new Executable[]{nullaryConstructor});
    }
}

